# vim:noexpandtab:autoindent:tabstop=8:shiftwidth=8:filetype=make:
#

VPATH += :lib/:
vpath lib%so lib

.PHONY: header_file_check
header_file_check: $(find include -type f | grep -v CVS)
	build/scripts/compile-test.sh

include/smbios/version.h: version.mk
	@echo '#ifndef SMBIOS_VERSION_H'  > $@.new
	@echo '#define SMBIOS_VERSION_H'  >> $@.new
	@echo ' // This is an automatically generated file, do not edit.'  >> $@.new
	@echo ' // This file is generated in common.mk'  >> $@.new
	@echo ''  >> $@.new
	@echo '#define LIBSMBIOS_RELEASE_VERSION "$(RELEASE_VERSION)"'  >> $@.new
	@echo ' '  >> $@.new
	@echo '#endif'  >> $@.new
	@diff -q $@ $@.new >/dev/null 2>&1 || mv $@.new $@
	@rm -f $@.new

CLEAN_LIST += testResults.xml tmp
.PHONY: unit_test
unit_test:  ./cppunit/testAll 
	@echo "--------------------------"
	@echo " Running cppunit tests..."
	@echo "--------------------------"
	@[ -e tmp/ ] || mkdir tmp/
	@for i in ./cppunit/platform/opti $(UNIT_TEST_DATA_DIR); do \
		[ -e $$i/autotest_flag ] || continue	;\
		echo -e "\n\nRunning test for $$i" ;\
		LD_LIBRARY_PATH=lib/  ./cppunit/testAll $$(pwd)/cppunit $$(pwd)/tmp $$(basename $$i) $$i	;\
		[ $$? -eq 0 ] || exit 1	;\
	done

.PHONY: quick_test
quick_test:  ./cppunit/testAll 
	@echo "--------------------------"
	@echo " Running quick cppunit tests..."
	@echo "--------------------------"
	@[ -e tmp/ ] || mkdir tmp/
	@for i in ./cppunit/platform/opti $(UNIT_TEST_DATA_DIR); do \
		[ -e $$i/quicktest_flag ] || continue	;\
		echo -e "\n\nRunning test for $$i" ;\
		LD_LIBRARY_PATH=lib/  ./cppunit/testAll $$(pwd)/cppunit $$(pwd)/tmp $$(basename $$i) $$i	;\
		[ $$? -eq 0 ] || exit 1	;\
	done


.PHONY: coverage
coverage: ./cppunit/testAll-debug 
	@[ ! -e coverage ] || rm -rf coverage	
	@[ -e doc/reports ] || mkdir -p doc/reports
	mkdir coverage
	@find . -name \*.da -exec rm {} \;
	@echo "--------------------------"
	@echo " Running cppunit code coverage tests..."
	@echo "--------------------------"
	@[ -e tmp/ ] || mkdir tmp/
	for i in ./cppunit/platform/opti $(UNIT_TEST_DATA_DIR); do \
		[ -e $$i/autotest_flag ] || continue	;\
		echo -e "\n\nRunning test for $$i" ;\
		LD_LIBRARY_PATH=lib/  ./cppunit/testAll-debug $$(pwd)/cppunit $$(pwd)/tmp $$(basename $$i) $$i	;\
	done


	# works only for GCC 3.3+
	for i in $$(ls -d libraries/* | grep -v CVS | grep -v module.mk | grep -v Makefile) ; do	\
		for j in $$i/*.cpp; do		\
			gcov -p -o $$i $$j		;\
		done		;\
	done
	mv *.gcov coverage
	# remove all files that are not ours. (system headers and includes, mainly.)
	rm -f coverage/\#*.gcov
	@echo '/** \page code_coverage Automatically generated code coverage report' > doc/reports/code-coverage.txt
	@echo "Generated for $$(whoami) on $$(date)" >> doc/reports/code-coverage.txt
	@echo '<pre>' >> doc/reports/code-coverage.txt
	build/scripts/tr-report.py coverage/ | tee -a doc/reports/code-coverage.txt
	@echo "</pre>*/" >> doc/reports/code-coverage.txt
	

CLEAN_LIST += doc/reports
.PHONY: valgrind
valgrind: ./cppunit/testAll  
	@echo "--------------------------"
	@echo " Running cppunit memory leak detection tests..."
	@echo "--------------------------"
	@[ -e tmp/ ] || mkdir tmp/
	@[ -e doc/reports ] || mkdir -p doc/reports

	@echo '/** \page leak_detect Automatically generated leak detection report' > doc/reports/valgrind_output.temp
	@echo '\section leaks Leak detection report' >> doc/reports/valgrind_output.temp
	@echo "Generated for $$(whoami) on $$(date)" >> doc/reports/valgrind_output.temp
	@echo '<pre>' >> doc/reports/valgrind_output.temp

	@echo '\section leak_time Time to run leak detection report.' > doc/reports/valgrind_time.temp
	@echo '<pre>' >> doc/reports/valgrind_time.temp

	@for i in ./cppunit/platform/opti $(UNIT_TEST_DATA_DIR); do \
		[ -e $$i/autotest_flag ] || continue	;\
		echo -e "\n\nRunning test for $$i" ;\
		LD_LIBRARY_PATH=lib/  /usr/bin/time -v -a -o doc/reports/valgrind_time.temp valgrind -v --logfile-fd=3 --leak-check=yes  \
			./cppunit/testAll $$(pwd)/cppunit $$(pwd)/tmp $$(basename $$i) $$i	 \
			3>> doc/reports/valgrind_output.temp ;\
	done

	@echo "</pre>" >> doc/reports/valgrind_output.temp
	@echo "</pre>*/" >> doc/reports/valgrind_time.temp
	@cat doc/reports/valgrind_output.temp > doc/reports/valgrind_output.txt
	@cat doc/reports/valgrind_time.temp  >> doc/reports/valgrind_output.txt
	@rm doc/reports/valgrind_output.temp
	@rm doc/reports/valgrind_time.temp

.PHONY: quick_valgrind
quick_valgrind: ./cppunit/testAll
	@echo "--------------------------"
	@echo " Running quick cppunit memory leak detection tests..."
	@echo "--------------------------"
	@[ -e tmp/ ] || mkdir tmp/

	@for i in ./cppunit/platform/opti $(UNIT_TEST_DATA_DIR); do \
		[ -e $$i/quicktest_flag ] || continue	;\
		echo -e "\n\nRunning test for $$i" ;\
		LD_LIBRARY_PATH=lib/  valgrind -v --leak-check=yes \
		  	./cppunit/testAll $$(pwd)/cppunit $$(pwd)/tmp $$(basename $$i) $$i	;\
		[ $$? -eq 0 ] || exit 1	;\
	done



.PHONY: default xml all
noxml: $(BASE_LIBS) $(BASE_BINS)

xml: $(EXT_BINS) $(EXT_LIBS) 
all: xml $(DOCS)

DISTCLEAN_LIST += $(shell find . -name \*.d)
CLEAN_LIST += lib/ $(shell ls cppunit/test* 2>/dev/null)
CLEAN_LIST += $(wildcard *.rpm)
CLEAN_LIST += $(wildcard *.zip)
CLEAN_LIST += $(wildcard *.tar.bz2)
CLEAN_LIST += $(shell find . -name \*.o)
CLEAN_LIST += $(shell find . -name \*.lo)
CLEAN_LIST += $(shell find . -name \*.do)
CLEAN_LIST += $(shell find . -name \*.bb)
CLEAN_LIST += $(shell find . -name \*.bbg)
CLEAN_LIST += $(shell find . -name \*.da)
CLEAN_LIST += $(shell find . -name \*.gcov)
CLEAN_LIST += coverage

