// vim:expandtab:autoindent:tabstop=4:shiftwidth=4:filetype=c:cindent:
/*
 * Copyright (C) 2005 Dell Inc.
 *  by Michael Brown <Michael_E_Brown@dell.com>
 * Licensed under the Open Software License version 2.1
 *
 * Alternatively, you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.

 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 */

#ifdef EXPERIMENTAL_NOT_WORKING_DONT_EVEN_TRY_IT

#ifndef SMBIOSXMLIMPL_LIBXML2_H
#define SMBIOSXMLIMPL_LIBXML2_H

// compat header should always be first header
#include "smbios/compat.h"

#include <libxml/xmlmemory.h>
#include <libxml/parser.h>

#include "smbios/ISmbiosXml.h"
#include "../smbios/SmbiosImpl.h"

namespace smbios
{
    class SmbiosItemXml : public SmbiosItem
    {
    public:
        SmbiosItemXml (const SmbiosItem & source)
                : SmbiosItem(source), doc(0)
        {};

        explicit SmbiosItemXml (const smbiosLowlevel::smbios_structure_header *header = 0)
                : SmbiosItem(header), doc(0)
        {};

        virtual std::ostream & streamify( std::ostream & cout ) const;

        void setXmlFilePath( const std::string newFile, xmlDocPtr newDoc );

        // TODO: listFields
        using  SmbiosItem::getU8;
        using  SmbiosItem::getU16;
        using  SmbiosItem::getU32;
        using  SmbiosItem::getU64;
        using  SmbiosItem::getString;
        using  SmbiosItem::getBitfield;
        virtual u8 getU8( const std::string field ) const;
        virtual u16 getU16( const std::string field ) const;
        virtual u32 getU32( const std::string field ) const;
        virtual u64 getU64( const std::string field ) const;
        virtual u32 getBitfield( const std::string field, const std::string bitField) const;
        virtual const char* getString( const std::string field ) const;

    protected:
        std::string getTypeAsString() const;
        std::string xmlFile;
        xmlDocPtr doc;
    };

    class SmbiosTableXml : public virtual SmbiosTable
    {
    public:
        // ITERATORS!
        using  SmbiosTable::operator[];
        virtual iterator operator[]( const std::string & );
        virtual const_iterator operator[]( const std::string & ) const;

        virtual std::ostream & streamify(std::ostream & cout ) const;

        // CONSTRUCTORS/DESTRUCTORS
        virtual ~SmbiosTableXml();
        explicit SmbiosTableXml(std::vector<SmbiosStrategy *> initStrategyList, bool strictValidation = 0);

        void setXmlFilePath( std::string );
        int getTypeForString( const std::string )const;
        const std::string getStringForType( const int )const;

        const xmlDocPtr getXmlDoc() const;

    protected:
        // Private, should never construct empty object.
        SmbiosTableXml ();

        virtual ISmbiosItem &makeItem( const void *header = 0) const;

    protected:
        std::string xmlFile;
        xmlDocPtr doc;

    private:
        SmbiosTableXml (const SmbiosTable & source);
        SmbiosTableXml & operator = (const SmbiosTable & source);
    };
}

#endif /* SMBIOSXMLIMPL_LIBXML2_H */

#endif /* experimental */
