/* snap_accessors.c: simple accessor functions for libspectrum_snap
   Copyright (c) 2003-2009 Philip Kendall

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

   Author contact information:

   E-mail: philip-fuse@shadowmagic.org.uk

*/

/* NB: this file is autogenerated from snap_accessors.txt by accessor.pl */

#include <config.h>

#include "internals.h"

struct libspectrum_snap {

  /* Which machine are we using here? */

  libspectrum_machine machine;

  /* Registers and the like */

  libspectrum_byte a , f ; libspectrum_word bc , de , hl ;
  libspectrum_byte a_, f_; libspectrum_word bc_, de_, hl_;

  libspectrum_word ix, iy; libspectrum_byte i, r;
  libspectrum_word sp, pc, memptr;

  libspectrum_byte iff1, iff2, im;

  int halted;			/* Is the Z80 currently HALTed? */
  int last_instruction_ei;	/* Was the last instruction an EI? */
  int last_instruction_set_f;	/* Did the last instruction set Flags? */

  /* Custom ROM */
  int custom_rom;
  size_t custom_rom_pages;
  libspectrum_byte* roms[ 4 ];
  size_t rom_length[ 4 ];

  /* RAM */

  libspectrum_byte *pages[ SNAPSHOT_RAM_PAGES ];

  /* Data from .slt files */

  libspectrum_byte *slt[ SNAPSHOT_SLT_PAGES ];	/* Level data */
  size_t slt_length[ SNAPSHOT_SLT_PAGES ];	/* Length of each level */

  libspectrum_byte *slt_screen;	/* Loading screen */
  int slt_screen_level;		/* The id of the loading screen. Not used
				   for anything AFAIK, but I'll copy it
				   around just in case */

  /* Peripheral status */

  libspectrum_byte out_ula; libspectrum_dword tstates;

  libspectrum_byte out_128_memoryport;

  libspectrum_byte out_ay_registerport, ay_registers[16];

  /* Used for both the +3's and the Scorpion's 0x1ffd port */
  libspectrum_byte out_plus3_memoryport;

  /* Timex-specific bits */
  libspectrum_byte out_scld_hsr, out_scld_dec;

  /* Interface 1 status */
  int interface1_active;
  int interface1_paged;
  int interface1_drive_count;
  int interface1_custom_rom;
  libspectrum_byte* interface1_rom[1];
  size_t interface1_rom_length[1];	/* Length of the ROM */

  /* Betadisk status */
  int beta_active;
  int beta_paged;
  int beta_autoboot;
  int beta_drive_count;
  int beta_custom_rom;
  int beta_direction;	/* FDC seek direction:
			      zero => towards lower cylinders (hubwards)
			  non-zero => towards higher cylinders (rimwards) */
  libspectrum_byte beta_system, beta_track, beta_sector, beta_data,
    beta_status;
  libspectrum_byte *beta_rom[1];

  /* Plus D status */
  int plusd_active;
  int plusd_paged;
  int plusd_drive_count;
  int plusd_custom_rom;
  int plusd_direction;	/* FDC seek direction:
			      zero => towards lower cylinders (hubwards)
			  non-zero => towards higher cylinders (rimwards) */
  libspectrum_byte plusd_control, plusd_track, plusd_sector, plusd_data,
    plusd_status;
  libspectrum_byte *plusd_rom[1];
  libspectrum_byte *plusd_ram[1];

  /* Opus Discovery status */
  int opus_active;
  int opus_paged;
  int opus_drive_count;
  int opus_custom_rom;
  int opus_direction;	/* FDC seek direction:
			      zero => towards lower cylinders (hubwards)
			  non-zero => towards higher cylinders (rimwards) */
  libspectrum_byte opus_track, opus_sector, opus_data, opus_status;
  libspectrum_byte opus_data_reg_a, opus_data_dir_a, opus_control_a;
  libspectrum_byte opus_data_reg_b, opus_data_dir_b, opus_control_b;
  libspectrum_byte *opus_rom[1];
  libspectrum_byte *opus_ram[1];

  /* ZXATASP status */
  int zxatasp_active;
  int zxatasp_upload;
  int zxatasp_writeprotect;
  libspectrum_byte zxatasp_port_a, zxatasp_port_b, zxatasp_port_c;
  libspectrum_byte zxatasp_control;
  size_t zxatasp_pages;
  size_t zxatasp_current_page;
  libspectrum_byte *zxatasp_ram[ SNAPSHOT_ZXATASP_PAGES ];

  /* ZXCF status */
  int zxcf_active;
  int zxcf_upload;
  libspectrum_byte zxcf_memctl;
  size_t zxcf_pages;
  libspectrum_byte *zxcf_ram[ SNAPSHOT_ZXCF_PAGES ];

  /* Interface 2 cartridge */
  int interface2_active;
  libspectrum_byte *interface2_rom[1];

  /* Timex Dock cartridge */
  int dock_active;
  libspectrum_byte exrom_ram[ SNAPSHOT_DOCK_EXROM_PAGES ];
  libspectrum_byte *exrom_cart[ SNAPSHOT_DOCK_EXROM_PAGES ];
  libspectrum_byte dock_ram[ SNAPSHOT_DOCK_EXROM_PAGES ];
  libspectrum_byte *dock_cart[ SNAPSHOT_DOCK_EXROM_PAGES ];

  /* Keyboard emulation */
  int issue2;

  /* Joystick emulation */
  size_t joystick_active_count;
  libspectrum_joystick joystick_list[ SNAPSHOT_JOYSTICKS ];
  int joystick_inputs[ SNAPSHOT_JOYSTICKS ];

  /* Kempston mouse status */
  int kempston_mouse_active;

  /* Simple 8-bit IDE status */
  int simpleide_active;

  /* DivIDE status */
  int divide_active;
  int divide_eprom_writeprotect;
  int divide_paged;
  libspectrum_byte divide_control;
  size_t divide_pages;
  libspectrum_byte* divide_eprom[ 1 ];
  libspectrum_byte* divide_ram[ SNAPSHOT_DIVIDE_PAGES ];

  /* Fuller box status */
  int fuller_box_active;

  /* Melodik status */
  int melodik_active;

  /* Cheetah SpecDrum status */
  int specdrum_active;
  libspectrum_signed_byte specdrum_dac;

  /* Spectranet status */
  int spectranet_active;
  int spectranet_paged;
  int spectranet_paged_via_io;
  int spectranet_nmi_flipflop;
  int spectranet_programmable_trap_active;
  int spectranet_programmable_trap_msb;
  int spectranet_all_traps_disabled;
  int spectranet_rst8_trap_disabled;
  int spectranet_deny_downstream_a15;
  int spectranet_page_a;
  int spectranet_page_b;
  libspectrum_word spectranet_programmable_trap;
  libspectrum_byte *spectranet_w5100[1];
  libspectrum_byte *spectranet_flash[1];
  libspectrum_byte *spectranet_ram[1];

  /* Timings emulation */
  int late_timings;

  /* Printer emulation */
  int zx_printer_active;

  /* uSource emulation */
  int usource_active;
  int usource_paged;
  int usource_custom_rom;
  libspectrum_byte* usource_rom[1];
  size_t usource_rom_length[1];	/* Length of the ROM */

  /* DISCiPLE emulation */
  int disciple_active;
  int disciple_paged;
  int disciple_inhibit_button;
  int disciple_drive_count;
  int disciple_custom_rom;
  int disciple_direction;
  libspectrum_byte disciple_control;
  libspectrum_byte disciple_track;
  libspectrum_byte disciple_sector;
  libspectrum_byte disciple_data;
  libspectrum_byte disciple_status;
  libspectrum_byte* disciple_rom[1];
  size_t disciple_rom_length[1];
  libspectrum_byte* disciple_ram[1];

  /* Didaktik 80 MDOS 1 emulation */
  int didaktik80_active;
  int didaktik80_paged;
  int didaktik80_drive_count;
  int didaktik80_custom_rom;
  int didaktik80_direction;
  libspectrum_byte didaktik80_aux;
  libspectrum_byte didaktik80_track;
  libspectrum_byte didaktik80_sector;
  libspectrum_byte didaktik80_data;
  libspectrum_byte didaktik80_status;
  libspectrum_byte* didaktik80_rom[1];
  size_t didaktik80_rom_length[1];
  libspectrum_byte* didaktik80_ram[1];

  /* Covox status */
  int covox_active;
  libspectrum_byte covox_dac;

  /* Multiface One/128/3 emulation */
  int multiface_active;
  int multiface_paged;
  int multiface_model_one;
  int multiface_model_128;
  int multiface_model_3;
  int multiface_disabled;
  int multiface_software_lockout;
  int multiface_red_button_disabled;
  libspectrum_byte* multiface_ram[1];
  size_t multiface_ram_length[1];
};

/* Initialise a libspectrum_snap structure */
libspectrum_snap*
libspectrum_snap_alloc_internal( void )
{
  return libspectrum_new( libspectrum_snap, 1 );
}

libspectrum_machine
libspectrum_snap_machine( libspectrum_snap *snap )
{
  return snap->machine;
}

void
libspectrum_snap_set_machine( libspectrum_snap *snap, libspectrum_machine machine )
{
  snap->machine = machine;
}

libspectrum_byte
libspectrum_snap_a( libspectrum_snap *snap )
{
  return snap->a;
}

void
libspectrum_snap_set_a( libspectrum_snap *snap, libspectrum_byte a )
{
  snap->a = a;
}

libspectrum_byte
libspectrum_snap_f( libspectrum_snap *snap )
{
  return snap->f;
}

void
libspectrum_snap_set_f( libspectrum_snap *snap, libspectrum_byte f )
{
  snap->f = f;
}

libspectrum_word
libspectrum_snap_bc( libspectrum_snap *snap )
{
  return snap->bc;
}

void
libspectrum_snap_set_bc( libspectrum_snap *snap, libspectrum_word bc )
{
  snap->bc = bc;
}

libspectrum_word
libspectrum_snap_de( libspectrum_snap *snap )
{
  return snap->de;
}

void
libspectrum_snap_set_de( libspectrum_snap *snap, libspectrum_word de )
{
  snap->de = de;
}

libspectrum_word
libspectrum_snap_hl( libspectrum_snap *snap )
{
  return snap->hl;
}

void
libspectrum_snap_set_hl( libspectrum_snap *snap, libspectrum_word hl )
{
  snap->hl = hl;
}

libspectrum_byte
libspectrum_snap_a_( libspectrum_snap *snap )
{
  return snap->a_;
}

void
libspectrum_snap_set_a_( libspectrum_snap *snap, libspectrum_byte a_ )
{
  snap->a_ = a_;
}

libspectrum_byte
libspectrum_snap_f_( libspectrum_snap *snap )
{
  return snap->f_;
}

void
libspectrum_snap_set_f_( libspectrum_snap *snap, libspectrum_byte f_ )
{
  snap->f_ = f_;
}

libspectrum_word
libspectrum_snap_bc_( libspectrum_snap *snap )
{
  return snap->bc_;
}

void
libspectrum_snap_set_bc_( libspectrum_snap *snap, libspectrum_word bc_ )
{
  snap->bc_ = bc_;
}

libspectrum_word
libspectrum_snap_de_( libspectrum_snap *snap )
{
  return snap->de_;
}

void
libspectrum_snap_set_de_( libspectrum_snap *snap, libspectrum_word de_ )
{
  snap->de_ = de_;
}

libspectrum_word
libspectrum_snap_hl_( libspectrum_snap *snap )
{
  return snap->hl_;
}

void
libspectrum_snap_set_hl_( libspectrum_snap *snap, libspectrum_word hl_ )
{
  snap->hl_ = hl_;
}

libspectrum_word
libspectrum_snap_ix( libspectrum_snap *snap )
{
  return snap->ix;
}

void
libspectrum_snap_set_ix( libspectrum_snap *snap, libspectrum_word ix )
{
  snap->ix = ix;
}

libspectrum_word
libspectrum_snap_iy( libspectrum_snap *snap )
{
  return snap->iy;
}

void
libspectrum_snap_set_iy( libspectrum_snap *snap, libspectrum_word iy )
{
  snap->iy = iy;
}

libspectrum_byte
libspectrum_snap_i( libspectrum_snap *snap )
{
  return snap->i;
}

void
libspectrum_snap_set_i( libspectrum_snap *snap, libspectrum_byte i )
{
  snap->i = i;
}

libspectrum_byte
libspectrum_snap_r( libspectrum_snap *snap )
{
  return snap->r;
}

void
libspectrum_snap_set_r( libspectrum_snap *snap, libspectrum_byte r )
{
  snap->r = r;
}

libspectrum_word
libspectrum_snap_sp( libspectrum_snap *snap )
{
  return snap->sp;
}

void
libspectrum_snap_set_sp( libspectrum_snap *snap, libspectrum_word sp )
{
  snap->sp = sp;
}

libspectrum_word
libspectrum_snap_pc( libspectrum_snap *snap )
{
  return snap->pc;
}

void
libspectrum_snap_set_pc( libspectrum_snap *snap, libspectrum_word pc )
{
  snap->pc = pc;
}

libspectrum_word
libspectrum_snap_memptr( libspectrum_snap *snap )
{
  return snap->memptr;
}

void
libspectrum_snap_set_memptr( libspectrum_snap *snap, libspectrum_word memptr )
{
  snap->memptr = memptr;
}

libspectrum_byte
libspectrum_snap_iff1( libspectrum_snap *snap )
{
  return snap->iff1;
}

void
libspectrum_snap_set_iff1( libspectrum_snap *snap, libspectrum_byte iff1 )
{
  snap->iff1 = iff1;
}

libspectrum_byte
libspectrum_snap_iff2( libspectrum_snap *snap )
{
  return snap->iff2;
}

void
libspectrum_snap_set_iff2( libspectrum_snap *snap, libspectrum_byte iff2 )
{
  snap->iff2 = iff2;
}

libspectrum_byte
libspectrum_snap_im( libspectrum_snap *snap )
{
  return snap->im;
}

void
libspectrum_snap_set_im( libspectrum_snap *snap, libspectrum_byte im )
{
  snap->im = im;
}

libspectrum_dword
libspectrum_snap_tstates( libspectrum_snap *snap )
{
  return snap->tstates;
}

void
libspectrum_snap_set_tstates( libspectrum_snap *snap, libspectrum_dword tstates )
{
  snap->tstates = tstates;
}

int
libspectrum_snap_halted( libspectrum_snap *snap )
{
  return snap->halted;
}

void
libspectrum_snap_set_halted( libspectrum_snap *snap, int halted )
{
  snap->halted = halted;
}

int
libspectrum_snap_last_instruction_ei( libspectrum_snap *snap )
{
  return snap->last_instruction_ei;
}

void
libspectrum_snap_set_last_instruction_ei( libspectrum_snap *snap, int last_instruction_ei )
{
  snap->last_instruction_ei = last_instruction_ei;
}

int
libspectrum_snap_last_instruction_set_f( libspectrum_snap *snap )
{
  return snap->last_instruction_set_f;
}

void
libspectrum_snap_set_last_instruction_set_f( libspectrum_snap *snap, int last_instruction_set_f )
{
  snap->last_instruction_set_f = last_instruction_set_f;
}

libspectrum_byte
libspectrum_snap_out_ula( libspectrum_snap *snap )
{
  return snap->out_ula;
}

void
libspectrum_snap_set_out_ula( libspectrum_snap *snap, libspectrum_byte out_ula )
{
  snap->out_ula = out_ula;
}

libspectrum_byte
libspectrum_snap_out_128_memoryport( libspectrum_snap *snap )
{
  return snap->out_128_memoryport;
}

void
libspectrum_snap_set_out_128_memoryport( libspectrum_snap *snap, libspectrum_byte out_128_memoryport )
{
  snap->out_128_memoryport = out_128_memoryport;
}

libspectrum_byte
libspectrum_snap_out_plus3_memoryport( libspectrum_snap *snap )
{
  return snap->out_plus3_memoryport;
}

void
libspectrum_snap_set_out_plus3_memoryport( libspectrum_snap *snap, libspectrum_byte out_plus3_memoryport )
{
  snap->out_plus3_memoryport = out_plus3_memoryport;
}

libspectrum_byte
libspectrum_snap_out_ay_registerport( libspectrum_snap *snap )
{
  return snap->out_ay_registerport;
}

void
libspectrum_snap_set_out_ay_registerport( libspectrum_snap *snap, libspectrum_byte out_ay_registerport )
{
  snap->out_ay_registerport = out_ay_registerport;
}

libspectrum_byte
libspectrum_snap_ay_registers( libspectrum_snap *snap, int idx )
{
  return snap->ay_registers[idx];
}

void
libspectrum_snap_set_ay_registers( libspectrum_snap *snap, int idx, libspectrum_byte ay_registers )
{
  snap->ay_registers[idx] = ay_registers;
}

libspectrum_byte
libspectrum_snap_out_scld_hsr( libspectrum_snap *snap )
{
  return snap->out_scld_hsr;
}

void
libspectrum_snap_set_out_scld_hsr( libspectrum_snap *snap, libspectrum_byte out_scld_hsr )
{
  snap->out_scld_hsr = out_scld_hsr;
}

libspectrum_byte
libspectrum_snap_out_scld_dec( libspectrum_snap *snap )
{
  return snap->out_scld_dec;
}

void
libspectrum_snap_set_out_scld_dec( libspectrum_snap *snap, libspectrum_byte out_scld_dec )
{
  snap->out_scld_dec = out_scld_dec;
}

int
libspectrum_snap_interface1_active( libspectrum_snap *snap )
{
  return snap->interface1_active;
}

void
libspectrum_snap_set_interface1_active( libspectrum_snap *snap, int interface1_active )
{
  snap->interface1_active = interface1_active;
}

int
libspectrum_snap_interface1_paged( libspectrum_snap *snap )
{
  return snap->interface1_paged;
}

void
libspectrum_snap_set_interface1_paged( libspectrum_snap *snap, int interface1_paged )
{
  snap->interface1_paged = interface1_paged;
}

int
libspectrum_snap_interface1_drive_count( libspectrum_snap *snap )
{
  return snap->interface1_drive_count;
}

void
libspectrum_snap_set_interface1_drive_count( libspectrum_snap *snap, int interface1_drive_count )
{
  snap->interface1_drive_count = interface1_drive_count;
}

int
libspectrum_snap_interface1_custom_rom( libspectrum_snap *snap )
{
  return snap->interface1_custom_rom;
}

void
libspectrum_snap_set_interface1_custom_rom( libspectrum_snap *snap, int interface1_custom_rom )
{
  snap->interface1_custom_rom = interface1_custom_rom;
}

libspectrum_byte*
libspectrum_snap_interface1_rom( libspectrum_snap *snap, int idx )
{
  return snap->interface1_rom[idx];
}

void
libspectrum_snap_set_interface1_rom( libspectrum_snap *snap, int idx, libspectrum_byte* interface1_rom )
{
  snap->interface1_rom[idx] = interface1_rom;
}

size_t
libspectrum_snap_interface1_rom_length( libspectrum_snap *snap, int idx )
{
  return snap->interface1_rom_length[idx];
}

void
libspectrum_snap_set_interface1_rom_length( libspectrum_snap *snap, int idx, size_t interface1_rom_length )
{
  snap->interface1_rom_length[idx] = interface1_rom_length;
}

int
libspectrum_snap_beta_active( libspectrum_snap *snap )
{
  return snap->beta_active;
}

void
libspectrum_snap_set_beta_active( libspectrum_snap *snap, int beta_active )
{
  snap->beta_active = beta_active;
}

int
libspectrum_snap_beta_paged( libspectrum_snap *snap )
{
  return snap->beta_paged;
}

void
libspectrum_snap_set_beta_paged( libspectrum_snap *snap, int beta_paged )
{
  snap->beta_paged = beta_paged;
}

int
libspectrum_snap_beta_autoboot( libspectrum_snap *snap )
{
  return snap->beta_autoboot;
}

void
libspectrum_snap_set_beta_autoboot( libspectrum_snap *snap, int beta_autoboot )
{
  snap->beta_autoboot = beta_autoboot;
}

int
libspectrum_snap_beta_drive_count( libspectrum_snap *snap )
{
  return snap->beta_drive_count;
}

void
libspectrum_snap_set_beta_drive_count( libspectrum_snap *snap, int beta_drive_count )
{
  snap->beta_drive_count = beta_drive_count;
}

int
libspectrum_snap_beta_custom_rom( libspectrum_snap *snap )
{
  return snap->beta_custom_rom;
}

void
libspectrum_snap_set_beta_custom_rom( libspectrum_snap *snap, int beta_custom_rom )
{
  snap->beta_custom_rom = beta_custom_rom;
}

int
libspectrum_snap_beta_direction( libspectrum_snap *snap )
{
  return snap->beta_direction;
}

void
libspectrum_snap_set_beta_direction( libspectrum_snap *snap, int beta_direction )
{
  snap->beta_direction = beta_direction;
}

libspectrum_byte
libspectrum_snap_beta_system( libspectrum_snap *snap )
{
  return snap->beta_system;
}

void
libspectrum_snap_set_beta_system( libspectrum_snap *snap, libspectrum_byte beta_system )
{
  snap->beta_system = beta_system;
}

libspectrum_byte
libspectrum_snap_beta_track( libspectrum_snap *snap )
{
  return snap->beta_track;
}

void
libspectrum_snap_set_beta_track( libspectrum_snap *snap, libspectrum_byte beta_track )
{
  snap->beta_track = beta_track;
}

libspectrum_byte
libspectrum_snap_beta_sector( libspectrum_snap *snap )
{
  return snap->beta_sector;
}

void
libspectrum_snap_set_beta_sector( libspectrum_snap *snap, libspectrum_byte beta_sector )
{
  snap->beta_sector = beta_sector;
}

libspectrum_byte
libspectrum_snap_beta_data( libspectrum_snap *snap )
{
  return snap->beta_data;
}

void
libspectrum_snap_set_beta_data( libspectrum_snap *snap, libspectrum_byte beta_data )
{
  snap->beta_data = beta_data;
}

libspectrum_byte
libspectrum_snap_beta_status( libspectrum_snap *snap )
{
  return snap->beta_status;
}

void
libspectrum_snap_set_beta_status( libspectrum_snap *snap, libspectrum_byte beta_status )
{
  snap->beta_status = beta_status;
}

libspectrum_byte*
libspectrum_snap_beta_rom( libspectrum_snap *snap, int idx )
{
  return snap->beta_rom[idx];
}

void
libspectrum_snap_set_beta_rom( libspectrum_snap *snap, int idx, libspectrum_byte* beta_rom )
{
  snap->beta_rom[idx] = beta_rom;
}

int
libspectrum_snap_plusd_active( libspectrum_snap *snap )
{
  return snap->plusd_active;
}

void
libspectrum_snap_set_plusd_active( libspectrum_snap *snap, int plusd_active )
{
  snap->plusd_active = plusd_active;
}

int
libspectrum_snap_plusd_paged( libspectrum_snap *snap )
{
  return snap->plusd_paged;
}

void
libspectrum_snap_set_plusd_paged( libspectrum_snap *snap, int plusd_paged )
{
  snap->plusd_paged = plusd_paged;
}

int
libspectrum_snap_plusd_drive_count( libspectrum_snap *snap )
{
  return snap->plusd_drive_count;
}

void
libspectrum_snap_set_plusd_drive_count( libspectrum_snap *snap, int plusd_drive_count )
{
  snap->plusd_drive_count = plusd_drive_count;
}

int
libspectrum_snap_plusd_custom_rom( libspectrum_snap *snap )
{
  return snap->plusd_custom_rom;
}

void
libspectrum_snap_set_plusd_custom_rom( libspectrum_snap *snap, int plusd_custom_rom )
{
  snap->plusd_custom_rom = plusd_custom_rom;
}

int
libspectrum_snap_plusd_direction( libspectrum_snap *snap )
{
  return snap->plusd_direction;
}

void
libspectrum_snap_set_plusd_direction( libspectrum_snap *snap, int plusd_direction )
{
  snap->plusd_direction = plusd_direction;
}

libspectrum_byte
libspectrum_snap_plusd_control( libspectrum_snap *snap )
{
  return snap->plusd_control;
}

void
libspectrum_snap_set_plusd_control( libspectrum_snap *snap, libspectrum_byte plusd_control )
{
  snap->plusd_control = plusd_control;
}

libspectrum_byte
libspectrum_snap_plusd_track( libspectrum_snap *snap )
{
  return snap->plusd_track;
}

void
libspectrum_snap_set_plusd_track( libspectrum_snap *snap, libspectrum_byte plusd_track )
{
  snap->plusd_track = plusd_track;
}

libspectrum_byte
libspectrum_snap_plusd_sector( libspectrum_snap *snap )
{
  return snap->plusd_sector;
}

void
libspectrum_snap_set_plusd_sector( libspectrum_snap *snap, libspectrum_byte plusd_sector )
{
  snap->plusd_sector = plusd_sector;
}

libspectrum_byte
libspectrum_snap_plusd_data( libspectrum_snap *snap )
{
  return snap->plusd_data;
}

void
libspectrum_snap_set_plusd_data( libspectrum_snap *snap, libspectrum_byte plusd_data )
{
  snap->plusd_data = plusd_data;
}

libspectrum_byte
libspectrum_snap_plusd_status( libspectrum_snap *snap )
{
  return snap->plusd_status;
}

void
libspectrum_snap_set_plusd_status( libspectrum_snap *snap, libspectrum_byte plusd_status )
{
  snap->plusd_status = plusd_status;
}

libspectrum_byte*
libspectrum_snap_plusd_rom( libspectrum_snap *snap, int idx )
{
  return snap->plusd_rom[idx];
}

void
libspectrum_snap_set_plusd_rom( libspectrum_snap *snap, int idx, libspectrum_byte* plusd_rom )
{
  snap->plusd_rom[idx] = plusd_rom;
}

libspectrum_byte*
libspectrum_snap_plusd_ram( libspectrum_snap *snap, int idx )
{
  return snap->plusd_ram[idx];
}

void
libspectrum_snap_set_plusd_ram( libspectrum_snap *snap, int idx, libspectrum_byte* plusd_ram )
{
  snap->plusd_ram[idx] = plusd_ram;
}

int
libspectrum_snap_opus_active( libspectrum_snap *snap )
{
  return snap->opus_active;
}

void
libspectrum_snap_set_opus_active( libspectrum_snap *snap, int opus_active )
{
  snap->opus_active = opus_active;
}

int
libspectrum_snap_opus_paged( libspectrum_snap *snap )
{
  return snap->opus_paged;
}

void
libspectrum_snap_set_opus_paged( libspectrum_snap *snap, int opus_paged )
{
  snap->opus_paged = opus_paged;
}

int
libspectrum_snap_opus_drive_count( libspectrum_snap *snap )
{
  return snap->opus_drive_count;
}

void
libspectrum_snap_set_opus_drive_count( libspectrum_snap *snap, int opus_drive_count )
{
  snap->opus_drive_count = opus_drive_count;
}

int
libspectrum_snap_opus_custom_rom( libspectrum_snap *snap )
{
  return snap->opus_custom_rom;
}

void
libspectrum_snap_set_opus_custom_rom( libspectrum_snap *snap, int opus_custom_rom )
{
  snap->opus_custom_rom = opus_custom_rom;
}

int
libspectrum_snap_opus_direction( libspectrum_snap *snap )
{
  return snap->opus_direction;
}

void
libspectrum_snap_set_opus_direction( libspectrum_snap *snap, int opus_direction )
{
  snap->opus_direction = opus_direction;
}

libspectrum_byte
libspectrum_snap_opus_track( libspectrum_snap *snap )
{
  return snap->opus_track;
}

void
libspectrum_snap_set_opus_track( libspectrum_snap *snap, libspectrum_byte opus_track )
{
  snap->opus_track = opus_track;
}

libspectrum_byte
libspectrum_snap_opus_sector( libspectrum_snap *snap )
{
  return snap->opus_sector;
}

void
libspectrum_snap_set_opus_sector( libspectrum_snap *snap, libspectrum_byte opus_sector )
{
  snap->opus_sector = opus_sector;
}

libspectrum_byte
libspectrum_snap_opus_data( libspectrum_snap *snap )
{
  return snap->opus_data;
}

void
libspectrum_snap_set_opus_data( libspectrum_snap *snap, libspectrum_byte opus_data )
{
  snap->opus_data = opus_data;
}

libspectrum_byte
libspectrum_snap_opus_status( libspectrum_snap *snap )
{
  return snap->opus_status;
}

void
libspectrum_snap_set_opus_status( libspectrum_snap *snap, libspectrum_byte opus_status )
{
  snap->opus_status = opus_status;
}

libspectrum_byte
libspectrum_snap_opus_data_reg_a( libspectrum_snap *snap )
{
  return snap->opus_data_reg_a;
}

void
libspectrum_snap_set_opus_data_reg_a( libspectrum_snap *snap, libspectrum_byte opus_data_reg_a )
{
  snap->opus_data_reg_a = opus_data_reg_a;
}

libspectrum_byte
libspectrum_snap_opus_data_dir_a( libspectrum_snap *snap )
{
  return snap->opus_data_dir_a;
}

void
libspectrum_snap_set_opus_data_dir_a( libspectrum_snap *snap, libspectrum_byte opus_data_dir_a )
{
  snap->opus_data_dir_a = opus_data_dir_a;
}

libspectrum_byte
libspectrum_snap_opus_control_a( libspectrum_snap *snap )
{
  return snap->opus_control_a;
}

void
libspectrum_snap_set_opus_control_a( libspectrum_snap *snap, libspectrum_byte opus_control_a )
{
  snap->opus_control_a = opus_control_a;
}

libspectrum_byte
libspectrum_snap_opus_data_reg_b( libspectrum_snap *snap )
{
  return snap->opus_data_reg_b;
}

void
libspectrum_snap_set_opus_data_reg_b( libspectrum_snap *snap, libspectrum_byte opus_data_reg_b )
{
  snap->opus_data_reg_b = opus_data_reg_b;
}

libspectrum_byte
libspectrum_snap_opus_data_dir_b( libspectrum_snap *snap )
{
  return snap->opus_data_dir_b;
}

void
libspectrum_snap_set_opus_data_dir_b( libspectrum_snap *snap, libspectrum_byte opus_data_dir_b )
{
  snap->opus_data_dir_b = opus_data_dir_b;
}

libspectrum_byte
libspectrum_snap_opus_control_b( libspectrum_snap *snap )
{
  return snap->opus_control_b;
}

void
libspectrum_snap_set_opus_control_b( libspectrum_snap *snap, libspectrum_byte opus_control_b )
{
  snap->opus_control_b = opus_control_b;
}

libspectrum_byte*
libspectrum_snap_opus_rom( libspectrum_snap *snap, int idx )
{
  return snap->opus_rom[idx];
}

void
libspectrum_snap_set_opus_rom( libspectrum_snap *snap, int idx, libspectrum_byte* opus_rom )
{
  snap->opus_rom[idx] = opus_rom;
}

libspectrum_byte*
libspectrum_snap_opus_ram( libspectrum_snap *snap, int idx )
{
  return snap->opus_ram[idx];
}

void
libspectrum_snap_set_opus_ram( libspectrum_snap *snap, int idx, libspectrum_byte* opus_ram )
{
  snap->opus_ram[idx] = opus_ram;
}

int
libspectrum_snap_custom_rom( libspectrum_snap *snap )
{
  return snap->custom_rom;
}

void
libspectrum_snap_set_custom_rom( libspectrum_snap *snap, int custom_rom )
{
  snap->custom_rom = custom_rom;
}

size_t
libspectrum_snap_custom_rom_pages( libspectrum_snap *snap )
{
  return snap->custom_rom_pages;
}

void
libspectrum_snap_set_custom_rom_pages( libspectrum_snap *snap, size_t custom_rom_pages )
{
  snap->custom_rom_pages = custom_rom_pages;
}

libspectrum_byte*
libspectrum_snap_roms( libspectrum_snap *snap, int idx )
{
  return snap->roms[idx];
}

void
libspectrum_snap_set_roms( libspectrum_snap *snap, int idx, libspectrum_byte* roms )
{
  snap->roms[idx] = roms;
}

size_t
libspectrum_snap_rom_length( libspectrum_snap *snap, int idx )
{
  return snap->rom_length[idx];
}

void
libspectrum_snap_set_rom_length( libspectrum_snap *snap, int idx, size_t rom_length )
{
  snap->rom_length[idx] = rom_length;
}

libspectrum_byte*
libspectrum_snap_pages( libspectrum_snap *snap, int idx )
{
  return snap->pages[idx];
}

void
libspectrum_snap_set_pages( libspectrum_snap *snap, int idx, libspectrum_byte* pages )
{
  snap->pages[idx] = pages;
}

libspectrum_byte*
libspectrum_snap_slt( libspectrum_snap *snap, int idx )
{
  return snap->slt[idx];
}

void
libspectrum_snap_set_slt( libspectrum_snap *snap, int idx, libspectrum_byte* slt )
{
  snap->slt[idx] = slt;
}

size_t
libspectrum_snap_slt_length( libspectrum_snap *snap, int idx )
{
  return snap->slt_length[idx];
}

void
libspectrum_snap_set_slt_length( libspectrum_snap *snap, int idx, size_t slt_length )
{
  snap->slt_length[idx] = slt_length;
}

libspectrum_byte*
libspectrum_snap_slt_screen( libspectrum_snap *snap )
{
  return snap->slt_screen;
}

void
libspectrum_snap_set_slt_screen( libspectrum_snap *snap, libspectrum_byte* slt_screen )
{
  snap->slt_screen = slt_screen;
}

int
libspectrum_snap_slt_screen_level( libspectrum_snap *snap )
{
  return snap->slt_screen_level;
}

void
libspectrum_snap_set_slt_screen_level( libspectrum_snap *snap, int slt_screen_level )
{
  snap->slt_screen_level = slt_screen_level;
}

int
libspectrum_snap_zxatasp_active( libspectrum_snap *snap )
{
  return snap->zxatasp_active;
}

void
libspectrum_snap_set_zxatasp_active( libspectrum_snap *snap, int zxatasp_active )
{
  snap->zxatasp_active = zxatasp_active;
}

int
libspectrum_snap_zxatasp_upload( libspectrum_snap *snap )
{
  return snap->zxatasp_upload;
}

void
libspectrum_snap_set_zxatasp_upload( libspectrum_snap *snap, int zxatasp_upload )
{
  snap->zxatasp_upload = zxatasp_upload;
}

int
libspectrum_snap_zxatasp_writeprotect( libspectrum_snap *snap )
{
  return snap->zxatasp_writeprotect;
}

void
libspectrum_snap_set_zxatasp_writeprotect( libspectrum_snap *snap, int zxatasp_writeprotect )
{
  snap->zxatasp_writeprotect = zxatasp_writeprotect;
}

libspectrum_byte
libspectrum_snap_zxatasp_port_a( libspectrum_snap *snap )
{
  return snap->zxatasp_port_a;
}

void
libspectrum_snap_set_zxatasp_port_a( libspectrum_snap *snap, libspectrum_byte zxatasp_port_a )
{
  snap->zxatasp_port_a = zxatasp_port_a;
}

libspectrum_byte
libspectrum_snap_zxatasp_port_b( libspectrum_snap *snap )
{
  return snap->zxatasp_port_b;
}

void
libspectrum_snap_set_zxatasp_port_b( libspectrum_snap *snap, libspectrum_byte zxatasp_port_b )
{
  snap->zxatasp_port_b = zxatasp_port_b;
}

libspectrum_byte
libspectrum_snap_zxatasp_port_c( libspectrum_snap *snap )
{
  return snap->zxatasp_port_c;
}

void
libspectrum_snap_set_zxatasp_port_c( libspectrum_snap *snap, libspectrum_byte zxatasp_port_c )
{
  snap->zxatasp_port_c = zxatasp_port_c;
}

libspectrum_byte
libspectrum_snap_zxatasp_control( libspectrum_snap *snap )
{
  return snap->zxatasp_control;
}

void
libspectrum_snap_set_zxatasp_control( libspectrum_snap *snap, libspectrum_byte zxatasp_control )
{
  snap->zxatasp_control = zxatasp_control;
}

size_t
libspectrum_snap_zxatasp_pages( libspectrum_snap *snap )
{
  return snap->zxatasp_pages;
}

void
libspectrum_snap_set_zxatasp_pages( libspectrum_snap *snap, size_t zxatasp_pages )
{
  snap->zxatasp_pages = zxatasp_pages;
}

size_t
libspectrum_snap_zxatasp_current_page( libspectrum_snap *snap )
{
  return snap->zxatasp_current_page;
}

void
libspectrum_snap_set_zxatasp_current_page( libspectrum_snap *snap, size_t zxatasp_current_page )
{
  snap->zxatasp_current_page = zxatasp_current_page;
}

libspectrum_byte*
libspectrum_snap_zxatasp_ram( libspectrum_snap *snap, int idx )
{
  return snap->zxatasp_ram[idx];
}

void
libspectrum_snap_set_zxatasp_ram( libspectrum_snap *snap, int idx, libspectrum_byte* zxatasp_ram )
{
  snap->zxatasp_ram[idx] = zxatasp_ram;
}

int
libspectrum_snap_zxcf_active( libspectrum_snap *snap )
{
  return snap->zxcf_active;
}

void
libspectrum_snap_set_zxcf_active( libspectrum_snap *snap, int zxcf_active )
{
  snap->zxcf_active = zxcf_active;
}

int
libspectrum_snap_zxcf_upload( libspectrum_snap *snap )
{
  return snap->zxcf_upload;
}

void
libspectrum_snap_set_zxcf_upload( libspectrum_snap *snap, int zxcf_upload )
{
  snap->zxcf_upload = zxcf_upload;
}

libspectrum_byte
libspectrum_snap_zxcf_memctl( libspectrum_snap *snap )
{
  return snap->zxcf_memctl;
}

void
libspectrum_snap_set_zxcf_memctl( libspectrum_snap *snap, libspectrum_byte zxcf_memctl )
{
  snap->zxcf_memctl = zxcf_memctl;
}

size_t
libspectrum_snap_zxcf_pages( libspectrum_snap *snap )
{
  return snap->zxcf_pages;
}

void
libspectrum_snap_set_zxcf_pages( libspectrum_snap *snap, size_t zxcf_pages )
{
  snap->zxcf_pages = zxcf_pages;
}

libspectrum_byte*
libspectrum_snap_zxcf_ram( libspectrum_snap *snap, int idx )
{
  return snap->zxcf_ram[idx];
}

void
libspectrum_snap_set_zxcf_ram( libspectrum_snap *snap, int idx, libspectrum_byte* zxcf_ram )
{
  snap->zxcf_ram[idx] = zxcf_ram;
}

int
libspectrum_snap_interface2_active( libspectrum_snap *snap )
{
  return snap->interface2_active;
}

void
libspectrum_snap_set_interface2_active( libspectrum_snap *snap, int interface2_active )
{
  snap->interface2_active = interface2_active;
}

libspectrum_byte*
libspectrum_snap_interface2_rom( libspectrum_snap *snap, int idx )
{
  return snap->interface2_rom[idx];
}

void
libspectrum_snap_set_interface2_rom( libspectrum_snap *snap, int idx, libspectrum_byte* interface2_rom )
{
  snap->interface2_rom[idx] = interface2_rom;
}

int
libspectrum_snap_dock_active( libspectrum_snap *snap )
{
  return snap->dock_active;
}

void
libspectrum_snap_set_dock_active( libspectrum_snap *snap, int dock_active )
{
  snap->dock_active = dock_active;
}

libspectrum_byte
libspectrum_snap_exrom_ram( libspectrum_snap *snap, int idx )
{
  return snap->exrom_ram[idx];
}

void
libspectrum_snap_set_exrom_ram( libspectrum_snap *snap, int idx, libspectrum_byte exrom_ram )
{
  snap->exrom_ram[idx] = exrom_ram;
}

libspectrum_byte*
libspectrum_snap_exrom_cart( libspectrum_snap *snap, int idx )
{
  return snap->exrom_cart[idx];
}

void
libspectrum_snap_set_exrom_cart( libspectrum_snap *snap, int idx, libspectrum_byte* exrom_cart )
{
  snap->exrom_cart[idx] = exrom_cart;
}

libspectrum_byte
libspectrum_snap_dock_ram( libspectrum_snap *snap, int idx )
{
  return snap->dock_ram[idx];
}

void
libspectrum_snap_set_dock_ram( libspectrum_snap *snap, int idx, libspectrum_byte dock_ram )
{
  snap->dock_ram[idx] = dock_ram;
}

libspectrum_byte*
libspectrum_snap_dock_cart( libspectrum_snap *snap, int idx )
{
  return snap->dock_cart[idx];
}

void
libspectrum_snap_set_dock_cart( libspectrum_snap *snap, int idx, libspectrum_byte* dock_cart )
{
  snap->dock_cart[idx] = dock_cart;
}

int
libspectrum_snap_issue2( libspectrum_snap *snap )
{
  return snap->issue2;
}

void
libspectrum_snap_set_issue2( libspectrum_snap *snap, int issue2 )
{
  snap->issue2 = issue2;
}

size_t
libspectrum_snap_joystick_active_count( libspectrum_snap *snap )
{
  return snap->joystick_active_count;
}

void
libspectrum_snap_set_joystick_active_count( libspectrum_snap *snap, size_t joystick_active_count )
{
  snap->joystick_active_count = joystick_active_count;
}

libspectrum_joystick
libspectrum_snap_joystick_list( libspectrum_snap *snap, int idx )
{
  return snap->joystick_list[idx];
}

void
libspectrum_snap_set_joystick_list( libspectrum_snap *snap, int idx, libspectrum_joystick joystick_list )
{
  snap->joystick_list[idx] = joystick_list;
}

int
libspectrum_snap_joystick_inputs( libspectrum_snap *snap, int idx )
{
  return snap->joystick_inputs[idx];
}

void
libspectrum_snap_set_joystick_inputs( libspectrum_snap *snap, int idx, int joystick_inputs )
{
  snap->joystick_inputs[idx] = joystick_inputs;
}

int
libspectrum_snap_kempston_mouse_active( libspectrum_snap *snap )
{
  return snap->kempston_mouse_active;
}

void
libspectrum_snap_set_kempston_mouse_active( libspectrum_snap *snap, int kempston_mouse_active )
{
  snap->kempston_mouse_active = kempston_mouse_active;
}

int
libspectrum_snap_simpleide_active( libspectrum_snap *snap )
{
  return snap->simpleide_active;
}

void
libspectrum_snap_set_simpleide_active( libspectrum_snap *snap, int simpleide_active )
{
  snap->simpleide_active = simpleide_active;
}

int
libspectrum_snap_divide_active( libspectrum_snap *snap )
{
  return snap->divide_active;
}

void
libspectrum_snap_set_divide_active( libspectrum_snap *snap, int divide_active )
{
  snap->divide_active = divide_active;
}

int
libspectrum_snap_divide_eprom_writeprotect( libspectrum_snap *snap )
{
  return snap->divide_eprom_writeprotect;
}

void
libspectrum_snap_set_divide_eprom_writeprotect( libspectrum_snap *snap, int divide_eprom_writeprotect )
{
  snap->divide_eprom_writeprotect = divide_eprom_writeprotect;
}

int
libspectrum_snap_divide_paged( libspectrum_snap *snap )
{
  return snap->divide_paged;
}

void
libspectrum_snap_set_divide_paged( libspectrum_snap *snap, int divide_paged )
{
  snap->divide_paged = divide_paged;
}

libspectrum_byte
libspectrum_snap_divide_control( libspectrum_snap *snap )
{
  return snap->divide_control;
}

void
libspectrum_snap_set_divide_control( libspectrum_snap *snap, libspectrum_byte divide_control )
{
  snap->divide_control = divide_control;
}

size_t
libspectrum_snap_divide_pages( libspectrum_snap *snap )
{
  return snap->divide_pages;
}

void
libspectrum_snap_set_divide_pages( libspectrum_snap *snap, size_t divide_pages )
{
  snap->divide_pages = divide_pages;
}

libspectrum_byte*
libspectrum_snap_divide_eprom( libspectrum_snap *snap, int idx )
{
  return snap->divide_eprom[idx];
}

void
libspectrum_snap_set_divide_eprom( libspectrum_snap *snap, int idx, libspectrum_byte* divide_eprom )
{
  snap->divide_eprom[idx] = divide_eprom;
}

libspectrum_byte*
libspectrum_snap_divide_ram( libspectrum_snap *snap, int idx )
{
  return snap->divide_ram[idx];
}

void
libspectrum_snap_set_divide_ram( libspectrum_snap *snap, int idx, libspectrum_byte* divide_ram )
{
  snap->divide_ram[idx] = divide_ram;
}

int
libspectrum_snap_fuller_box_active( libspectrum_snap *snap )
{
  return snap->fuller_box_active;
}

void
libspectrum_snap_set_fuller_box_active( libspectrum_snap *snap, int fuller_box_active )
{
  snap->fuller_box_active = fuller_box_active;
}

int
libspectrum_snap_melodik_active( libspectrum_snap *snap )
{
  return snap->melodik_active;
}

void
libspectrum_snap_set_melodik_active( libspectrum_snap *snap, int melodik_active )
{
  snap->melodik_active = melodik_active;
}

int
libspectrum_snap_specdrum_active( libspectrum_snap *snap )
{
  return snap->specdrum_active;
}

void
libspectrum_snap_set_specdrum_active( libspectrum_snap *snap, int specdrum_active )
{
  snap->specdrum_active = specdrum_active;
}

libspectrum_signed_byte
libspectrum_snap_specdrum_dac( libspectrum_snap *snap )
{
  return snap->specdrum_dac;
}

void
libspectrum_snap_set_specdrum_dac( libspectrum_snap *snap, libspectrum_signed_byte specdrum_dac )
{
  snap->specdrum_dac = specdrum_dac;
}

int
libspectrum_snap_spectranet_active( libspectrum_snap *snap )
{
  return snap->spectranet_active;
}

void
libspectrum_snap_set_spectranet_active( libspectrum_snap *snap, int spectranet_active )
{
  snap->spectranet_active = spectranet_active;
}

int
libspectrum_snap_spectranet_paged( libspectrum_snap *snap )
{
  return snap->spectranet_paged;
}

void
libspectrum_snap_set_spectranet_paged( libspectrum_snap *snap, int spectranet_paged )
{
  snap->spectranet_paged = spectranet_paged;
}

int
libspectrum_snap_spectranet_paged_via_io( libspectrum_snap *snap )
{
  return snap->spectranet_paged_via_io;
}

void
libspectrum_snap_set_spectranet_paged_via_io( libspectrum_snap *snap, int spectranet_paged_via_io )
{
  snap->spectranet_paged_via_io = spectranet_paged_via_io;
}

int
libspectrum_snap_spectranet_nmi_flipflop( libspectrum_snap *snap )
{
  return snap->spectranet_nmi_flipflop;
}

void
libspectrum_snap_set_spectranet_nmi_flipflop( libspectrum_snap *snap, int spectranet_nmi_flipflop )
{
  snap->spectranet_nmi_flipflop = spectranet_nmi_flipflop;
}

int
libspectrum_snap_spectranet_programmable_trap_active( libspectrum_snap *snap )
{
  return snap->spectranet_programmable_trap_active;
}

void
libspectrum_snap_set_spectranet_programmable_trap_active( libspectrum_snap *snap, int spectranet_programmable_trap_active )
{
  snap->spectranet_programmable_trap_active = spectranet_programmable_trap_active;
}

int
libspectrum_snap_spectranet_programmable_trap_msb( libspectrum_snap *snap )
{
  return snap->spectranet_programmable_trap_msb;
}

void
libspectrum_snap_set_spectranet_programmable_trap_msb( libspectrum_snap *snap, int spectranet_programmable_trap_msb )
{
  snap->spectranet_programmable_trap_msb = spectranet_programmable_trap_msb;
}

int
libspectrum_snap_spectranet_all_traps_disabled( libspectrum_snap *snap )
{
  return snap->spectranet_all_traps_disabled;
}

void
libspectrum_snap_set_spectranet_all_traps_disabled( libspectrum_snap *snap, int spectranet_all_traps_disabled )
{
  snap->spectranet_all_traps_disabled = spectranet_all_traps_disabled;
}

int
libspectrum_snap_spectranet_rst8_trap_disabled( libspectrum_snap *snap )
{
  return snap->spectranet_rst8_trap_disabled;
}

void
libspectrum_snap_set_spectranet_rst8_trap_disabled( libspectrum_snap *snap, int spectranet_rst8_trap_disabled )
{
  snap->spectranet_rst8_trap_disabled = spectranet_rst8_trap_disabled;
}

int
libspectrum_snap_spectranet_deny_downstream_a15( libspectrum_snap *snap )
{
  return snap->spectranet_deny_downstream_a15;
}

void
libspectrum_snap_set_spectranet_deny_downstream_a15( libspectrum_snap *snap, int spectranet_deny_downstream_a15 )
{
  snap->spectranet_deny_downstream_a15 = spectranet_deny_downstream_a15;
}

int
libspectrum_snap_spectranet_page_a( libspectrum_snap *snap )
{
  return snap->spectranet_page_a;
}

void
libspectrum_snap_set_spectranet_page_a( libspectrum_snap *snap, int spectranet_page_a )
{
  snap->spectranet_page_a = spectranet_page_a;
}

int
libspectrum_snap_spectranet_page_b( libspectrum_snap *snap )
{
  return snap->spectranet_page_b;
}

void
libspectrum_snap_set_spectranet_page_b( libspectrum_snap *snap, int spectranet_page_b )
{
  snap->spectranet_page_b = spectranet_page_b;
}

libspectrum_word
libspectrum_snap_spectranet_programmable_trap( libspectrum_snap *snap )
{
  return snap->spectranet_programmable_trap;
}

void
libspectrum_snap_set_spectranet_programmable_trap( libspectrum_snap *snap, libspectrum_word spectranet_programmable_trap )
{
  snap->spectranet_programmable_trap = spectranet_programmable_trap;
}

libspectrum_byte*
libspectrum_snap_spectranet_w5100( libspectrum_snap *snap, int idx )
{
  return snap->spectranet_w5100[idx];
}

void
libspectrum_snap_set_spectranet_w5100( libspectrum_snap *snap, int idx, libspectrum_byte* spectranet_w5100 )
{
  snap->spectranet_w5100[idx] = spectranet_w5100;
}

libspectrum_byte*
libspectrum_snap_spectranet_flash( libspectrum_snap *snap, int idx )
{
  return snap->spectranet_flash[idx];
}

void
libspectrum_snap_set_spectranet_flash( libspectrum_snap *snap, int idx, libspectrum_byte* spectranet_flash )
{
  snap->spectranet_flash[idx] = spectranet_flash;
}

libspectrum_byte*
libspectrum_snap_spectranet_ram( libspectrum_snap *snap, int idx )
{
  return snap->spectranet_ram[idx];
}

void
libspectrum_snap_set_spectranet_ram( libspectrum_snap *snap, int idx, libspectrum_byte* spectranet_ram )
{
  snap->spectranet_ram[idx] = spectranet_ram;
}

int
libspectrum_snap_late_timings( libspectrum_snap *snap )
{
  return snap->late_timings;
}

void
libspectrum_snap_set_late_timings( libspectrum_snap *snap, int late_timings )
{
  snap->late_timings = late_timings;
}

int
libspectrum_snap_zx_printer_active( libspectrum_snap *snap )
{
  return snap->zx_printer_active;
}

void
libspectrum_snap_set_zx_printer_active( libspectrum_snap *snap, int zx_printer_active )
{
  snap->zx_printer_active = zx_printer_active;
}

int
libspectrum_snap_usource_active( libspectrum_snap *snap )
{
  return snap->usource_active;
}

void
libspectrum_snap_set_usource_active( libspectrum_snap *snap, int usource_active )
{
  snap->usource_active = usource_active;
}

int
libspectrum_snap_usource_paged( libspectrum_snap *snap )
{
  return snap->usource_paged;
}

void
libspectrum_snap_set_usource_paged( libspectrum_snap *snap, int usource_paged )
{
  snap->usource_paged = usource_paged;
}

int
libspectrum_snap_usource_custom_rom( libspectrum_snap *snap )
{
  return snap->usource_custom_rom;
}

void
libspectrum_snap_set_usource_custom_rom( libspectrum_snap *snap, int usource_custom_rom )
{
  snap->usource_custom_rom = usource_custom_rom;
}

libspectrum_byte*
libspectrum_snap_usource_rom( libspectrum_snap *snap, int idx )
{
  return snap->usource_rom[idx];
}

void
libspectrum_snap_set_usource_rom( libspectrum_snap *snap, int idx, libspectrum_byte* usource_rom )
{
  snap->usource_rom[idx] = usource_rom;
}

size_t
libspectrum_snap_usource_rom_length( libspectrum_snap *snap, int idx )
{
  return snap->usource_rom_length[idx];
}

void
libspectrum_snap_set_usource_rom_length( libspectrum_snap *snap, int idx, size_t usource_rom_length )
{
  snap->usource_rom_length[idx] = usource_rom_length;
}

int
libspectrum_snap_disciple_active( libspectrum_snap *snap )
{
  return snap->disciple_active;
}

void
libspectrum_snap_set_disciple_active( libspectrum_snap *snap, int disciple_active )
{
  snap->disciple_active = disciple_active;
}

int
libspectrum_snap_disciple_paged( libspectrum_snap *snap )
{
  return snap->disciple_paged;
}

void
libspectrum_snap_set_disciple_paged( libspectrum_snap *snap, int disciple_paged )
{
  snap->disciple_paged = disciple_paged;
}

int
libspectrum_snap_disciple_inhibit_button( libspectrum_snap *snap )
{
  return snap->disciple_inhibit_button;
}

void
libspectrum_snap_set_disciple_inhibit_button( libspectrum_snap *snap, int disciple_inhibit_button )
{
  snap->disciple_inhibit_button = disciple_inhibit_button;
}

int
libspectrum_snap_disciple_drive_count( libspectrum_snap *snap )
{
  return snap->disciple_drive_count;
}

void
libspectrum_snap_set_disciple_drive_count( libspectrum_snap *snap, int disciple_drive_count )
{
  snap->disciple_drive_count = disciple_drive_count;
}

int
libspectrum_snap_disciple_custom_rom( libspectrum_snap *snap )
{
  return snap->disciple_custom_rom;
}

void
libspectrum_snap_set_disciple_custom_rom( libspectrum_snap *snap, int disciple_custom_rom )
{
  snap->disciple_custom_rom = disciple_custom_rom;
}

size_t
libspectrum_snap_disciple_rom_length( libspectrum_snap *snap, int idx )
{
  return snap->disciple_rom_length[idx];
}

void
libspectrum_snap_set_disciple_rom_length( libspectrum_snap *snap, int idx, size_t disciple_rom_length )
{
  snap->disciple_rom_length[idx] = disciple_rom_length;
}

int
libspectrum_snap_disciple_direction( libspectrum_snap *snap )
{
  return snap->disciple_direction;
}

void
libspectrum_snap_set_disciple_direction( libspectrum_snap *snap, int disciple_direction )
{
  snap->disciple_direction = disciple_direction;
}

libspectrum_byte
libspectrum_snap_disciple_control( libspectrum_snap *snap )
{
  return snap->disciple_control;
}

void
libspectrum_snap_set_disciple_control( libspectrum_snap *snap, libspectrum_byte disciple_control )
{
  snap->disciple_control = disciple_control;
}

libspectrum_byte
libspectrum_snap_disciple_track( libspectrum_snap *snap )
{
  return snap->disciple_track;
}

void
libspectrum_snap_set_disciple_track( libspectrum_snap *snap, libspectrum_byte disciple_track )
{
  snap->disciple_track = disciple_track;
}

libspectrum_byte
libspectrum_snap_disciple_sector( libspectrum_snap *snap )
{
  return snap->disciple_sector;
}

void
libspectrum_snap_set_disciple_sector( libspectrum_snap *snap, libspectrum_byte disciple_sector )
{
  snap->disciple_sector = disciple_sector;
}

libspectrum_byte
libspectrum_snap_disciple_data( libspectrum_snap *snap )
{
  return snap->disciple_data;
}

void
libspectrum_snap_set_disciple_data( libspectrum_snap *snap, libspectrum_byte disciple_data )
{
  snap->disciple_data = disciple_data;
}

libspectrum_byte
libspectrum_snap_disciple_status( libspectrum_snap *snap )
{
  return snap->disciple_status;
}

void
libspectrum_snap_set_disciple_status( libspectrum_snap *snap, libspectrum_byte disciple_status )
{
  snap->disciple_status = disciple_status;
}

libspectrum_byte*
libspectrum_snap_disciple_rom( libspectrum_snap *snap, int idx )
{
  return snap->disciple_rom[idx];
}

void
libspectrum_snap_set_disciple_rom( libspectrum_snap *snap, int idx, libspectrum_byte* disciple_rom )
{
  snap->disciple_rom[idx] = disciple_rom;
}

libspectrum_byte*
libspectrum_snap_disciple_ram( libspectrum_snap *snap, int idx )
{
  return snap->disciple_ram[idx];
}

void
libspectrum_snap_set_disciple_ram( libspectrum_snap *snap, int idx, libspectrum_byte* disciple_ram )
{
  snap->disciple_ram[idx] = disciple_ram;
}

int
libspectrum_snap_didaktik80_active( libspectrum_snap *snap )
{
  return snap->didaktik80_active;
}

void
libspectrum_snap_set_didaktik80_active( libspectrum_snap *snap, int didaktik80_active )
{
  snap->didaktik80_active = didaktik80_active;
}

int
libspectrum_snap_didaktik80_paged( libspectrum_snap *snap )
{
  return snap->didaktik80_paged;
}

void
libspectrum_snap_set_didaktik80_paged( libspectrum_snap *snap, int didaktik80_paged )
{
  snap->didaktik80_paged = didaktik80_paged;
}

int
libspectrum_snap_didaktik80_drive_count( libspectrum_snap *snap )
{
  return snap->didaktik80_drive_count;
}

void
libspectrum_snap_set_didaktik80_drive_count( libspectrum_snap *snap, int didaktik80_drive_count )
{
  snap->didaktik80_drive_count = didaktik80_drive_count;
}

int
libspectrum_snap_didaktik80_custom_rom( libspectrum_snap *snap )
{
  return snap->didaktik80_custom_rom;
}

void
libspectrum_snap_set_didaktik80_custom_rom( libspectrum_snap *snap, int didaktik80_custom_rom )
{
  snap->didaktik80_custom_rom = didaktik80_custom_rom;
}

size_t
libspectrum_snap_didaktik80_rom_length( libspectrum_snap *snap, int idx )
{
  return snap->didaktik80_rom_length[idx];
}

void
libspectrum_snap_set_didaktik80_rom_length( libspectrum_snap *snap, int idx, size_t didaktik80_rom_length )
{
  snap->didaktik80_rom_length[idx] = didaktik80_rom_length;
}

int
libspectrum_snap_didaktik80_direction( libspectrum_snap *snap )
{
  return snap->didaktik80_direction;
}

void
libspectrum_snap_set_didaktik80_direction( libspectrum_snap *snap, int didaktik80_direction )
{
  snap->didaktik80_direction = didaktik80_direction;
}

libspectrum_byte
libspectrum_snap_didaktik80_aux( libspectrum_snap *snap )
{
  return snap->didaktik80_aux;
}

void
libspectrum_snap_set_didaktik80_aux( libspectrum_snap *snap, libspectrum_byte didaktik80_aux )
{
  snap->didaktik80_aux = didaktik80_aux;
}

libspectrum_byte
libspectrum_snap_didaktik80_track( libspectrum_snap *snap )
{
  return snap->didaktik80_track;
}

void
libspectrum_snap_set_didaktik80_track( libspectrum_snap *snap, libspectrum_byte didaktik80_track )
{
  snap->didaktik80_track = didaktik80_track;
}

libspectrum_byte
libspectrum_snap_didaktik80_sector( libspectrum_snap *snap )
{
  return snap->didaktik80_sector;
}

void
libspectrum_snap_set_didaktik80_sector( libspectrum_snap *snap, libspectrum_byte didaktik80_sector )
{
  snap->didaktik80_sector = didaktik80_sector;
}

libspectrum_byte
libspectrum_snap_didaktik80_data( libspectrum_snap *snap )
{
  return snap->didaktik80_data;
}

void
libspectrum_snap_set_didaktik80_data( libspectrum_snap *snap, libspectrum_byte didaktik80_data )
{
  snap->didaktik80_data = didaktik80_data;
}

libspectrum_byte
libspectrum_snap_didaktik80_status( libspectrum_snap *snap )
{
  return snap->didaktik80_status;
}

void
libspectrum_snap_set_didaktik80_status( libspectrum_snap *snap, libspectrum_byte didaktik80_status )
{
  snap->didaktik80_status = didaktik80_status;
}

libspectrum_byte*
libspectrum_snap_didaktik80_rom( libspectrum_snap *snap, int idx )
{
  return snap->didaktik80_rom[idx];
}

void
libspectrum_snap_set_didaktik80_rom( libspectrum_snap *snap, int idx, libspectrum_byte* didaktik80_rom )
{
  snap->didaktik80_rom[idx] = didaktik80_rom;
}

libspectrum_byte*
libspectrum_snap_didaktik80_ram( libspectrum_snap *snap, int idx )
{
  return snap->didaktik80_ram[idx];
}

void
libspectrum_snap_set_didaktik80_ram( libspectrum_snap *snap, int idx, libspectrum_byte* didaktik80_ram )
{
  snap->didaktik80_ram[idx] = didaktik80_ram;
}

int
libspectrum_snap_covox_active( libspectrum_snap *snap )
{
  return snap->covox_active;
}

void
libspectrum_snap_set_covox_active( libspectrum_snap *snap, int covox_active )
{
  snap->covox_active = covox_active;
}

libspectrum_byte
libspectrum_snap_covox_dac( libspectrum_snap *snap )
{
  return snap->covox_dac;
}

void
libspectrum_snap_set_covox_dac( libspectrum_snap *snap, libspectrum_byte covox_dac )
{
  snap->covox_dac = covox_dac;
}

int
libspectrum_snap_multiface_active( libspectrum_snap *snap )
{
  return snap->multiface_active;
}

void
libspectrum_snap_set_multiface_active( libspectrum_snap *snap, int multiface_active )
{
  snap->multiface_active = multiface_active;
}

int
libspectrum_snap_multiface_paged( libspectrum_snap *snap )
{
  return snap->multiface_paged;
}

void
libspectrum_snap_set_multiface_paged( libspectrum_snap *snap, int multiface_paged )
{
  snap->multiface_paged = multiface_paged;
}

int
libspectrum_snap_multiface_model_one( libspectrum_snap *snap )
{
  return snap->multiface_model_one;
}

void
libspectrum_snap_set_multiface_model_one( libspectrum_snap *snap, int multiface_model_one )
{
  snap->multiface_model_one = multiface_model_one;
}

int
libspectrum_snap_multiface_model_128( libspectrum_snap *snap )
{
  return snap->multiface_model_128;
}

void
libspectrum_snap_set_multiface_model_128( libspectrum_snap *snap, int multiface_model_128 )
{
  snap->multiface_model_128 = multiface_model_128;
}

int
libspectrum_snap_multiface_model_3( libspectrum_snap *snap )
{
  return snap->multiface_model_3;
}

void
libspectrum_snap_set_multiface_model_3( libspectrum_snap *snap, int multiface_model_3 )
{
  snap->multiface_model_3 = multiface_model_3;
}

int
libspectrum_snap_multiface_disabled( libspectrum_snap *snap )
{
  return snap->multiface_disabled;
}

void
libspectrum_snap_set_multiface_disabled( libspectrum_snap *snap, int multiface_disabled )
{
  snap->multiface_disabled = multiface_disabled;
}

int
libspectrum_snap_multiface_software_lockout( libspectrum_snap *snap )
{
  return snap->multiface_software_lockout;
}

void
libspectrum_snap_set_multiface_software_lockout( libspectrum_snap *snap, int multiface_software_lockout )
{
  snap->multiface_software_lockout = multiface_software_lockout;
}

int
libspectrum_snap_multiface_red_button_disabled( libspectrum_snap *snap )
{
  return snap->multiface_red_button_disabled;
}

void
libspectrum_snap_set_multiface_red_button_disabled( libspectrum_snap *snap, int multiface_red_button_disabled )
{
  snap->multiface_red_button_disabled = multiface_red_button_disabled;
}

libspectrum_byte*
libspectrum_snap_multiface_ram( libspectrum_snap *snap, int idx )
{
  return snap->multiface_ram[idx];
}

void
libspectrum_snap_set_multiface_ram( libspectrum_snap *snap, int idx, libspectrum_byte* multiface_ram )
{
  snap->multiface_ram[idx] = multiface_ram;
}

size_t
libspectrum_snap_multiface_ram_length( libspectrum_snap *snap, int idx )
{
  return snap->multiface_ram_length[idx];
}

void
libspectrum_snap_set_multiface_ram_length( libspectrum_snap *snap, int idx, size_t multiface_ram_length )
{
  snap->multiface_ram_length[idx] = multiface_ram_length;
}
