/* RedoCommand.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

package be.ugent.caagt.swirl.undoredo;

import org.pietschy.command.CommandManager;

/**
 * Action command which reverts the last change which was undone by the corresponding
 * undo manager. The undo manager is assumed to be installed as an attribute to 
 * the command manager with key {@code UndoManager.class.getName()}<p>
 *
 * Whenever the state of the undo manager changes, caption and description of
 * the 'undoredo' face of the command are changed. Use face inheritance to
 * propagate either the caption or the description to the appropriate menu or toolbar
 * faces, as in the following example:
 * <pre>   
 *  &lt;command id="redo">
 *    &lt;class&gt;be.ugent.caagt.swirl.undoredo.RedoCommand&lt;/class&gt;
 *    &lt;face name="undoredo"&gt;
 *       &lt;text&gt;_Redo&lt;/text&gt;
 *       &lt;accelerator keyStroke="ctrl Y"/&gt;
 *       &lt;description&gt;Redo&lt;/description&gt;
 *    &lt;/face&gt;
 *    &lt;face name="menu" extends="[undoredo]"&gt;
 *       &lt;description/&gt;
 *    &lt;/face&gt;
 *    &lt;face name="toolbar" extends="[undoredo]"&gt;
 *       &lt;text/&gt;
 *       &lt;icon type="classpath"&gt;...&lt;/icon&gt;
 *    &lt;/face&gt;
 *  &lt;/command&gt;
 * </pre>
 *
 * The initial text and description of the 'undoredo' face
 * are used whenever the command is disabled.<p>
 *
 * <b>Important note:</b> work on this part of the Swirl library will be 
 * discontinued because unfortunately newer versions
 * of the <i>GUI commands</i> framework will no longer be available as <i>open source</i>.
 * In due course this class will become deprecated and will eventually be
 * removed from the library.
 */
public class RedoCommand extends UndoRedoCommand {

    /**
     * Construct an action command of this type.
     * @param commandManager Command manager, which must be of class {@link be.ugent.caagt.swirl.commands.AttributedCommandManager}
     */
    public RedoCommand (CommandManager commandManager, String id) {
        super (commandManager, id);
    }
    
    //
    protected String getCaption () {
	return undoManager.getRedoCaption();
    }

    
    // implements UndoListener
    public void undoStateChanged () {
        setEnabled (undoManager.canRedo ());
    }

    // implements Command
    protected void handleExecute() {
        undoManager.redoLast ();
    }
    

}
