/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; version 
 * 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#ifndef _SML_MANAGER_INTERNALS_H
#define _SML_MANAGER_INTERNALS_H

#include "sml_queue_internals.h"

struct SmlManager {
	SmlTransport *transport;
	
	GList *sessions;
	unsigned int lastSessionID;
	
	SmlManagerEventCb eventCallback;
	void *eventCallbackUserdata;
	
	SmlHeaderCb headerCallback;
	SmlStatusReplyCb headerStatusCallback;
	void *headerCallbackUserdata;
	
	GList *objects;

	GSourceFuncs *functions;
	SmlThread *thread;
	GMainContext *context;
	GSource *source;
	
	GCond *running;
	GMutex *running_mutex;
	
	SmlQueue *userEventQueue;
};

typedef struct SmlManagerEvent {
	SmlManagerEventType type;
	SmlSession *session;
	SmlCommand *command;
	SmlCommand *parent;
	SmlError *error;
} SmlManagerEvent;

struct SmlObject {
	SmlCommandType type;
	SmlLocation *location;
	SmlLocation *source;
	SmlCommandCb commandCallback;
	SmlCommandCb childCallback;
	void *commandCallbackUserdata;
	char *contentType;
};

#endif //_SML_MANAGER_INTERNALS_H
