/*
 * Parser for tag expressions
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#if __GNUC__ < 3
#define _GNU_SOURCE
#endif

#include "TagexprParser.h"
#include <stdio.h>

using namespace std;

TagexprParser* TagexprParser::_instance = 0;

TagexprParser* TagexprParser::instance() throw ()
{
	if (! _instance)
		_instance = new TagexprParser();
	return _instance;
}

extern FILE* yyin;
extern int yyparse();
extern int yydebug;

Tagexpr* TagexprParser::parse(const string& buf) throw ()
{
	FILE* in = fmemopen((void*)buf.data(), buf.size(), "r");
	yyin = in;

	errorMessage = string();

//	yydebug = 1;

	Tagexpr* res = 0;
	if (yyparse() == 0)
	{
		res = result;
		result = 0;
	}

	fclose(in);

	return res;
}

// vim:set ts=4 sw=4:
