/*
 * Remove unfaceted tags
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#pragma implementation

#include <tagcoll/UnfacetedRemover.h>

using namespace std;
using namespace Tagcoll;

template<class ITEM>
void UnfacetedRemover<ITEM>::consume(const ITEM& item) throw ()
{
	consumer->consume(item);
}

template<class ITEM>
void UnfacetedRemover<ITEM>::consume(const ITEM& item, const OpSet<string>& tags) throw ()
{
	OpSet<string> patched;
	for (OpSet<string>::const_iterator i = tags.begin();
			i != tags.end(); i++)
		if (i->find("::") != string::npos)
			patched += *i;

	if (patched.size())
		consumer->consume(item, patched);
	else
		consumer->consume(item);
}

// Process a set of items, all with no tags
template<class ITEM>
void UnfacetedRemover<ITEM>::consume(const OpSet<ITEM>& items) throw ()
{
	consumer->consume(items);
}

// Process a set of items identically tagged, with their tags
template<class ITEM>
void UnfacetedRemover<ITEM>::consume(const OpSet<ITEM>& items, const OpSet<string>& tags) throw ()
{
	OpSet<string> patched;
	for (OpSet<string>::const_iterator i = tags.begin();
			i != tags.end(); i++)
		if (i->find("::") != string::npos)
			patched += *i;

	if (patched.size())
		consumer->consume(items, patched);
	else
		consumer->consume(items);
}

// vim:set ts=4 sw=4:
