<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:param name="basename" select="'###'"/>
  <xsl:variable name="symbol" select="translate($basename, '-', '_')"/>

  <xsl:output method="xml" indent="yes" encoding="UTF-8"
    omit-xml-declaration="no"
    doctype-system="http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd"
    doctype-public="-//freedesktop//DTD D-BUS Object Introspection 1.0//EN" />

  <!-- Error if there's more than one interface -->
  <xsl:template match="/">
    <xsl:if test="interface[2]">
      <xsl:message terminate="yes">More than one interface in input file&#10;</xsl:message>
    </xsl:if>
    <xsl:if test="$basename = '###'">
      <xsl:message terminate="yes">The 'basename' parameter must be given&#10;</xsl:message>
    </xsl:if>
    <xsl:apply-templates />
  </xsl:template>

  <!-- Add the C symbol to all interfaces (there should only be one) -->
  <xsl:template match="interface">
    <xsl:copy>
      <xsl:apply-templates select="@*"/>
      <xsl:if test="annotation[name='org.freedesktop.DBus.GLib.ClientCSymbol']">
        <xsl:message terminate="yes">Interface already has ClientCSymbol&#10;</xsl:message>
      </xsl:if>
      <xsl:text>&#10;    </xsl:text>
      <annotation name="org.freedesktop.DBus.GLib.ClientCSymbol" value="{$symbol}"/>
      <xsl:apply-templates select="node()"/>
    </xsl:copy>
  </xsl:template>

  <!-- Identity transformation for all other nodes -->
  <xsl:template match="@*|node()">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>

<!-- vim:set sw=2 sts=2 et: -->
