#!/usr/bin/python

import sys
import xml.dom.minidom
from string import ascii_letters, digits


from libglibcodegen import Signature, type_to_gtype, cmp_by_name


NS_TP = "http://telepathy.freedesktop.org/wiki/DbusSpec#extensions-v0"

class Generator(object):

    def __init__(self, dom):
        self.dom = dom

    def do_signal(self, signal):
        marshaller_items = []
        gtypes = []

        for i in signal.getElementsByTagName('arg'):
            name = i.getAttribute('name')
            type = i.getAttribute('type')
            info = type_to_gtype(type)
            # type, GType, STRING, is a pointer
            gtypes.append(info[1])

        print ('dbus_g_proxy_add_signal (proxy, "%s",\\'
                % signal.getAttribute('name'))
        for gtype in gtypes:
            print '    %s,\\' % gtype
        print '    G_TYPE_INVALID);\\'

    def __call__(self):
        ifaces = self.dom.getElementsByTagName('node')
        ifaces.sort(cmp_by_name)

        for iface in ifaces:
            self.do_interface(iface)

    def do_interface(self, node):
        ifaces = node.getElementsByTagName('interface')
        assert len(ifaces) == 1
        iface = ifaces[0]
        name = node.getAttribute('name')
        print ('#define ADD_SIGNALS_FOR_%s(proxy) \\'
            % name.replace('/', '').upper())
        print 'G_STMT_START { \\'
        signals = iface.getElementsByTagName('signal')
        signals.sort(cmp_by_name)

        for signal in signals:
            self.do_signal(signal)

        print '} G_STMT_END'
        print

def types_to_gtypes(types):
    return [type_to_gtype(t)[1] for t in types]

if __name__ == '__main__':
    argv = sys.argv[1:]
    dom = xml.dom.minidom.parse(argv[0])

    Generator(dom)()
