/*
TerraLib - a library for developing GIS applications.
Copyright  2001, 2002, 2003 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular
purpose. The library provided hereunder is on an "as is" basis, and the
authors have no obligation to provide maintenance, support, updates,
enhancements, or modifications.
In no event shall INPE be held liable to any party
for direct, indirect, special, incidental, or consequential damages arising
out of the use of this library and its documentation.
*/

#ifndef TEPDINOBLENDSTRATEGY_HPP
  #define TEPDINOBLENDSTRATEGY_HPP

  #include <TeSharedPtr.h>
  #include "TePDIBlendingStrategy.hpp"
  #include "TePDIParameters.hpp"
  
  #include <string>

  /**
   * @brief This is the class for no blending strategy.
   * @author Emiliano F. Castejon <castejon@dpi.inpe.br>
   * @ingroup PDIBlendingStrategies
   *
   * @note The required parameters are:
   * @param input_raster1 ( TePDITypes::TePDIRasterPtrType ) - 
   *  Input raster 1.
   * @param input_raster2 ( TePDITypes::TePDIRasterPtrType ) - 
   *  Input raster 2.
   * @param output_raster ( TePDITypes::TePDIRasterPtrType ) - Output raster.
   * @param channels1 ( std::vector< int > ) - The channels to process from 
   * input_raster1.
   * @param channels2 ( std::vector< int > ) - The channels to process from 
   * input_raster2.
   * Raster 1 polygon pointer ( related to
   * input_raster1 world reference - Just 1 linear ring allowed ).
   * @param raster2_pol_ptr ( TePDITypes::TePDIPolygonPtrType ) - 
   * Raster 2 polygon pointer ( related to 
   * input_raster2 world reference - Just 1 linear ring allowed ).
   * @param raster2_pol_offset_x ( double ) - Raster 2 polygon box X offset 
   * related to raster1 polygon box in input_raster1 matricial reference
   * ( offset_x = pol2_x - pol1_x ).
   * @param raster2_pol_offset_y ( double ) - Raster 2 polygon box Y offset 
   * related to raster1 polygon box in input_raster1 matricial reference
   * ( offset_y = pol2_y - pol1_y ). 
   *
   * @note The optional parameters are:
   *
   * @param dummy_value (double) - A dummy pixel value for use 
   * in pixels where no data is available ( input pixels with
   * dummy values will be ignored ).  
   *
   * @note The output_raster parameters will take the input_raster1 as
   * reference.
   * @note All input rasters must have the same dimensions.
   *
   */
  class PDI_DLL TePDINoBlendStrategy : public TePDIBlendingStrategy
  {
    friend class TePDINoBlendSF;
  
    public :
      
      /**
       * @brief Default Destructor
       */
      ~TePDINoBlendStrategy();
      
      /**
       * @brief Checks if the supplied parameters fits the requirements of each
       * PDI strategy.
       *
       * @note Error log messages must be generated. No exceptions generated.
       *
       * @param parameters The parameters to be checked.
       * @return true if the parameters are OK. false if not.
       */
      bool CheckParameters( 
        const TePDIParameters& parameters ) const;       
      
    protected :
      
      /**
       * @brief Default constructor
       *
       * @param factoryName Factory name.
       */
      TePDINoBlendStrategy();
      
      /**
       * @brief Runs the algorithm implementation.
       *
       * @return true if OK. false on errors.
       */
      bool Implementation( const TePDIParameters& params );
     
  };
  
#endif



