#!/usr/bin/perl

# -----------------------------------------------------
# | Parser dla plikow zrodlowych C                    |
# |                                                   |
# | Wyciaga odpowiednie rzeczy z komentarzy i wypluwa |
# | w postaci pliku docbook'a                         |
# |                                                   |
# | Komentarze do skryptu:                            |
# |                                                   |
# |	na stdin wyrzucane sa dane docbook            |
# |	na stderr wyrzucane sa dane informacyjne      |
# |                                                   |
# | Wywolujemy ./cparser.pl plik1 plik2 ... plikN     |
# -----------------------------------------------------

print stderr "C parser | Odnalezione funkcje: \n";

# // docbook wstep
print stdout "<chapter>\n";
print stdout "<title>Dokumentacja funkcji biblioteki</title>\n";
print stdout "<para>\n";
print stdout "Opis wszystkich funkcji biblioteki wraz z ich parametrami i dodatkowymi komentarzami.\n";
print stdout "</para>\n";
# // docbook wstep

while (<>)
{
    $filename = $ARGV;
    $filename =~ s/\.\.\/\.\.\/lib\///;
    
    if ($. == 1)
    {
	# // docbook rozdzial
	print stdout "<sect1>\n";
	print stdout "<title>$filename</title>\n";
	print stdout "<para>Opis funkcji zawartych w pliku $filename</para>\n";
	# // docbook rozdzial
    }

    if (/\/\*/../\*\//) # jezeli jest w postaci /* */ to znaczy ze to komentarz
    {
	# a wiec wrzucamy go do @c
	push @c, $_;
    }	 
    else # to jednak nie komentarz
    {
	# po komentarzu lapiemy pierwsza linie z jakims tekstem
        if (/\w+/) 
        {
	    # pierwsza linia z jakims tekstem to deklaracja funkcji
	    $dekl = $_; 
	
	    # obcinamy poczatek i koniec, bo to start i koniec komentarza
    	    pop @c;
    	    shift @c;
        
	    # usuwamy gwiazdki i spacje z pocztkw linii
	    @c = map{s/^[ \t]*\*[ \t]*//;$_}@c;
    	    # laczymy liste @c spowrotem w jednosc do zmiennej $_
	    $_ = join'',@c; 
            
	    # wydobywamy z komentarza trzy sekcje oddzielone \n\n
	    if (/^(.*?)\n\n(.*?)\n\n(.*?)\n\n(.*?)\n/s)
    	    {
		# $1 nazwa, $2 opis, $3 parametry, $4 dodatki, $dekl deklaracja
		print stderr "C parser |	- $1\n";
		
		# // docbook jedna funkcja
		print stdout "<sect2>\n";
		print stdout "<title>$1</title>\n";
		print stdout "<para>\n";
		print stdout "$2\n";
		print stdout "</para>\n";
		print stdout "<para>\n";
		print stdout "<screen>\n";
		print stdout "$3\n";
		print stdout "</screen>\n";
		print stdout "</para>\n";
		print stdout "<para>\n";
		print stdout "$4\n";
		print stdout "</para>\n";
		print stdout "<para>\n";
		print stdout "Deklaracja: \n";
		print stdout "<emphasis>$dekl</emphasis>\n";
		print stdout "</para>\n";
		print stdout "</sect2>\n";
		# // docbook jedna funkcja
    	    }

	    # czyscimy liste
    	    @c=(); 
	}
    }
}
continue
{
    close ARGV if eof;
    # // docbook koniec rozdzialu
    print stdout "</sect1>\n" if eof;
    # // docbook koniec rozdzialu
}

# // docbook koniec 
print stdout "</chapter>\n\n";
# // docbook koniec
