/* 
-------------------------------------------------------------- 
Copyright 2007-2008 Max Cavallo ixamit@gmail.com - All Rights Reserved

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, Inc., 675 Mass Ave, Cambridge MA 02139,USA; either version 2 of the License, or (at your option) any later version; incorporated herein by reference.
-------------------------------------------------------------- 
*/

#include "finestre.h"
//#include "bitmaps/down.bmp"

int WX11_ComboBoxClose (ListCmdInfo *Combo)
{
    CmdInfo *ComboArea=Combo->CmdPar;

    if (!ComboArea)
    {
        printf ("Errore non trovato cmdareaitems in ComboBoxClose\n");
        exit (1);
    }
    if (ComboArea->Bordo)	ComboArea=ComboArea->Prev;

    XUnmapWindow(WX11_GetDisplay(), ComboArea->win);
    Combo->State=0;
	
    return (0);
}

int WX11_ComboBoxSelectedItem (CmdInfo *cmd,XEvent event)
{
    //
    // Funzione richiamata da eventi
    //
    CmdInfo * ComboArea=cmd;
    ListCmdInfo * ListCmd;
    ListCmdItemInfo * ListCmdItem;
    int retcode=0;

    while (ComboArea && ComboArea->Tipo!=AREA)
        ComboArea=CercaComando(ComboArea->parent);

    ListCmd=CercaListCmdInfo (ComboArea);
    if (!ListCmd)
    {
        printf ("error in ComboBoxSelectedItem\n");
        exit(1);
    }

    ListCmdItem=CercaListCmdItemInfo (ListCmd, cmd->win);
    if (!ListCmdItem)
    {
        printf ("error in ComboBoxSelectedItem\n");
        exit(1);
    }
    ListCmd->CorrenteItem=ListCmdItem;

    WX11_CmdLabelChange (ListCmd->CmdInput,cmd->Label);

    WX11_ComboBoxClose (ListCmd);

    return (retcode);
}

int WX11_ComboBoxOpen (ListCmdInfo * listcmdinfo)
{
    CmdInfo *input, *area, *areacombo, *item;
    int Bordo=2;
    int AltezzaComando=WX11_FontHeight()+4;
    int LarghezzaComando=0;
    int LarghezzaFinestra=0;
    int AltezzaFinestra=0;
    int giro;
    int TipoScroll=0;
    ListCmdItemInfo *listboxitem;
    unsigned int colorbg=WX11_ColorGet(LISTBOXBG);
    unsigned int colorfg=WX11_ColorGet(LISTBOXFG);

    if (!listcmdinfo)
    {
        printf ("error in ComboBoxOPen\n");
        exit(1);
    }
    //
    // 2008-08-31
    // if Opened Window
    //
    if (listcmdinfo->CmdPar && listcmdinfo->State == 0)
    {
        areacombo=listcmdinfo->CmdPar;
        if (areacombo->Bordo)
            areacombo=areacombo->Prev;

        XMapWindow(WX11_GetDisplay(), areacombo->win);
        listcmdinfo->State=1;
            return (0);
    }

    input=listcmdinfo->CmdInput;
    if (input->Bordo) 
        input=input->Prev;
    LarghezzaFinestra=input->Width+15;
    AltezzaFinestra=listcmdinfo->Height;
	
    LarghezzaComando=(listcmdinfo->MaxLenItem)*WX11_FontWidth ();
    if (LarghezzaComando<LarghezzaFinestra-15)
        LarghezzaComando=LarghezzaFinestra-15;

    area=CercaComando(input->parent);
    areacombo=ApreArea (area,
        input->x,input->y+input->Height+Bordo,LarghezzaFinestra , 
        AltezzaFinestra, colorbg,colorfg,Bordo);

    listcmdinfo->CmdPar=areacombo;
    listcmdinfo->State=1;

    listboxitem=listcmdinfo->PrimoItem;

    for (giro=0;listboxitem;giro++)
    {
        item=WX11_CmdOpen (listboxitem->Tipo,
            areacombo, 
            Bordo, 
            0+(AltezzaComando * giro),
            LarghezzaComando,
            AltezzaComando,
            colorbg, colorfg,
            0,
            listboxitem->Buff);
	
            if (listboxitem->Tipo!=LABEL)
                ListCmdMakeSignals (item, listcmdinfo->signal);

            listboxitem->Cmd=item;
            listboxitem=listboxitem->Next;
    }	
	
    if ((areacombo->scroll_max_y) > (areacombo->Height)+1)
        TipoScroll+=1;
    if ((areacombo->scroll_max_x) > (areacombo->Width)+1)
        TipoScroll+=2;

    if (TipoScroll)
        WX11_ScrollBar (areacombo,TipoScroll);

    return (0);
}

int WX11_ComboBoxOC ()
{
    CmdInfo * ultimocomandoselezionato=UltimoComandoSelezionato(0,NULL);
    ListCmdInfo * listcmdinfo;
    int retcode=0;

    listcmdinfo=CercaListCmdOpen(ultimocomandoselezionato);
    if (!listcmdinfo)
    {
        printf ("Error! listcmdinfo not found in ComboOc\n");
        exit (1);
    }

    if (listcmdinfo->State) 
        retcode=WX11_ComboBoxClose (listcmdinfo);
    else
        retcode=WX11_ComboBoxOpen (listcmdinfo);	

	return (retcode);
}



void WX11_ComboBox (CmdInfo *cmd, ListCmdInfo *ListCmd, int width, int height,  char *say, char *input, int SizeOfBuff)
{

    CmdInfo *inp,*dn;

    int (*Funz)();
    int Bordo=2;
    Pixmap bitmap_dn;

    if (!ListCmd)
        return;

    Funz=WX11_ComboBoxOC;

    // patch max
    if (ListCmd->PrimoItem)
    {
        strcpy (input,ListCmd->PrimoItem->Buff);
    }

    inp=WX11_Ask (cmd, say, input, SizeOfBuff, width);
    ListCmd->CmdInput=inp;

    if (inp->Bordo) inp=inp->Prev;

    dn=ApreBottone(cmd,
        (inp->x)+(inp->Width),(inp->y)+Bordo,
        15,(inp->Height)-(Bordo*2)," ");
    WX11_SetSignalCallBack (dn,Button1Release,Funz,NULL);

    ListCmd->CmdOpen=dn;

    ListCmd->Width=inp->Width;
    ListCmd->Height=height;
/*
    bitmap_dn=XCreatePixmapFromBitmapData(
        WX11_GetDisplay(), dn->win, 
        (char *) down_bits,
        (u_int) down_width, 
        (u_int) down_height, 1L,0L,1);

    dn->pixmap=bitmap_dn;
    dn->bitmap_width=13;
    dn->bitmap_height=13;
*/
//    WX11_DrawArrow (dn, 2);
}

