/* 
-------------------------------------------------------------- 
Copyright 2007-2008 Max Cavallo ixamit@gmail.com - All Rights Reserved

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, Inc., 675 Mass Ave, Cambridge MA 02139,USA; either version 2 of the License, or (at your option) any later version; incorporated herein by reference.
-------------------------------------------------------------- 
*/

#include "finestre.h"
#include <unistd.h>

void WX11_CursorInput (CmdInfo *cmd, int mode, int pos);

Timer *arrow_callback=NULL;
int HOLDING_DELAY=1000000;

void WX11_ResetIntervalCallBack()
{
    if (arrow_callback->INTERVAL > 50000)//100000)
        arrow_callback->INTERVAL=arrow_callback->INTERVAL/2;
}
int WX11_HoldingArrowLeft (CmdInfo *c)
{
    WX11_ScrollingArea (c,WX11_FontWidth(),0);
    WX11_ResetIntervalCallBack();
    return (0);
}
int WX11_HoldingArrowRight (CmdInfo *c)
{
    WX11_ScrollingArea (c,WX11_FontWidth()*(-1),0);
    WX11_ResetIntervalCallBack();
    return (0);
}
int WX11_HoldingArrowDown (CmdInfo *c)
{
    WX11_ScrollingArea (c,0,(WX11_FontHeight()+4)*(-1));
    WX11_ResetIntervalCallBack();
    return (0);
}
int WX11_HoldingArrowUp (CmdInfo *c)
{
    WX11_ScrollingArea (c,0,(WX11_FontHeight()+4)*(+1));
    WX11_ResetIntervalCallBack();
    return (0);
}

void WX11_SetClientMessage (CmdInfo *cmd,int (*CallBack)(),void *data)
{
    // Funzione richiamabile
    // in Chiusura finestra principale
    // 
    struct ExitInfo *tmp;

    tmp=ExitInfo_search4cmd (cmd);
    if (tmp)
    {
        tmp->CallBack=CallBack;
        tmp->data=data;
        return;
    }
    xphonya_new_exit (cmd,CallBack,data);
}

CmdInfo * UltimoComandoSelezionato (int Mode, CmdInfo *cmd)
{
    static CmdInfo *UltimoComandoSelezionato=NULL;

    if (Mode) UltimoComandoSelezionato=cmd;
    return (UltimoComandoSelezionato);
}


int WX11_EnterLeaveNotify (int Mode,CmdInfo **ppcmd, XEvent event)
{
    //
    // Notifica Ingresso e Uscita (EnterNotify && LeaveNotify)
    // Mode 1 == Ingresso 
    //      2 == Uscita
    Window window=(event.xcrossing.subwindow) ? event.xcrossing.subwindow : event.xcrossing.window;
    CmdInfo * cmd=CercaComando(window);	

    int retcode=0;

	
    *ppcmd=cmd;

    if (!cmd)
        return (0); // Troppo veloce ? ... riprova

    //if (cmd->Lock)
    //    return (0); // Locked ?

    //printf ("Mode=%d cmd=%p tipo=%d\n",Mode,cmd,cmd->Tipo);

    if (Mode==1)
    {
        cmd->MouseOver=1;
	if (cmd->Tipo==BUTTON || cmd->IsButton || cmd->Tipo==MENU_ITEM || cmd->Tipo==LIST_BOX || cmd->Tipo==COMBO_BOX)
	{
		WX11_ComandoFocus (cmd, 1);
		WX11_PrintFlush(cmd); 
	}
    }
    else if (Mode==2)
    {
        cmd->MouseOver=0;
        // Spegne il Bottone se esce 
        if (cmd->Tipo==BUTTON || cmd->IsButton || cmd->Tipo==MENU_ITEM || cmd->Tipo==LIST_BOX || cmd->Tipo==COMBO_BOX)
	{
		cmd->Focus=0;
		WX11_ComandoFocus (cmd, 0);
		WX11_PrintFlush(cmd); 
	}
    }	
    else
        WX11_FatalError ("Error: WX11_EnterLeaveNotify. Mode==%d",Mode);
		

    return (retcode);
}

int WX11_ButtonPress (CmdInfo **ppcmd,XEvent event)
{
    Window window=(event.xbutton.subwindow) ? event.xbutton.subwindow : event.xbutton.window;
    unsigned int button=event.xbutton.button;
    CmdInfo * cmd=CercaComando(window);
    CmdInfo * UltimoCmdSel=UltimoComandoSelezionato(0,NULL);
    int retcode=0;
    //
    //
    *ppcmd=cmd;
    //printf ("Pressione bottone %p %lx %lx %lx\n",cmd,event.xbutton.subwindow,event.xbutton.window,event.xbutton.root);
    //
    //  If click with opened menu ... close menu
    ListCmdInfo *menu=WX11_MenuCurrent (0,NULL);
    //printf ("menu=%p\n",menu);
    if (menu && cmd->Tipo!=MENU && cmd->Tipo!=MENU_ITEM)
    {
	WX11_MenuOpen (menu->CmdOpen,Button1Press,menu);
	UltimoComandoSelezionato(1,NULL);
	return (0);
    }
	
    // Non accetta se comando disattivo
    if (!cmd->Attivo || cmd->Lock) return (0);

    // Salva il Comando Corrente
    if (button==1 || button==3 || button==4 || button==5)
        UltimoComandoSelezionato(1,cmd);

    // Inizializza posizione iniziale
    // se premuto il cursore di scroll
    if ((cmd->Tipo==SCROLL_VCUR || cmd->Tipo==SCROLL_HCUR) && button==1)
        WX11_HandleScroll (1,event);

    //////////////////////////////////////
    // Accende il Bottone
    if (button==1)
    {
        if (cmd->Tipo==BUTTON || cmd->IsButton)
            ComandoAccesoSpento (1,window);
    }

    ///////////////////////////////
    // Chiude ultimo ultimocomando 
    // eventualmente aperto se la zona non corrisponde 	
    if (UltimoCmdSel && (cmd != UltimoCmdSel)) 
    {
        //printf ("Zona diversa\n");
        UltimoCmdSel->MouseOver=0;
        UltimoCmdSel->Focus=0;
/*
        if (UltimoCmdSel->Tipo==MENU)
        {
            ChiudeMenu(UltimoCmdSel->win);
        }
*/
        if (UltimoCmdSel->Tipo==INPUT)
        {
            // TODO 
        }
    }

    ///////////////////////////////
    // Seleziona Input
    if (button==1)
    {
        if (cmd->Tipo==INPUT)
        {
            cmd->Focus=1;

            WX11_CursorInput (cmd, 1, 0);

            // TODO
            // Spostare il cursore
            // se oltre la fine
            //if (strlen(RTrim(cmd->Label))*WX11_FontWidth() < 	event.xbutton.x)
            //	WX11_InputKey (0, TASTO_END, 0); 
        }
    }

    //////////////////////////////////////
    // ListBox
    if (cmd->Tipo==LIST_BOX && button==1)
    {
        WX11_ListBoxSelectedItem (cmd);
        return (retcode);
    }

    //////////////////////////////////////
    // Scroll Up
    if (cmd->Tipo==SCROLL_UP && button==1)
    {
        WX11_ScrollingArea (cmd,0,(WX11_FontHeight()+4)*(+1));
        if (!arrow_callback)
        {
            arrow_callback=SetTimerCallBack (WX11_HoldingArrowUp,cmd,HOLDING_DELAY);
            TimerStart (arrow_callback);
        }
    }

    //////////////////////////////////////
    // Scroll Down
    if (cmd->Tipo==SCROLL_DN && button==1)
    {
        WX11_ScrollingArea (cmd,0,(WX11_FontHeight()+4)*(-1));
        if (!arrow_callback)
        {
            arrow_callback=SetTimerCallBack (WX11_HoldingArrowDown,cmd,HOLDING_DELAY);
            TimerStart (arrow_callback);
        }
    }

    //////////////////////////////////////
    // Scroll Page Up
    if (cmd->Tipo==SCROLL_PGUP && button==1)
    {
        WX11_ScrollingPage(cmd);
    }

    //////////////////////////////////////
    // Scroll Page Down
    if (cmd->Tipo==SCROLL_PGDN && button==1)
    {
        WX11_ScrollingPage(cmd);
    }

    //////////////////////////////////////
    // Scroll Left
    if (cmd->Tipo==SCROLL_SX && button==1)
    {
        WX11_ScrollingArea (cmd,WX11_FontWidth(),0);
        if (!arrow_callback)
        {
            arrow_callback=SetTimerCallBack (WX11_HoldingArrowLeft,cmd,HOLDING_DELAY);
            TimerStart (arrow_callback);
        }
    }

    //////////////////////////////////////
    // Scroll Right
    if (cmd->Tipo==SCROLL_DX && button==1)
    {
        WX11_ScrollingArea (cmd,WX11_FontWidth()*(-1),0);
        if (!arrow_callback)
        {
            arrow_callback=SetTimerCallBack (WX11_HoldingArrowRight,cmd,HOLDING_DELAY);
            TimerStart (arrow_callback);
        }
    }

    //////////////////////////////////////
    // Scroll Page Left
    if (cmd->Tipo==SCROLL_PGSX && button==1)
    {
        WX11_ScrollingPage(cmd);
    }

    //////////////////////////////////////
    // Scroll Page Right
    if (cmd->Tipo==SCROLL_PGDX && button==1)
    {
        WX11_ScrollingPage(cmd);
    }

    //////////////////////////////////////
    // Middle Button
    if (button==2)
    {
        return (retcode);
    }

    //////////////////////////////////////
    // Right Button
    if (button==3)
    {
        return (retcode);
    }

    //////////////////////////////////////
    // Wheel Scroll
    if (button==4 || button==5)
    {
        WX11_WheelScroll (cmd,button);
        return (retcode);
    }

    return (retcode);
}


int WX11_ButtonRelease (CmdInfo **ppcmd,XEvent event)
{
    Window window=(event.xbutton.subwindow) ? event.xbutton.subwindow : event.xbutton.window;
    unsigned int button=event.xbutton.button;
    CmdInfo * cmd=CercaComando(window);
    int retcode=0;
    //
    *ppcmd=cmd;
    //printf ("Rilascio bottone %p %lx %lx %lx\n",cmd,event.xbutton.subwindow,event.xbutton.window,event.xbutton.root);
    //
    if (arrow_callback)
    {
        TimerStop (arrow_callback);
        FreeTimer (arrow_callback);
        arrow_callback=NULL;
    }

    if (!cmd) return (0);

    // Reset posizione iniziale
    // per  il cursore di scroll
    // e scrolling
    if ((cmd->Tipo==SCROLL_VCUR || cmd->Tipo==SCROLL_HCUR) && button==1)
        WX11_HandleScroll (0,event);
	
    ///////////////////////////////
    //
    if ((cmd->Tipo==BUTTON || cmd->IsButton) && cmd->Focus==1)
    {
        ComandoAccesoSpento (0,window);
    }

    //////////////////////////////////////
    // ComboBox
    if (cmd->Tipo==COMBO_BOX && button==1)
    {
        WX11_ComboBoxSelectedItem (cmd,event);
        //
        UltimoComandoSelezionato(1,NULL);
        return (retcode);
    }

		
    return (retcode);	
}

int WX11_MotionNotify (XEvent event)
{
    int retcode=0;

    WX11_HandleScroll (2,event);

    return (retcode);
}

int WX11_KeyPress (XEvent event)
{
    Window window=(event.xkey.subwindow) ? event.xkey.subwindow : event.xkey.window;
    char keycode=event.xkey.keycode;
    int state=event.xkey.state;
    int upperstate=ShiftMask | LockMask;
    CmdInfo * comando; 
    CmdInfo * UltimoCmdSel=UltimoComandoSelezionato(0,NULL);
    ListCmdInfo *ListCmd;
    ListCmdItemInfo *ListCmdItem;
	
    KeySym xsym;
    char tasto[1];

    Window focusWin;
    int reverToReturn;
    int retcode=0;
	
    XGetInputFocus(WX11_GetDisplay(), &focusWin, &reverToReturn); // $$max

    xsym=XKeycodeToKeysym(WX11_GetDisplay(), (unsigned int) keycode, 0);
    //printf ("%d %d (0x%x) %s\n",keycode,xsym,xsym,XKeysymToString(xsym));
    //printf ("state=%d\n",state);

    tasto[0]=(char) 0;
    if (xsym >> 8 == 0xFF)
    {
	switch (xsym)
	{
	    case XK_KP_Home:
		xsym=WX11_IsNumLock(state) ? 0x37 : XK_Home;
		break;
	    case XK_KP_Up:
		xsym=WX11_IsNumLock(state) ? 0x38 : XK_Up;
		break;
	    case XK_KP_Page_Up:
		xsym=WX11_IsNumLock(state) ? 0x39 : XK_Page_Up;
		break;
	    case XK_KP_Left:
		xsym=WX11_IsNumLock(state) ? 0x34 : XK_Left;
		break;
	    case XK_KP_Begin:
		xsym=WX11_IsNumLock(state) ? 0x35 : XK_Begin;
		break;
	    case XK_KP_Right:
		xsym=WX11_IsNumLock(state) ? 0x36 : XK_Right;
		break;
	    case XK_KP_End:
		xsym=WX11_IsNumLock(state) ? 0x31 : XK_End;
		break;
	    case XK_KP_Down:
		xsym=WX11_IsNumLock(state) ? 0x32 : XK_Down;
		break;
	    case XK_KP_Page_Down:
		xsym=WX11_IsNumLock(state) ? 0x33 : XK_Page_Down;
		break;
	    case XK_KP_Insert:
		xsym=WX11_IsNumLock(state) ? 0x30 : XK_Insert;
		break;
	    case XK_KP_Delete:
		break;
	}
    }
    if (xsym < 0xff)
    {
	tasto[0]=(char) xsym;
	if (strchr("abcdefghijklmnopqrstuvwxyz", tasto[0]))
	{
		// 
		if ((state & upperstate) && ((state & upperstate) != upperstate))
			tasto[0]=(char) xsym-32;
	}
    }


    //////////////////////////////////////
    // Ctrl D x Debug dettaglio
    if (WX11_IsCtrl(state) && keycode==40)
    {
        WX11_debug_cmd(event.xkey.window);
    }

    //////////////////////////////////////
    // Ctrl E x Debug
    if (WX11_IsCtrl(state) && keycode==26)
    {
        WX11_debug_all_cmd();
    }

    //////////////////////////////////////
    // Ctrl F x Debug
    if (WX11_IsCtrl(state) && keycode==41)
    {
        debug_listcmd();
    }


    //XGrabKeyboard(display, main_window, True,GrabModeAsync, GrabModeAsync, CurrentTime);
	
	
    //XLookupString((XKeyEvent *)&event,&tasto[0],sizeof(tasto),NULL,NULL); //0
	

	

//XLookupString((XEvent *)&event, NULL, 0, &xsym, NULL);

	//printf ("%s\n",XKeysymToString(xsym));
	//XLookupString((XKeyEvent *)&event,&tasto[0],sizeof(tasto),xsym,NULL); //0

	//tasto[0]=' ';
	//printf ("keycode=%d tasto[0]=%d tasto[1]=%d\n",keycode,tasto[0],tasto[1]);

	SignalHeaderInfo *Head=PrimoComando(0,NULL)->signal;
	SignalInfo *signal=WX11_SignalSearch (Head,KeyPress);
	if (signal && signal->CallBack)
	{
		
		retcode=(signal->CallBack) (CercaComando(window),(unsigned int)xsym,&tasto[0],state);
		//return (retcode);
		
	}


    //////////////////////////////////////
    // keycode-Input
    if (UltimoCmdSel && UltimoCmdSel->Tipo==INPUT)
    {
        WX11_InputKey (UltimoCmdSel,state,(unsigned int) xsym,(char) tasto[0]);
    }

    //////////////////////////////////////
    // keycode-Menu
    if (UltimoCmdSel && UltimoCmdSel->Tipo==MENU)
    {
	ListCmdInfo *menu=WX11_MenuCurrent (0,NULL);
	
        if (xsym==XK_Escape)
        {
	    WX11_MenuOpen (menu->CmdOpen,Button1Press,menu);
        }
	if ((xsym==XK_Left || xsym==XK_Right) && menu)
	{
	    menu->CmdOpen->MouseOver=0;
	   if (xsym==XK_Left)
	   {
		if (menu==WX11_MenuFirst(0,NULL))
			menu=WX11_MenuLast(0,NULL);
		else
			menu=menu->Prev;
	   }
	   if (xsym==XK_Right)
	   {
		if (menu==WX11_MenuLast(0,NULL))
			menu=WX11_MenuFirst(0,NULL);
		else
			menu=menu->Next;
	   }
	   WX11_MenuOpen (menu->CmdOpen,EnterNotify,menu);
	}
	if ((xsym==XK_Up || xsym==XK_Down) && menu)
	{
		if (menu->CorrenteItem)
		{
			menu->CorrenteItem->Cmd->MouseOver=0;
			WX11_PrintFlush (menu->CorrenteItem->Cmd);
		}
		if (xsym==XK_Up)
		{
			if (menu->CorrenteItem) menu->CorrenteItem=menu->CorrenteItem->Prev;
			if (menu->CorrenteItem==NULL) menu->CorrenteItem=menu->UltimoItem;
		}
		if (xsym==XK_Down)
		{
			if (menu->CorrenteItem) menu->CorrenteItem=menu->CorrenteItem->Next;
			if (menu->CorrenteItem==NULL) menu->CorrenteItem=menu->PrimoItem;
		}
		if (menu->CorrenteItem)
		{
			menu->CorrenteItem->Cmd->MouseOver=1;
			WX11_PrintFlush (menu->CorrenteItem->Cmd);
		}
	}
	if ((xsym==XK_Return || xsym==XK_KP_Enter) && menu)
	{
		if (menu->CorrenteItem)
			WX11_MenuExec (menu->CorrenteItem->Cmd,Button1Release,menu);
	}

    }

    //////////////////////////////////////
    // keycode-ListBox
    if (UltimoCmdSel && UltimoCmdSel->Tipo==LIST_BOX)
    {
	//FIXME
        if (xsym==XK_Up || xsym==XK_Down)
        {
	    comando=UltimoCmdSel;
	    while (comando && comando->Tipo!=AREA) comando=comando->Prev;
	    ListCmd=CercaListCmdInfo(comando);

	    if (ListCmd)
	    {
            	ListCmdItem=ListCmd->CorrenteItem;
		
		if (ListCmdItem)
		{
		
		    ListCmdItem->Cmd->Focus=0;
            	    ListCmdItem->Cmd->MouseOver=0;
		    ListCmdItem->Cmd->Stato=0;
		    WX11_PrintFlush(ListCmdItem->Cmd);
			
            	    ListCmdItem=(xsym==XK_Up) ? ListCmdItem->Prev : ListCmdItem->Next ;
		}

            	// Primo/Ultimo Bound
            	if (!ListCmdItem)   return (1);

            	//comando->Focus=0;
            	ListCmd->CorrenteItem=ListCmdItem;
				
            	(ListCmdItem->Cmd)->Focus=1;
		ListCmdItem->Cmd->Stato=1;
            	WX11_PrintFlush(ListCmdItem->Cmd);
	    }
			
        }
    }

    //////////////////////////////////////
    // keycode-CallBack
    retcode=WX11_SignalExecCallBack(UltimoCmdSel,KeyPress);

    return (retcode);
}

int WX11_ConfigureNotify (XEvent event)
{
    int x=event.xconfigure.x;
    int y=event.xconfigure.y;
    int width=event.xconfigure.width;
    int height=event.xconfigure.height;

    CmdInfo *cmd=CercaComando(event.xconfigure.window);

    //
    // Questa abilitazione e' solo 
    // per le window principali
    // ... ma non si sa mai..
    if (cmd && cmd->Tipo!=MAIN) 
        return (0);

    cmd->x=x;		cmd->y=y;
    cmd->Width=width;	cmd->Height=height;

    return (0);
}

int WX11_Expose (CmdInfo **ppcmd,XEvent event)
{
    Window window=event.xexpose.window;
    CmdInfo *cmd=CercaComando(window);
    //
    *ppcmd=cmd;
	
    WX11_PrintFlush (cmd);

	return (0);
}

int WX11_GetEvent (Display *display, int *exiting)
{
    XEvent event;
    int type;
    CmdInfo *cmd=NULL;//PrimoComando(0,NULL);
    struct ExitInfo *CM;

    XNextEvent(display, &event);

    switch (event.type)
    {
        case EnterNotify:
            *exiting=WX11_EnterLeaveNotify (1,&cmd,event);
            break;
        case LeaveNotify:
            *exiting=WX11_EnterLeaveNotify (2,&cmd,event);
            break;
        case ButtonPress:
            *exiting=WX11_ButtonPress (&cmd,event);
            break;
        case ButtonRelease:
            *exiting=WX11_ButtonRelease(&cmd,event);
            break;
        case MotionNotify:
            *exiting=WX11_MotionNotify(event);
            break;
        case KeyPress:
            WX11_KeyPress(event);
            break;
        case FocusIn:
            break;
        case FocusOut:
            break;
        case ConfigureNotify:
            WX11_ConfigureNotify(event);
            break;
        case Expose:
            WX11_Expose (&cmd,event);
            break;
        case ClientMessage:
            // Chiusura
            if (CercaComando(event.xclient.window)->Lock==0)
            {
		ListCmdInfo *menu=WX11_MenuCurrent (0,NULL);
	       	if (menu)
        	{
	    	    WX11_MenuOpen (menu->CmdOpen,Button1Press,menu);
        	}

                *exiting=-1; 
                CM=ExitInfo_search4win (event.xclient.window);
                if (CM)
                {
                    *exiting=(CM->CallBack)(CM->data);
                    if (!*exiting) break;
                    xphonya_free_exit (CM);
                }
                ChiudeFinestra (event.xclient.window);
            }
            break;
    } // switch

    //////////////////////////////////////
    // Exec CallBack
    if (!*exiting && event.type!=KeyPress)
    {	
        type=event.type;
        //cmd=CercaComando(event.xany.window);
	

        if (cmd && (cmd->Attivo && !cmd->Lock))
        {
            // FIXME MouseOver is checked by released on same cmd
            if (type==ButtonPress && cmd->MouseOver)
                type |= (1 << (7+event.xbutton.button));
            if (type==ButtonRelease && cmd->MouseOver) 
                type |= (1 << (7+event.xbutton.button));

            *exiting=WX11_SignalExecCallBack(cmd,type);
        }
    }

    return (*exiting);
}

void  WX11_Waiting(len)
     unsigned long len;
{
  struct timeval t;
  t.tv_usec = len % 1000000;
  t.tv_sec  = len / 1000000;
  (void) select(0, NULL, NULL, NULL, &t);
}

int WX11_Events (CmdInfo * cmd)
{
    Display *dpy=WX11_GetDisplay();	
    int exiting=0;
	
    WX11_MapFlush (cmd);

    while(exiting == 0)
    {
        while (!exiting && XPending(dpy)) 
            exiting=WX11_GetEvent (dpy,&exiting);

        if (!exiting)
        {
            if (TimerLook (&exiting)==0)
            {
		WX11_Waiting(1000);
                //usleep(10000);  // prevent OverLoad Cpu
            }
        }
    }
    return (exiting);	
}
