/* 
-------------------------------------------------------------- 
Copyright 2007-2008 Max Cavallo ixamit@gmail.com - All Rights Reserved

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, Inc., 675 Mass Ave, Cambridge MA 02139,USA; either version 2 of the License, or (at your option) any later version; incorporated herein by reference.
-------------------------------------------------------------- 
*/

#include "finestre.h"
#include <stdarg.h>
///////////////////////////////////////
// Finestre
int WX11_INTERLINE_SPACE=6;
int WX11_SPACE_BETWEEN_BORDERS=3;


CmdInfo * ApreFinestra (char *Titolo,int x, int y, int larghezza, int altezza)
{
	//
	// Apre La Finestra
	// 
	CmdInfo *mio;
	int Bordo=0;
	
	mio=WX11_CmdOpen (MAIN,NULL,x,y,larghezza,altezza,WX11_ColorGet(WINBG), WX11_ColorGet(WINFG),Bordo,"");
	XStoreName(WX11_GetDisplay(), mio->win, Titolo);

	return (mio);
}
CmdInfo * ApreFinestraCentrale (char *Titolo, int larghezza, int altezza)
{
	//
	// Apre La Finestra centrale
	//
	Display *display=WX11_GetDisplay();
	int num_screen = DefaultScreen(display);
	unsigned int  display_width  = DisplayWidth(display, num_screen);
	unsigned int  display_height = DisplayHeight(display, num_screen);
	int x,y;

	x=(display_width/2)-(larghezza/2);
	y=(display_height/2)-(altezza/2);

	return (ApreFinestra (Titolo,x,y,larghezza,altezza));	
}
CmdInfo * ApreFinestraFullScreen (char *Titolo)
{
	//
	// Apre La Finestra a pieno schermo
	// 
	Display *display=WX11_GetDisplay();
	int num_screen = DefaultScreen(display);
	unsigned int  display_width  = DisplayWidth(display, num_screen);
	unsigned int  display_height = DisplayHeight(display, num_screen);
	int x,y;

	x=0;
	y=0;

	return (ApreFinestra (Titolo,x,y,display_width,display_height));
}

int ChiudeFinestra (Window win)
{
	CmdInfo *cmd;

	cmd=CercaComando(win);
	if (!cmd)
	{
		printf ("errore in ChiudeFinestra\n");
		exit(1);
	}

	xFreeCmd (cmd);

	//
	UltimoComandoSelezionato(1,NULL);
        WX11_ListCmdFreeUnused ();

	return (0);

}

///////////////////////////////////////
// Area
CmdInfo *ApreArea (CmdInfo *comando,int x,int y, int larghezza, int altezza, int colorbg, int colorfg, int Bordo)
{
	//
	// Apre un Area.
	// L'area viene di solito usata per 
	// raggruppare piu comandi o 
	// solo per disegnare un rilievo. 
	// 
	CmdInfo *mio;
	mio=WX11_CmdOpen (AREA,comando,x,y,larghezza,altezza,colorbg, colorfg,Bordo," ");
	mio->BUpDn=1;
	return (mio);
}

int WX11_PrintDimensions (char *Buff,int *width, int *height)
{
    //
    // Used by Print to resolve Label Buff
    // return nrows
    //
    char *pi,*pe;
    int nrows=1;
    int MaxTextWidth=0,TextWidth;

    pi=pe=Buff;

    while (pe[0]) 
    {
        if (pe[0]=='\n' && pe[1])
        {
            TextWidth=XTextWidth(WX11_FontCurrent(), pi, pe-pi);
            if (MaxTextWidth < TextWidth)
                MaxTextWidth=TextWidth;
            pi=pe+1;
            nrows++;
        }
        pe++;
    }
    TextWidth=XTextWidth(WX11_FontCurrent(), pi, pe-pi);
    if (MaxTextWidth < TextWidth)
        MaxTextWidth=TextWidth;

    *width=MaxTextWidth+WX11_SPACE_BETWEEN_BORDERS;
    *height=nrows*(WX11_FontHeight()+WX11_INTERLINE_SPACE);

    return (nrows);
}

///////////////////////////////////////
// Print 
CmdInfo *WX11_Print (CmdInfo *comando,int x,int y,char *Buff)
{
	//
	// Apre una Label. 
	//
	int Bordo=0;//2;//2; // ex0
        int width;
	int height=1;
	unsigned int colorbg=WX11_ColorGet(WINBG);
	unsigned int colorfg=WX11_ColorGet(WINFG);

        if (Buff==NULL) return (NULL);

        WX11_PrintDimensions (Buff,&width,&height);

	return (WX11_CmdOpen (LABEL,comando,x,y,width,height,colorbg,colorfg,Bordo,Buff));

}
CmdInfo *WX11_PrintCenter (CmdInfo *comando, int y, char *Buff)
{
	//
	// Apre una Label Centrata sulla finestra. 
	//
        int lw=(comando->Width);
        int ls=0;
	int x=0;
        //
        if (Buff==NULL) return (NULL);

        ls=XTextWidth(WX11_FontCurrent(), Buff, strlen(Buff));
        if (lw && ls) 
            x=(lw/2)-(ls/2);
        //
        return(WX11_Print (comando,x,y,Buff));
}

void WX11_Locate (CmdInfo *comando, int Mode, int *x,int *y)
{
        //
        // Usata per posizionamento
        // label
        // if mode==0 Get last x&y position
        // if mode==1 Set position to last x&y
        //
        //static int last_x, last_y;
        if (!Mode)
        {
            // pop
            *x=comando->say_x;
            *y=comando->say_y;

            if (!*x) *x=WX11_SPACE_BETWEEN_BORDERS;
            if (!*y) *y=WX11_SPACE_BETWEEN_BORDERS;

        }
        else
        {
            // push
            comando->say_x=*x;
            comando->say_y=*y;
        }
}


CmdInfo *WX11_Say (CmdInfo *cmd, const char *fmt, ...)
{
    //
    // Apre una label senza coordinate di 
    // riferimento
    //
    va_list args;
    char Buff[256];

    CmdInfo *new;
    int x,y,i;

    if (fmt==NULL) return (NULL);

    va_start(args, fmt);
    i=vsprintf(Buff,fmt,args);
    va_end(args);

    WX11_Locate (cmd,0,&x,&y);

    new=WX11_Print (cmd,x,y,Buff);
    if (new==NULL) 
        return (new);

    //
    // To be or not to be...
    y+=new->Height;
    if (Buff[strlen(Buff)-1]=='\n')
    {
        x=0;
    }
    else
    {
        x+=new->Width;
        y-=(WX11_FontHeight()+WX11_INTERLINE_SPACE);
    }

    WX11_Locate (cmd,1,&x,&y);

    return (new);
}

///////////////////////////////////////
// Button
CmdInfo * ApreBottone (CmdInfo *parent,int x, int y, int larghezza, int altezza, char *Buff)
{
	//
	// Apre un Button
	// 
        Display *dpy=WX11_GetDisplay();
	CmdInfo *my;
        Pixmap pixmap;
        unsigned int gradient_from= WX11_ColorLightSmall(WX11_ColorGet(BUTTONBG));
        unsigned int gradient_to  =WX11_ColorDarkSmall(WX11_ColorGet(BUTTONBG));
	int Bord=2;

	my=WX11_CmdOpen(BUTTON,parent,
            x,y,larghezza,altezza,
            WX11_ColorGet(BUTTONBG), WX11_ColorGet(BUTTONFG),
            Bord,Buff);
	my->BUpDn=1;

        pixmap=XCreatePixmap(dpy, my->win, 
            my->Width, my->Height, WX11_GetDepth ());

        WX11_ColorGradiant (pixmap, my->Width, my->Height, 
            gradient_from,gradient_to);
	my->Gradiant=1;
        XSetWindowBackgroundPixmap (dpy,my->win,pixmap);

        XFreePixmap(dpy, pixmap);

	return (my);
}

///////////////////////////////////////
// Input
CmdInfo * ApreInput (CmdInfo *parent, int x, int y, char *Buff, int Len,int Size)
{
	//
	//Apre un Input
	//
        //int posx=WX11_FontWidth() * x;
        //int posy=(WX11_FontHeight()+WX11_INTERLINE_SPACE) * y;
	//int larghezza=(Len+1) * WX11_FontWidth();
	//int larghezza=(Size+1) * WX11_FontWidth();
	int altezza=WX11_FontHeight()+2; //4
 
	CmdInfo *mio;
	int Bordo=2;

	if (strlen(Buff)<Size)
	{	//$$ patch $$max 8 Giungo 2007
		memset(Buff+strlen(Buff),' ', Size-strlen(Buff)-1);
		Buff[Size-1]='\0';
	}
	
	mio=WX11_CmdOpen (INPUT,parent,x,y,Len,altezza, WX11_ColorGet(INPUTBG), WX11_ColorGet(INPUTFG), Bordo, Buff);

	mio->Width=(Size+1) * WX11_FontWidth();
	XMoveResizeWindow(WX11_GetDisplay(), mio->win,
			mio->x, mio->y, mio->Width, mio->Height);

       return (mio);	
}

CmdInfo * WX11_Ask (CmdInfo *cmd, char *say, char *Buff, int SizeOfBuff, int width)
{
    CmdInfo *input;
    int Bordo=2;
    int x,y;
    int height=WX11_FontHeight()+WX11_INTERLINE_SPACE;

    WX11_Say (cmd,say);
    WX11_Locate (cmd,0,&x,&y);

    if (strlen(Buff) < SizeOfBuff)
    {	//
        memset(Buff+strlen(Buff),' ', SizeOfBuff-strlen(Buff)-1);
        Buff[SizeOfBuff-1]='\0';
    }

    input=WX11_CmdOpen (INPUT,cmd,x,y,width,height, WX11_ColorGet(INPUTBG), WX11_ColorGet(INPUTFG), Bordo, Buff);

    int WidthText=XTextWidth(input->Font,Buff,SizeOfBuff);
    if (WidthText > input->Width)
    {
        input->Width=WidthText;
        XMoveResizeWindow(WX11_GetDisplay(), input->win,
	   input->x, input->y, input->Width, input->Height);
    }

    //x+=width;
    x=0;
    y+=input->Height;

    WX11_Locate (cmd,1,&x,&y);

    return (input);
}

