/* 
-------------------------------------------------------------- 
Copyright 2007-2008 Max Cavallo ixamit@gmail.com - All Rights Reserved

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, Inc., 675 Mass Ave, Cambridge MA 02139,USA; either version 2 of the License, or (at your option) any later version; incorporated herein by reference.
-------------------------------------------------------------- 
*/


#include "X11/xpm.h"
#include "finestre.h"
/*
Pixmap MyCreatePixmap (dpy, d, width, height, depth)
    register Display *dpy;
    Drawable d;
    unsigned int width, height, depth;
{
    Pixmap pid;
    register xCreatePixmapReq *req;

    LockDisplay(dpy);
    GetReq(CreatePixmap, req);
    req->drawable = d;
    req->width = width;
    req->height = height;
    req->depth = depth;
    pid = req->pid = XAllocID(dpy);
    UnlockDisplay(dpy);
    SyncHandle();
    return (pid);
}
*/
int WX11_ImgXPM (CmdInfo *cmd,char *file)
{
	Display *dpy=WX11_GetDisplay();

	XpmAttributes attrib;
        GC gc_pix;
        Pixmap pix;
	int erf=0;

	attrib.valuemask = 0;
	XImage *img,*clp;
	erf=XpmReadFileToImage (
		WX11_GetDisplay(), 
		file, 
		&img,
		&clp,
		&attrib);

        if (erf)
        {
                printf ("Image %s not found\n",file);
                return (erf);
        }

    	unsigned char R=(cmd->Bg & 0xFF0000)>>16;
    	unsigned char G=(cmd->Bg & 0x00FF00)>>8;
    	unsigned char B=(cmd->Bg & 0x0000FF)>>0;
	int size=(img->bytes_per_line * img->height) -1;
	int x;
	for (x=0;x<size;x+=4)
	{
		if (img->data[x+0]==0 && img->data[x+1]==0 && img->data[x+2]==0 && img->data[x+3]==0)
		{
			img->data[x+0]=B;
			img->data[x+1]=G;
			img->data[x+2]=R;
		}
	}



	pix = XCreatePixmap(dpy, cmd->win, img->width, img->height, img->depth);
	if (!pix)
	{
		printf ("Error in pixmap (imgxpm)\n");
		return (1);
	}

	gc_pix = WX11_GCNew (pix);
	XPutImage(dpy, pix,gc_pix, img, 0, 0, 0, 0, img->width, img->height);

	cmd->gc=gc_pix;
	cmd->pix=pix;
	cmd->pix_width=attrib.width;
	cmd->pix_height=attrib.height;
	cmd->pix_depth=img->depth;

	if (img) XDestroyImage(img);
	if (clp) XDestroyImage(clp);

	XpmFreeAttributes (&attrib);
	
	return (erf);
}
		
