/* Copyright (C) 2001-2002 Bart Massey and Jamey Sharp.
 * All Rights Reserved.
 * Portions Copyright 1986, 1998  The Open Group
 * 
 * See the file COPYING for licensing information. */
#include "xclint.h"

char **XListExtensions(Display *dpy, int *nextensions)
{
#if 0 /* not implemented yet */
	xListExtensionsReply rep;
	char **list;
	char *ch;
	register unsigned i;
	register int length;
	register xReq *req;
	register long rlen;

	LockDisplay(dpy);
	GetEmptyReq (ListExtensions, req);

	if (! _XReply (dpy, (xReply *) &rep, 0, xFalse)) {
	    UnlockDisplay(dpy);
	    SyncHandle();
	    return (char **) NULL;
	}

	if (rep.nExtensions) {
	    list = (char **) Xmalloc (
                (unsigned)(rep.nExtensions * sizeof (char *)));
	    rlen = rep.length << 2;
	    ch = (char *) Xmalloc ((unsigned) rlen + 1);
                /* +1 to leave room for last null-terminator */

	    if ((!list) || (!ch)) {
		if (list) Xfree((char *) list);
		if (ch)   Xfree((char *) ch);
		_XEatData(dpy, (unsigned long) rlen);
		UnlockDisplay(dpy);
		SyncHandle();
		return (char **) NULL;
	    }

	    _XReadPad (dpy, ch, rlen);
	    /*
	     * unpack into null terminated strings.
	     */
	    length = *ch;
	    for (i = 0; i < rep.nExtensions; i++) {
		list[i] = ch+1;  /* skip over length */
		ch += length + 1; /* find next length ... */
		length = *ch;
		*ch = '\0'; /* and replace with null-termination */
	    }
	}
	else list = (char **) NULL;

	*nextensions = rep.nExtensions;
	UnlockDisplay(dpy);
	SyncHandle();
	return (list);
#else
	char **list = malloc(sizeof(char *));
	list[0] = malloc(sizeof(char) * 2) + 1;
	list[0][0] = '\0'; /* just to be safe */
	*nextensions = 0;
	return 0; /* no extensions available */
#endif
}

int XFreeExtensionList(char **list)
{
	if(list != NULL)
	{
		Xfree(list[0]-1);
		Xfree((char *)list);
	}
	return 1;
}
