
static
gboolean waste = TRUE;
G_MODULE_EXPORT
gboolean force_override = FALSE;
/* this *must* be thread safe, (hence _POSIX_PATH_MAX) */
G_MODULE_EXPORT
char child_file [_POSIX_PATH_MAX];

static int overwrite_dlg_result;
static
time_t initial;

static gint stop_watch;
static int child_mode;
static int nitems;
static long long lastsizeT;
static long long sizeT;
static int  countT;
static int child_path_number;
static FILE *plaintmpfile;
static time_t deltatime;

static int rwStderr(int n, void *data, void *user_data);
static int rwStdout(int n, void *data, void *user_data);
static void rwForkOver(pid_t pid, void *user_data);
static void ChildTransfer(gpointer data);
static void set_innerloop(gboolean state, widgets_t *widgets_p);



static void close_it(widgets_t *widgets_p)
{
    gtk_main_quit();
    gtk_widget_destroy(widgets_p->remove);
    widgets_p->remove = NULL;
}

static gboolean on_destroy_event(GtkWidget * widget, GdkEvent * event, gpointer user_data)
{
    widgets_t *widgets_p = (widgets_t *)user_data; 
    overwrite_dlg_result = DLG_CANCEL;
    close_it(widgets_p);
    return TRUE;
}

static void on_copy_no_activate(GtkButton * button, gpointer user_data)
{
    widgets_t *widgets_p = (widgets_t *)user_data; 
    GtkWidget *check;
    overwrite_dlg_result = DLG_NO;
    check = lookup_widget(widgets_p->remove,"togglebutton1");
    force_override = gtk_toggle_button_get_active((GtkToggleButton *) check);
    if (force_override) overwrite_dlg_result = DLG_CANCEL;
    close_it(widgets_p);
}

static void on_copy_yes_activate(GtkButton * button, gpointer user_data)
{
    widgets_t *widgets_p = (widgets_t *)user_data; 
    GtkWidget *check;
    overwrite_dlg_result = DLG_YES;
    check = lookup_widget(widgets_p->remove,"togglebutton1");
    force_override = gtk_toggle_button_get_active((GtkToggleButton *) check);
	waste = FALSE;

    close_it(widgets_p);
}
static void on_copywaste_yes_activate(GtkButton * button, gpointer user_data)
{
    widgets_t *widgets_p = (widgets_t *)user_data; 
    GtkWidget *check;
    overwrite_dlg_result = DLG_YES;
    check = lookup_widget(widgets_p->remove,"togglebutton1");
    force_override = gtk_toggle_button_get_active((GtkToggleButton *) check);
	waste = TRUE;

    close_it(widgets_p);
}


static int make_overwrite_dialog(widgets_t *widgets_p, const gchar *err, const gchar *target, const gchar *src)
{
    gchar *mess;
    struct stat st;

    waste = TRUE;
    widgets_p->remove = xffm_create_remove(widgets_p);

    g_signal_connect(lookup_widget(widgets_p->remove,"cancelbutton"), "clicked", G_CALLBACK(on_copy_no_activate), widgets_p);
    g_signal_connect(lookup_widget(widgets_p->remove,"removebutton"), "clicked", G_CALLBACK(on_copy_yes_activate), widgets_p);
    g_signal_connect(lookup_widget(widgets_p->remove,"wastebutton"), "clicked", G_CALLBACK(on_copywaste_yes_activate), widgets_p);

    g_signal_connect(widgets_p->remove, "delete-event", G_CALLBACK(on_destroy_event), widgets_p);
    g_signal_connect(widgets_p->remove, "destroy-event", G_CALLBACK(on_destroy_event), widgets_p);

    /* dialog specifics */
   
    if(err)
    {
	char mess[_POSIX_PATH_MAX];
	sprintf(mess, _("Try again (%s)?"), err);
	gtk_label_set_text((GtkLabel *) lookup_widget(widgets_p->remove,"label16"), mess);
	hideit(widgets_p->remove, "question");
    }
    else
    {
	gtk_label_set_text((GtkLabel *) lookup_widget(widgets_p->remove,"label16"), _("Warning"));
	hideit(widgets_p->remove, "warning");
    }

    gtk_label_set_text((GtkLabel *) lookup_widget(widgets_p->remove,"label22"), _("Overwrite"));    

    lstat(target,&st);
    if (src){
       struct stat s_st;
       gchar *t1=NULL,*t2=NULL;
       gchar *s1=NULL,*s2=NULL;
       if (lstat(src,&s_st)<0){
	   g_warning("cannot stat %s",src);
       }
       {
	   s1=g_strdup(time_to_string(s_st.st_mtime));
	   s2=g_strdup(sizetag((off_t)s_st.st_size,-1));
	   t1=g_strdup(my_utf_string(target));
	   t2=g_strdup(my_utf_string(src));
       }
       mess=g_strdup_printf(_("Overwrite %s\n(%s %s)\n with \n%s\n(%s %s)?"),
	      t1,time_to_string(st.st_mtime),sizetag((off_t)st.st_size, -1),
	      t2,s1,s2);
       g_free(s1);
       g_free(s2);
       g_free(t1);
       g_free(t2);
    } else {
       mess=g_strdup_printf("%s\n(%s %s)",
	       (target),time_to_string(st.st_mtime), sizetag((off_t)st.st_size, -1)); 
    }

    gtk_label_set_text((GtkLabel *) lookup_widget(widgets_p->remove,"label20"), mess);
    g_free(mess);mess=NULL;
    {
      GdkPixbuf	*pb;
      GtkImage *image=(GtkImage *)lookup_widget(widgets_p->remove,"adicon");
      pb = icon_tell(widgets_p, MEDIUM, "xffm/waste_basket_full");
      if (pb) {
	gtk_image_set_from_pixbuf (image, pb);
	g_object_unref (G_OBJECT (pb));
      }
    }

    gtk_widget_realize(widgets_p->remove);
    place_dialog(widgets_p->window, widgets_p->remove);
    gtk_widget_show(widgets_p->remove);
    if (getenv("XFFM_DEFAULT_UNLINK") && strcmp(getenv("XFFM_DEFAULT_UNLINK"),"unlink")==0){
	  gtk_widget_grab_focus (lookup_widget(widgets_p->remove,"removebutton"));	    
    }
    else if (getenv("XFFM_DEFAULT_UNLINK") && strcmp(getenv("XFFM_DEFAULT_UNLINK"),"waste")==0){
	  gtk_widget_grab_focus (lookup_widget(widgets_p->remove,"wastebutton"));	    
    }

    if (widgets_p->type != DESKVIEW_TYPE) {
	gtk_window_set_transient_for(GTK_WINDOW(widgets_p->remove), 
		    GTK_WINDOW(widgets_p->window));
    }
    
    if (strstr(target,"/..Wastebasket"))    {
	hideit(widgets_p->remove, "wastebutton");
    }

    gtk_main();
    return overwrite_dlg_result;
}






static void get_selection(GtkTreeModel * treemodel, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
{
    record_entry_t *en;
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if (en && en->path) fprintf(plaintmpfile, "%d\t%s\t%s\n", TR_COPY, en->path, en->path);
    return;
}



static gchar *mktgpath(char *target_dir, char *source)
{
    gchar *name = g_path_get_basename(source);
    gchar *target = g_build_filename(target_dir,name,NULL);
    g_free(name);
    return target;
}

static int ok_input(widgets_t *widgets_p,char *target, record_entry_t * s_en)
{
    /*struct stat tgt_stat;*/
    /*gboolean target_exists = TRUE;*/

    if(IS_XF_FIFO(s_en->type) || IS_XF_CHR(s_en->type) || IS_XF_BLK(s_en->type) || IS_XF_SOCK(s_en->type))
    {
        print_diagnostics(widgets_p,"xffm/error", strerror(EBADF)," : ", s_en->path, " --> ", target,"\n", NULL);
        return (DLG_CONTINUE);
    }
    
    if (!g_file_test(target,G_FILE_TEST_EXISTS))return (DLG_CONTINUE);
    /*if(stat(target, &tgt_stat) < 0) return (DLG_CONTINUE);*/

#if 0
/* inode determination */
    if (tgt_stat.st_ino == s_en->st->st_ino){
	print_diagnostics(widgets_p,"xffm/error",strerror(EEXIST)," : ", s_en->path, " --> ", target,"\n", NULL);
	return (DLG_CONTINUE);
    }
#endif
    try_again:
    overwrite_dlg_result = DLG_YES;
    xffm_warn_target_exists(widgets_p,target, s_en->path);
    if(overwrite_dlg_result == DLG_YES && waste){
	if(!xffm_waste(widgets_p, target))
	{
	    /* error message set within wasteit() */
	    goto try_again;
	}
    }
    return overwrite_dlg_result;
}


static void ChildTransfer(gpointer data)
{
    	
    lastsizeT=0;
    child_path_number = 0;
    sizeT = 0;
    deltatime = 100001;


    /* child */
#define MAX_ARGUMENTS 102
    {
	FILE *tfile;
	static gchar *sources[MAX_ARGUMENTS];
	gchar line[MAX_LINE_SIZE+1];
	int i,initial_i;
	gchar *tgt=NULL;
	/*int this_count=0;*/
	
	if (!countT) {
	    fprintf(stdout,"child:Nothing to transfer!\n"); 
	    _exit(123);
	}
	if ((tfile = fopen(child_file, "r"))==NULL) {
	    fprintf(stdout,"child:open: %s %s\n",strerror(errno),child_file); 
	    _exit(123);
	}
	memset((void *)line,0,MAX_LINE_SIZE+1);
	i=0;
	if (child_mode & TR_MOVE) sources[i++] = "mv";
	else if(child_mode & TR_LINK) {
	    sources[i++] = "ln"; 
	    sources[i++] = "-s"; 
	    sources[i++] = "-v"; 
	
	} else { 
	    sources[i++] = "cp"; 
	    sources[i++] = "-p"; 
	    sources[i++] = "-R";
	    /* follow symlinks on command line? */
	    sources[i++] = "-H";
	}  
	sources[i++] = "-f";
	/*sources[i++] = "-v";*/
	initial_i=i;
	while (!feof(tfile)){
	    /*int status;*/
	    for (i=initial_i; 
		    i<MAX_ARGUMENTS-2 && !feof(tfile) && fgets(line, MAX_LINE_SIZE - 1, tfile); 
		    i++) 
	    {
		int type;
		gchar *source, *target;
		type = atoi(strtok(line, "\t"));
		source = strtok(NULL, "\n");
		target = strrchr(source, '\t') + 1;
		*(strrchr(source, '\t')) = 0;
		sources[i] = g_strdup(source);
		if (!tgt) {
		    if (child_mode & TR_DUPLICATE) tgt=g_strdup(target);
		    else tgt = g_path_get_dirname(target);
		}
	    }
	    sources[i++]=tgt;
	    sources[i]=NULL;
#ifdef DEBUG
	    {
		int j;
		for (j=0; j<i; j++){
		    fprintf(stderr,"child:argument %d: %s\n",j,sources[j]);
		}
		fprintf(stderr,"child:forking %s with %d arguments\n",sources[0],i);
	    }
#endif
	
	    execvp(sources[0],sources);
	    fprintf(stderr,"child:error on execvp(%s)!\n",sources[0]);
	    _exit(123);
    

	}
	fclose(tfile);
    }
    
	    
    /*printf("child:finished all forks!\n");  */
    _exit(123);
}

/* function to clean up the mess after child process
 * has been sent a SIGTERM. (Might a unlink target be 
 * good here?)
 * */
static void cpyForkCleanup(void *user_data)
{
    widgets_t *widgets_p=user_data;
    /* break inner gtk_main() loop */
#ifdef DEBUG
    fprintf(stderr,"dbg:call to innerloop from forkcleanup\n"); 
#endif
    set_innerloop(FALSE,widgets_p);
    /* unlink(fork_target); */
}

static gint watch_stop(gpointer data)
{
    widgets_t *widgets_p=data;
    time_t current=time(NULL);
    if (current - initial != deltatime) {
	gchar *g;
	deltatime = current - initial;
	/*g=g_strdup_printf("cp/mv %ld %s",(long)(deltatime),_("seconds"));*/
	g=g_strdup_printf(dngettext(GETTEXT_PACKAGE,"Copy/Move: %ld second","cp/mv: %ld seconds",(long)(deltatime)), (long)(deltatime));
	print_status(widgets_p,"xffm/warning",g,NULL);
	g_free(g);
    }
    if (!widgets_p->tubo_object) return FALSE;
    if(widgets_p->stop)
    {
	print_status(widgets_p,"xffm/error",strerror(ECANCELLED),NULL);
	widgets_p->stop = FALSE;
	hide_stop(widgets_p);
	cursor_reset(widgets_p->window);
	widgets_p->tubo_object = TuboCancel(widgets_p->tubo_object, cpyForkCleanup, widgets_p);
	return FALSE;
    }
    set_progress_generic(widgets_p,-1, -1, 1);
    return TRUE;
}

static void set_innerloop(gboolean state, widgets_t *widgets_p)
{
    static gboolean innerloop = FALSE;
    if(state == innerloop)
	return;
    innerloop = state;
    /*fprintf(stderr,"dbg:innerloop %s\n",(state)?"started":"terminated");fflush(NULL); */
    if(state){
	stop_watch = g_timeout_add(260, (GtkFunction) watch_stop, widgets_p);
       	gtk_main();
    }
    else {
	g_source_remove(stop_watch);
	gtk_main_quit();
    }
}

/* function to process stderr produced by child */
static int rwStderr(int n, void *data, void *user_data)
{
    widgets_t *widgets_p=user_data;
    char *line;

    if(n)
	return TRUE;		/* this would mean binary data */
    line = (char *)data;
#ifdef DEBUG
    fprintf(stderr, "child stderr:%s\n", line);
#endif
    if (strlen(line)==0 || line[0]=='\n') return TRUE;
    print_diagnostics(widgets_p,"xffm/error", line, NULL);
    process_pending_gtk();
    return TRUE;
}


/* function to process stdout produced by child */
static int rwStdout(int n, void *data, void *user_data)
{
    widgets_t *widgets_p=user_data;
    char *line, *texto;

    if(n)
	return TRUE;		/* this would mean binary data */
    line = (char *)data;


#ifdef DEBUG
    fprintf(stderr,"dbg(rwStdout):%s",line);fflush(NULL); 
#endif
    
    /* only process child specific lines: */
    if(strncmp(line, "child:", strlen("child:")) != 0)
    {
	if (strlen(line)==0 || line[0]=='\n') return TRUE;
	print_diagnostics(widgets_p,"xffm/info", line, NULL);
	process_pending_gtk();
	return TRUE;
    }

    /* anything else is a process_error() and operation
     * should continue with a diagnostics message.  */
    strtok(line, ":");
    texto = strtok(NULL, "\n");
    print_diagnostics(widgets_p,NULL, texto, "\n", NULL);
    process_pending_gtk();
    return TRUE;
}

/* function called when child is dead */
static void rwForkOver(pid_t pid, void *user_data)
{
    widgets_t *widgets_p=user_data;
    gchar *g;
#ifdef DEBUG
    fprintf(stderr,"dbg: call to innerloop from forkover()\n");fflush(NULL); 
#endif
    set_innerloop(FALSE, widgets_p);
    set_progress_generic(widgets_p,-1, -1, -1);
    g=g_strdup_printf(dngettext(GETTEXT_PACKAGE,"Finished (%d/%d) : %ld second","Finished (%d/%d) : %ld seconds",(long)(time(NULL) - initial)), nitems, countT, (long)(time(NULL) - initial));

    print_status(widgets_p,"xffm/info", g, NULL);
    g_free(g);
    hide_stop(widgets_p);
    cursor_reset(widgets_p->window);
    widgets_p->stop = FALSE;
    widgets_p->tubo_object = NULL;
}


