/*
 * Copyright (C) 2005 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "constants.h"
#include "types.h"
#include "primary.h"
#include "gui.h"
#include "actions_lib.h"


G_MODULE_EXPORT
void gui_save_to_go_history (char *p)
{				
    gchar *f=g_build_filename(xdg_cache_dir(),GOTO_DBH_FILE,NULL);
    COMBO_save_to_history(f,p);
    g_free(f);
}

G_MODULE_EXPORT
void gui_save_workdir_history(char *p){
    gchar *f=g_build_filename(xdg_cache_dir(),WORKDIR_DBH_FILE,NULL);
    COMBO_save_to_history(f,p);
    g_free(f);
}

G_MODULE_EXPORT
int gui_extra_key_completion (gpointer data)
{
    	GtkEntry *entry;
	gboolean interm;
	gboolean hold;
      	GtkWidget *check;
      	const gchar *choice ;
	widgets_t *widgets_p=(widgets_t *)data;
	
	if (!widgets_p){
	    g_warning("!widgets_p");
	    return FALSE;
	}
    	if (widgets_p->input != RUN_INPUT && widgets_p->input !=  RUN_DOUBLE_CLICK) return FALSE;
	    
	
	entry=(GtkEntry *)lookup_widget(widgets_p->window,"input_entry");
      	check = lookup_widget(widgets_p->window,"checkbutton3");
      	/*choice = g_strdup((gchar *)gtk_entry_get_text((GtkEntry *)entry));*/
      	choice = gtk_entry_get_text((GtkEntry *)entry);

	xffm_recover_flags((gchar *)choice, &interm, &hold);
        gtk_toggle_button_set_active ((GtkToggleButton *)check,hold);
	gtk_button_set_label((GtkButton *) check, _("Hold"));
      	check = lookup_widget(widgets_p->window,"checkbutton1");
        gtk_toggle_button_set_active ((GtkToggleButton *)check,interm);	
	TRACE("at gui_extra_key_completion!\n");
	return FALSE;
}


