static gchar *password=NULL;
static GtkWidget * user, *passwd, *dialog;
static int passwd_caso;



static void
destroy_dialog (GtkWidget * widget, gpointer data)
{
  gtk_widget_destroy ((GtkWidget *) data);
  gtk_main_quit ();
}

static void
cancel_dialog (GtkWidget * widget, gpointer data)
{
  g_free(password);
  password=NULL;
  gtk_widget_destroy ((GtkWidget *) data);
  gtk_main_quit ();
}

static void
ok_dialog (GtkWidget * widget, gpointer data)
{
  char *s, *t;
  int caso;

  caso = (int) ((long) data);

  s = (char *)gtk_entry_get_text (GTK_ENTRY (user));
  t = (char *)gtk_entry_get_text (GTK_ENTRY (passwd));
  if (!strlen(s)) s="Guest";

  g_free(password);
  if (strlen (t) > 0) 
      password=g_strdup_printf ("%s%c%s", s,'%',t);
  else 
      password=g_strdup_printf ("%s%c", s,'%');

  gtk_widget_destroy (dialog);
  gtk_main_quit ();
}

static void
entry_activate (GtkWidget * entry, GdkEventKey * event, gpointer data)
{
  {
    if (entry == user)  gtk_widget_grab_focus (passwd);
    if (entry == passwd) ok_dialog (NULL, NULL);
  }
  return;

}
static const gchar *
passwd_dialog (widgets_t *widgets_p,int caso,const gchar *init_password, const gchar *ptext)
{
  GtkWidget *button, *hbox, *label;
  gboolean user_mapped=FALSE;

  passwd_caso = caso;
  if (init_password){
      g_free(password);
      password=g_strdup(init_password);
  }

  /*SMBabortdrop=TRUE;*/
  dialog = gtk_dialog_new ();
  if (widgets_p) place_dialog(widgets_p->window, dialog);
  
  gtk_window_set_resizable (GTK_WINDOW (dialog), FALSE);
  gtk_container_set_border_width (GTK_CONTAINER (dialog), 5);
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);

  gtk_widget_realize (dialog);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), hbox, TRUE, TRUE, 0);
  gtk_widget_show (hbox);

  if (caso == 1 || caso == 11){
    if (ptext) label = gtk_label_new (ptext);
    else label = gtk_label_new (_("Please provide information for server "));
  }
  else {
    label = gtk_label_new (_("Please provide browsing preferences "));
  }
  
  gtk_box_pack_start (GTK_BOX (hbox), label, NOEXPAND, NOFILL, 0);
  gtk_widget_show (label);

  gtk_widget_show (hbox);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), hbox, TRUE, TRUE, 0);
  if (caso != 11) {
      user_mapped=TRUE;
      gtk_widget_show (hbox);
  }

  label = gtk_label_new (_("Username : "));
  gtk_box_pack_start (GTK_BOX (hbox), label, NOEXPAND, NOFILL, 0);
  gtk_widget_show (label);

  user = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX (hbox), user, EXPAND, NOFILL, 0);
  g_signal_connect (G_OBJECT (user), "activate", 
		  GTK_SIGNAL_FUNC (entry_activate), NULL);
  gtk_widget_show (user);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), hbox, TRUE, TRUE, 0);
  gtk_widget_show (hbox);

  label = gtk_label_new (_("Password  : "));
  gtk_box_pack_start (GTK_BOX (hbox), label, NOEXPAND, NOFILL, 0);
  gtk_widget_show (label);

  passwd = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX (hbox), passwd, EXPAND, NOFILL, 0);
  gtk_entry_set_visibility ((GtkEntry *) passwd, FALSE);
  g_signal_connect (G_OBJECT (passwd), "activate", GTK_SIGNAL_FUNC (entry_activate), NULL);
  gtk_widget_show (passwd);

  button = gtk_button_new_with_label (_("Ok"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area), button, EXPAND, NOFILL, 0);
  gtk_widget_show (button);
  g_signal_connect (G_OBJECT (button), "clicked", GTK_SIGNAL_FUNC (ok_dialog), (gpointer) ((long) caso));
  button = gtk_button_new_with_label ("Cancel");
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area), 
		  button, EXPAND, NOFILL, 0);
  gtk_widget_show (button);
  g_signal_connect (G_OBJECT (button), "clicked", 
		  GTK_SIGNAL_FUNC (cancel_dialog), (gpointer) dialog);
  g_signal_connect (G_OBJECT (dialog), "destroy", 
		  GTK_SIGNAL_FUNC (destroy_dialog), (gpointer) dialog);  
  gtk_widget_show (dialog);
  
  if (caso != 11 && password)
  {
    gchar *u,*p;
    u=g_strdup(password);
    if (strchr(u,'%')){
	p=strchr(u,'%')+1;
	*(strchr(u,'%'))=0;	
    } else p=NULL;
    if (strstr (u, "Guest") == NULL && strstr (u, "GUEST") == NULL){
	if (u && strlen(u)) {
	    gtk_entry_set_text ((GtkEntry *) user, u);
	}
	if (p && strlen(p)) {
	    gtk_entry_set_text ((GtkEntry *) passwd, p);
	}
    }
    
    g_free(u);
  }
  
  if (user_mapped) gtk_widget_grab_focus (user);
  else gtk_widget_grab_focus (passwd);
  
  if (widgets_p) gtk_window_set_transient_for (
		    GTK_WINDOW (dialog), 
		    GTK_WINDOW (widgets_p->window));
  gtk_main();
  return password;
}


