/* primary_i */
/*
 * Copyright (C) 2002-5 Edscott Wilson Garcia
 * EMail: edscott@xfce.org
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* Static functions for primary.c */


static gint all_files=0;


static
void 
set_type_local(		int branch_type,
			record_entry_t *en)
{
    int type=0;
    INHERIT_TYPE(type,branch_type);
    if (!en ||!en->path) goto end;
    if (!en->st) {
	goto end;
    }
#if 0
    if (strstr(en->path,"..Wastebasket")){
	gchar *g=get_path_basename(en->path);
	if (strcmp(g,"..Wastebasket")==0)set wastebasket type 
    }
#endif
    if (g_file_test(en->path,G_FILE_TEST_IS_EXECUTABLE)) SET_EXE(type);
    if (g_file_test(en->path,G_FILE_TEST_IS_SYMLINK))	SET_XF_LNK(type);
    if(access(en->path, R_OK) < 0)	SET_NOACCESS(type);
    if (access(en->path,W_OK)!=0) {
	if (g_file_test(en->path,G_FILE_TEST_IS_DIR) ){
	 SET_NOWRITE(type);
	} else { 
	    /* if you can write to the directory you can
	     * write to the file. Let us check... */
	    gchar *g=g_path_get_dirname(en->path);
	    if (access(g,W_OK)!=0) {
		SET_NOWRITE(type);
	    }
	    g_free(g);
	}
    }
	    
    if(S_ISDIR(en->st->st_mode)) {
	SET_DIR(type);
	if (!IS_XF_LNK(type)) SET_XF_DIR(type);
    }
    else if(S_ISSOCK(en->st->st_mode)) SET_XF_SOCK(type);
    else if(S_ISBLK(en->st->st_mode)) SET_XF_BLK(type);
    else if(S_ISCHR(en->st->st_mode)) SET_XF_CHR(type);
    else if(S_ISFIFO(en->st->st_mode)) SET_XF_FIFO(type);
    else SET_XF_REG(type);
    

end:
    en->type = type;
    return;
}

static gint 
read_files_local(		const gchar *path, 
				gint type, 
				const regex_t * preg, 
				xfdir_t * xfdir)
{
    DIR *directory;
    gint count = 0;
    gint smallcount = 0;
    struct dirent *d;
    struct stat st;

    all_files = 0;

    if (preg) TRACE("filtering will be done");
    directory = opendir(path);
    if(!directory) return count;
    while((d = readdir(directory)) != NULL)
    {
	gchar *fullpath=NULL;
	gboolean broken=FALSE;
	if(strcmp(d->d_name, ".")==0 || strcmp(d->d_name, "..")==0)  continue;
	all_files++;
	if(!SHOWS_HIDDEN(type) && strcmp(d->d_name,"..Wastebasket") != 0 && d->d_name[0] == '.') continue;
	
	if (preg) { /* filtering will be done */
	    fullpath = g_build_filename(path, d->d_name,NULL);
	    if (stat(fullpath, &st)<0) {
		if (lstat(fullpath, &st)<0) {
		    g_free(fullpath);
		    continue;
	       }	   
	       broken=TRUE;
	    }
	    if (!S_ISDIR(st.st_mode) && regexec(preg, d->d_name, 0, NULL, 0)){
	        g_free(fullpath);
		TRACE("%s -> filtered",d->d_name);
	        continue;   
	    }
	}
	if(xfdir != NULL)
	{
	    if (!fullpath) {
	       fullpath = g_build_filename(path, d->d_name,NULL);
	       if (stat(fullpath, &st)<0){
		    if (lstat(fullpath, &st)<0) {
			g_free(fullpath);
			continue;
		    }	   
		    broken=TRUE;
	       }
	    }
	    xfdir->gl[count].pathv = g_strdup(d->d_name);
	    xfdir->gl[count].en = mk_entry(type);
	    xfdir->gl[count].en->path = fullpath;
	    xfdir->gl[count].en->st = (struct stat *)malloc(sizeof(struct stat));
	    memcpy(xfdir->gl[count].en->st, &st, sizeof(struct stat));
	    /* set the local file type specifics: */
	    if (broken) SET_BROKEN_LNK(xfdir->gl[count].en->type);
	    else set_type_local(type,xfdir->gl[count].en);
	} else {
	    g_free(fullpath);
	}
	count++;
	if (++smallcount & 0x100) {
	  smallcount=0;
	  process_pending_gtk();
	}
    }
    closedir(directory);
    return (count);
}



static
void
save_xfdir_cache(record_entry_t *en,xfdir_t *xfdir_p){
    FILE *info;
    const gchar *cache_path;
    int j;
    
    if (!xfdir_p || !en ||!en->path || !strlen(en->path)) return;
    if ((cache_path=get_local_cache_path(en->path))==NULL) return;

    TRACE("writing local cache: %s for %s",cache_path,en->path);
    info=fopen(cache_path,"wb");
    if (!info) return;

    j=en->st->st_mtime + en->st->st_ctime 
	+ en->st->st_dev 
	+ SHOWS_HIDDEN(en->type);
    fwrite(&j,sizeof(int),1,info);
    fwrite(&(xfdir_p->pathc),sizeof(int),1,info);
    
    for(j = 0; j < xfdir_p->pathc; j++) {
	int path_length=0;
	if (!xfdir_p->gl[j].pathv || !xfdir_p->gl[j].en){
	    continue;
	}
	path_length = strlen(xfdir_p->gl[j].en->path);
	fwrite(&path_length,sizeof(int),1,info);
	fwrite(xfdir_p->gl[j].en->path,path_length,1,info);
	
	fwrite(&(xfdir_p->gl[j].en->type),sizeof(int),1,info);
	fwrite(&(xfdir_p->gl[j].en->subtype),sizeof(int),1,info);
	fwrite(xfdir_p->gl[j].en->st,sizeof(struct stat),1,info);
    }

    fclose(info);
    return;
}

#define MAX_CACHE_LINE 255

static
gboolean
read_xfdir_cache(record_entry_t *en,xfdir_t *xfdir_p){
    FILE *info;
    const gchar *cache_path;
    int j,k;
    char *line=NULL;
    
    if (!xfdir_p || !en || !en->path || !strlen(en->path)) return FALSE;
    if ((cache_path=get_local_cache_path(en->path))==NULL) return FALSE;
    if (!en->st) {
	g_warning("critical: en->st!=NULL");
    }

    TRACE("reading local cache: %s for %s",cache_path,en->path);
    info=fopen(cache_path,"rb");
    if (!info) {
	TRACE("cannot open cache for read: %s for %s\n",cache_path,en->path);
	return FALSE;
    }
    xfdir_p->gl = NULL;
    if (fread(&j,sizeof(int),1,info) != 1) {
short_read:
	TRACE("Short read in %s. Deleting",cache_path);
	g_free(line);
	g_free(xfdir_p->gl);
	fclose(info);
	unlink(cache_path);
	return FALSE;
    }
    k=	en->st->st_mtime + en->st->st_ctime
	+ en->st->st_dev 
	+ SHOWS_HIDDEN(en->type);

    if (j != k){
	TRACE("cache outofdate: %s (%d != %d)",en->path,j,k);
	goto short_read;
    } 
    
    if (fread(&(xfdir_p->pathc),sizeof(int),1,info) != 1) goto short_read;
    if (!xfdir_p->pathc) {
	TRACE("xfdir_p->pathc == 0\n");
	goto short_read;
    }
    
    xfdir_p->gl = (dir_t *) malloc(xfdir_p->pathc * sizeof(dir_t));
    if (!xfdir_p->gl) {
	TRACE("cannot malloc xfdir_p->gl\n");
	goto short_read;
    }
    /* xfdir_p->gl is allocated... */
	    
    line=(gchar *)malloc(MAX_CACHE_LINE+1);  
    for(j = 0; j < xfdir_p->pathc && !feof(info); j++)
    {
	int path_length=0;
	if (fread(&path_length,sizeof(int),1,info)!=1) goto short_read;

	if (path_length > MAX_CACHE_LINE) {
	    g_free(line);
	    line = (gchar *)malloc(path_length+1);
	    if (!line) goto short_read;
	}
	    
	if (fread(line,path_length,1,info)!=1) goto short_read;

	line[path_length]=0;	
	xfdir_p->gl[j].en = mk_entry(en->type);
	if (!xfdir_p->gl[j].en) goto short_read;

	if (fread(&(xfdir_p->gl[j].en->type),sizeof(int),1,info)!=1) goto short_read;
	if (fread(&(xfdir_p->gl[j].en->subtype),sizeof(int),1,info)!=1) goto short_read;
	
	xfdir_p->gl[j].en->path = g_strdup(line);
	xfdir_p->gl[j].pathv = g_path_get_basename(line);
	xfdir_p->gl[j].en->st = (struct stat *)malloc(sizeof(struct stat));
	if (fread(xfdir_p->gl[j].en->st,sizeof(struct stat),1,info)!=1) goto short_read;
    }
    g_free(line);
    fclose(info);
    TRACE("cache read ok");
    return TRUE;
}

static 
const gchar *
filter2regex(		const gchar *filter, 
			gboolean shows_hidden)
{
    static char *regex=NULL;
    g_free(regex);
    /* change stars to regexp */
    if(!filter || strcmp(filter, "*") == 0 || strlen(filter) == 0)
    {
	regex = g_strdup("^.+$");
    }
    else
    {
	/*Let's translate stars to regexp */
	regex = (char *)malloc(2 * strlen(filter) + 1 + strlen("|^\\..+"));
	if(filter[0] == '*' && filter[strlen(filter) - 1] == '*')
	{
	    strcpy(regex, filter + 1);
	    regex[strlen(regex) - 1] = 0;
	}
	else if(filter[0] == '*')
	{
	    strcpy(regex, filter + 1);
	    strcat(regex, "$");
	    if(shows_hidden)
	    {
		strcat(regex, "|\\.");
		strcat(regex, filter + 1);
		strcat(regex, "$");
	    }
	}
	else if(filter[strlen(filter) - 1] == '*')
	{
	    strcpy(regex + 1, filter);
	    regex[0] = '^';
	    regex[strlen(filter)] = 0;
	    if(shows_hidden)
	    {
		strcat(regex, "|^\\.");
		strcat(regex, filter);
		regex[strlen(regex) - 1] = 0;
	    }
	}
	else if(strchr(filter, '*'))
	{
	    strcpy(regex + 1, filter);
	    regex[0] = '^';
	    *strchr(regex, '*') = 0;
	    strcat(regex, ".+");
	    strcat(regex, strchr(filter, '*') + 1);
	    strcat(regex, "$");
	    if(shows_hidden)
	    {
		char *aux;
		aux = g_strdup(regex + 1);
		strcat(regex, "|^\\.");
		strcat(regex, aux);
		g_free(aux);
		aux=NULL;
	    }
	}
	else
	    strcpy(regex, filter);

    }
    TRACE("regex=%s\n",regex); 

    return (const gchar *)regex;
}

static gint 
count_hidden_files(gchar *path)
{
    DIR *directory;
    struct dirent *dir;
    gint count = 0;

    directory = opendir(path);
    if(!directory) return -1;
    while((dir = readdir(directory)) != NULL)
    {
	if(strcmp(dir->d_name, ".") == 0 || 
	   strcmp(dir->d_name, "..") == 0 || 
	   strcmp(dir->d_name, "..Wastebasket") == 0)
	    continue;
	if(dir->d_name[0] == '.') count++;
    }
    closedir(directory);
    return (count);
}

