
static int childFD;
extern gboolean force_override;
static pid_t Gpid;
static gboolean exit_status;


static gint watch_stop(gpointer data)
{
    widgets_t *widgets_p=data;
    
    if(!widgets_p->tubo_object) return FALSE;
    if(widgets_p->stop)
    {
	gchar *m=g_strdup_printf("%d", Gpid);
	print_diagnostics(widgets_p,"xffm/warning", strerror(ECANCELLED), " pid=", m, NULL);
	g_free(m);
	/*cancelled = TRUE;*/
	TuboCancel(widgets_p->tubo_object, NULL, NULL);
	widgets_p->stop = FALSE;
	widgets_p->tubo_object = NULL;
	
	hide_stop(widgets_p);
	Gpid = 0;
	return FALSE;
    }
    set_progress_generic(widgets_p,-1, -1,1);
    return TRUE;
}

static int operate_stderr(int n, void *data, void *user_data)
{
    widgets_t *widgets_p=user_data;
    char *line;
    if(n)
	return TRUE;		/* this would mean binary data */
    line = (char *)data;
    if (!line) return TRUE;
#ifdef DEBUG
    printf("stderr:%s",line);
    if (strncmp(line,"debug1:",strlen("debug1:"))==0){
	    TRACE("%s",line);
    }
#endif
    if (line[0] != '\n'){
	   if (strncmp(line,"debug1:",strlen("debug1:"))!=0 )  {
	      print_diagnostics(widgets_p, "gnome-fs-ssh.png", line, NULL);
	   }
    }
    if (strstr(line,"debug1: Exit status 1")) exit_status=TRUE;
    
    if (strstr(line,"Next authentication method: password") || strstr(line,"assword:")){
	const char *p;
    	print_diagnostics(widgets_p, "xffm/warning",_("Query password has been requested"),"\n", NULL);
	p=xffm_get_password(widgets_p,_("Query password has been requested"));
	if (p && strlen(p)) write(childFD,p,strlen(p));
	write(childFD,"\n",strlen("\n"));
	return TRUE;
    }
    return TRUE;
}

static int operate_stdout(int n, void *data, void *user_data)
{
    widgets_t *widgets_p=user_data;
    char *line;
    if(n)
	return TRUE;		/* this would mean binary data */
    line = (char *)data;
    print_diagnostics(widgets_p,NULL, line, NULL);
    return TRUE;
}


static void fork_finished_function(pid_t pid, void *user_data)
{
    widgets_t *widgets_p=user_data;
    char m[32];
    int status;
    sprintf(m, "%d\n", pid);

    hide_stop(widgets_p);
    waitpid(pid, &status, WNOHANG);
    if (exit_status)
	    print_diagnostics(widgets_p,"xffm/error", _("Command done"), "\n",NULL);
    else
	    print_diagnostics(widgets_p,"xffm/info",  _("Command done"), "\n",NULL);
    set_progress_generic(widgets_p,-1, -1, -1);
    
    widgets_p->tubo_object = NULL;
}


