
/*static widgets_t *easy_widgets_p;*/
static gchar *script_types[]={
    "application/x-csh",
    "application/x-bsh",
    "application/x-ksh",
    "application/x-shellscript",
    "application/x-tsh",
    "application/x-zsh",
    "application/x-perl",
    NULL
};

typedef struct run_data_t{
    void *object;
    widgets_t *widgets_p;
    gchar *output;
    gchar *workdir;
    gchar *exec_string;
    gchar *command;
    GtkWidget *button;
    int childFD;
}run_data_t;

static void free_run_data(run_data_t *run_data_p);

static 
gboolean 
is_a_script(const gchar *path)
{ 
  const gchar *t=MIME_get_type((const gchar *)path, TRUE);
  if (t) {
      int i;
      for (i=0;script_types[i];i++) if (strncmp(script_types[i],t,strlen(script_types[i]))==0){
	  return TRUE;
      }
  }
  return FALSE;
}
static 
void 
save_to_open_history(		gchar *path2save, 
				gchar *in_cmd, 
				int in_term)
{
    gchar *dbh_file=g_build_filename(xdg_cache_dir(),OPEN_FILE,NULL);
    GString *gs;
    DBHashTable *d;
    gchar *data;
    int length;
    gchar *basename;

    if (!path2save) return;
    basename=g_path_get_basename(path2save);
    if ((d=DBH_open(dbh_file))==NULL){
    	if ((d=DBH_create(dbh_file, 11))==NULL) {
		unlink(dbh_file);
		if ((d=DBH_create(dbh_file, 11))==NULL)	return;
	}
    }
    gs = g_string_new(basename);
    g_free(basename);
    sprintf((char *)DBH_KEY(d), "%10u", g_string_hash(gs));
    g_string_free(gs, TRUE);
    data = (gchar *)DBH_DATA(d);
    if (in_term) *data = 1;
    else *data=0;
    data++;
    
    length=strlen(in_cmd)+2;
    if (length > DBH_MAXIMUM_RECORD_SIZE(d))length = DBH_MAXIMUM_RECORD_SIZE(d);
    
    strncpy(data,in_cmd, length-2);
    DBH_set_recordsize (d,length);
    
    DBH_update(d);
    DBH_close(d);
    g_free(dbh_file);
}

static
const
gchar *
strip_quotes(const gchar *s){
    static gchar *c=NULL;
    g_free(c);
    if (*s=='\"') c=g_strdup(s+1);
    else c=g_strdup(s);
    if (strchr(c,'\"')) *strchr(c,'\"')=0;
    return (const gchar *) c;
}

static int childFD;

static int 
easy_stderr(int n, void *data, void *user_data)
{
    widgets_t *widgets_p=user_data;
    char *line;
    if(n) return TRUE;		/* this would mean binary data */
    line = (char *)data;
    /*printf("stderr:%s",line);*/
    if (strncmp(line,"Password:",strlen("Password:"))==0){
	const char *p;
    	print_diagnostics(widgets_p, "xffm/warning",_("Sudo password requested"),"\n", NULL);
	p=xffm_get_password(widgets_p,_("Sudo password requested"));
	if (p && strlen(p)) write(childFD,p,strlen(p));
	write(childFD,"\n",strlen("\n"));
	return TRUE;
    }
    if (line[0] != '\n') print_diagnostics(widgets_p, "xffm/error", line, NULL);
    return TRUE;
}

static int 
easy_stdout(int n, void *data, void *user_data)
{
    widgets_t *widgets_p=user_data;
    char *line;
    if(n) return TRUE;		/* this would mean binary data */
    line = (char *)data;
    /*printf("stdout:%s",line);*/
    show_text(widgets_p);
    print_diagnostics(widgets_p,NULL, line, NULL);
    return TRUE;
}

static void 
easy_finished_function(pid_t pid, void *user_data)
{
    TRACE("TRACE:easy over by fork_finished_function\n");
}

static
gboolean 
destroy_run_button(	GtkWidget *widget,
			GdkEvent *event,
			gpointer data){
    run_data_t *run_data_p=(run_data_t *)data;
    TRACE("destroy_run_button now!");
    if (!data) return TRUE;
    run_data_p->button = NULL;
    TRACE("run_data_p->button = NULL");
    return TRUE;
}

static
void stop_run_info(void *data){
    /*widgets_t *widgets_p=data;
    xffm_confirm (widgets_p,_("Process has been killed"),NULL,_("Ok"));*/
    return;    
}

static
void show_run_info(GtkButton * button, gpointer data)
{
    FILE *pipe;
    gchar runtime[256];
    gboolean alive;
    run_data_t *run_data_p = data;
    gchar *text,*fulltext;
        
    int pid;
	
    TRACE(" run_data_p, run_data_p->object = 0x%x, 0x%x", (unsigned)run_data_p, (unsigned)run_data_p->object);
    if (! run_data_p || ! run_data_p->object){
ya_felpo:
	/* fixme: this should not happen... (but does when you repeatedly open new iconview and execute ls instruction)*/
	TRACE("ya felpo, run_data_p=0x%x",(unsigned)run_data_p);
	TRACE("ya felpo, run_data_p->widgets_p=0x%x",(unsigned)run_data_p->widgets_p);
	/*print_diagnostics(run_data_p->widgets_p, "xffm/info", _("Process has terminated"),"\n",NULL);*/
	gtk_widget_destroy(GTK_WIDGET(button));
	free_run_data(run_data_p);	
	return;
    }

    pid=(int)TuboPID(run_data_p->object);
    if (!pid) {
	TRACE("!pid");
	goto ya_felpo;
    }
    

    sprintf(runtime, "ps -p %d -o time=",pid );
    pipe = popen(runtime, "r");
    if(pipe){
	if (fgets(runtime, 255, pipe)) alive=TRUE;
	else alive=FALSE;
	pclose(pipe);
    }
    
    text = g_strdup_printf(_("\"%s\"\nWork directory = %s\n"),
	    run_data_p->command,
	    run_data_p->workdir);
    
    if (!alive) {
	fulltext = g_strdup_printf(_("%sRemote process has hidden PID\n"),text); 	
    } else {
	fulltext = g_strdup_printf(_("%sPID = %d\nRuntime = %s\n"),text,pid,runtime); 	
    }
    
    if (!xffm_confirm (run_data_p->widgets_p,fulltext,((alive)?_("Kill"):NULL),_("Continue")) ){
	gchar *text2 = g_strdup_printf(_("Are you sure?"));
	if (!xffm_confirm (run_data_p->widgets_p,text2,_("Kill"),_("Continue"))){
	    TuboCancel(run_data_p->object,stop_run_info,run_data_p->widgets_p);
	g_free(text2);
	}
    }				
    g_free(text);
    g_free(fulltext);
}

static void
free_run_data(run_data_t *run_data_p){
    TRACE("free run_data_p now!");
    g_free(run_data_p->command);
    g_free(run_data_p->workdir);
    g_free(run_data_p->output);
    g_free(run_data_p->exec_string);
    g_free(run_data_p);  
    
}


static void 
run_finished_function(pid_t pid, void *user_data)
{
    run_data_t *run_data_p=(run_data_t *)user_data;
    TRACE("run over by fork_finished_function\n");
    if (run_data_p->widgets_p && is_valid_widgets_p(run_data_p->widgets_p)) {
	print_status(run_data_p->widgets_p,"xffm/info",run_data_p->exec_string,NULL);
      if (run_data_p->button && GTK_IS_WIDGET (run_data_p->button)){
	TRACE("run_data_p->button != NULL: doing hide+destroy");
	gtk_widget_hide(run_data_p->button);
	gtk_widget_destroy(run_data_p->button); 
	while (gtk_events_pending()) gtk_main_iteration();
      }
      if (run_data_p->widgets_p && run_data_p->widgets_p->diagnostics_window){
	  g_object_set_data(G_OBJECT(run_data_p->widgets_p->diagnostics_window),"concluded",GINT_TO_POINTER(1));
      }
    run_data_p->object=NULL;
    free_run_data(run_data_p);
    }
    else {
	g_warning("run_data_p->widgets_p && is_valid_widgets_p(run_data_p->widgets_p) is false!");
	TRACE("run_data_p=0x%x",(unsigned)run_data_p);
	TRACE("run_data_p->widgets_p=0x%x",(unsigned)run_data_p->widgets_p);
    }

}

static int 
run_stdout(int n, void *data, void *user_data)
{
    FILE *out=NULL;
    run_data_t *run_data_p=(run_data_t *)user_data;
    widgets_t *widgets_p=run_data_p->widgets_p;
    char *line;

    if (!is_valid_widgets_p(widgets_p)){
	TRACE("stdout to invalid widget...");
	/*run_data_p->widgets_p=NULL;*/
	return FALSE;
    }
    if (!widgets_p) return FALSE;

    if (run_data_p->output && strcmp(run_data_p->output,"/dev/null")==0){
	TRACE("stdout... /dev/null");
	return TRUE;
    }
    
    if(n && !run_data_p->output) {
	TRACE("not processing binary output");
	return TRUE;		/* this would mean binary data */
    }

    if (run_data_p->output) {
	TRACE("opening %s",run_data_p->output);
	chdir(run_data_p->workdir);
	out=fopen(run_data_p->output,"a");
    }
    if (n) {
	if (out) {
	    TRACE("writing binary output");
	    fwrite(data,  n,  1,  out);
	    fclose(out);
	}
	return TRUE;
    }
    
    line = (char *)data;
    /*printf("."); fflush(NULL);*/
    /*printf("stdout:%s",line);*/
    if (out) {
	    TRACE("fputs(line,out)");
	fputs(line,out);	
	fclose(out);
    }
    else if (widgets_p) {
	int cachuk = 0;
	if (widgets_p->diagnostics_window) 
	    cachuk = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(widgets_p->diagnostics_window),"dismissed"));
	if (cachuk) return TRUE;
	//TRACE("1. show_text(widgets_p);");
	show_text(widgets_p);
	print_diagnostics(widgets_p,NULL, line, NULL);
    }
    return TRUE;
}

static int 
run_stderr(int n, void *data, void *user_data)
{
    run_data_t *run_data_p=(run_data_t *)user_data;
    widgets_t *widgets_p=run_data_p->widgets_p;
    /* here you might change the button icon... maybe...*/
    char *line;

    TRACE("run_stderr: widgets=0x%x",(unsigned)widgets_p);
    if (!is_valid_widgets_p(widgets_p)){
	/*run_data_p->widgets_p=NULL;*/
	return FALSE;
    }
    if (!widgets_p) return FALSE;
    
    if(n) return TRUE;		/* this would mean binary data */
    line = (char *)data;
    /*printf("stderr:%s",line);*/
    if (run_data_p->childFD > 0) {
      if (strncmp(line,"Password:",strlen("Password:"))==0){
	const char *p;
    	print_diagnostics(widgets_p, "xffm/warning",_("Sudo password requested"),"\n", NULL);
	p=xffm_get_password(widgets_p,_("Sudo password requested"));
	if (p && strlen(p)) write(run_data_p->childFD,p,strlen(p));
	write(run_data_p->childFD,"\n",strlen("\n"));
	return TRUE;
    }}
    
    if (line[0] != '\n') {
	int cachuk = 0;
	TRACE("run_stderr: print_diagnostics: widgets=0x%x",(unsigned)widgets_p);
	if (widgets_p->diagnostics_window) 
	    cachuk = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(widgets_p->diagnostics_window),"dismissed"));
	TRACE("2. show_text(widgets_p);");
	if (cachuk) return TRUE;
	show_text(widgets_p);
	print_diagnostics(widgets_p, "xffm/error", line, NULL);
    }
    return TRUE;
}



static
void * 
private_xffm_runvwd(	widgets_t *widgets_p,
			const gchar *wd,
			const gchar *argv[],
			gboolean use_pipes)
{
    static gboolean fork_begun=FALSE;
    void *return_val=NULL;
    gchar *p;
/* this function is called from find module with widgets_p=NULL*/

    if (!widgets_p) {
	g_warning("private_xffm_runvwd: !widgets_p");
	return NULL;
    }
    TRACE("+++++++++++++++++++++++++++++++++++++");
    TRACE("xffm_runvwd now, widgets_p=0x%x",(unsigned)widgets_p);
    /* this variable is only good for independent threads: */
#ifdef TRACE
    {
	const gchar **p;
	for (p=argv; *p; p++){
	    TRACE("arg[]=%s",*p);
	}
    }
#endif
    
    if (!argv || !argv[0]) {
	g_warning("!argv || !argv[0]");
	return NULL;
    }
    p=g_find_program_in_path(argv[0]);
    if (p) {
	g_free(p);
    }
#if 0
    /* trust user's good judgement */
    else {
        p=g_strdup_printf(_("%s is not a valid command"),argv[0]);
	xffm_confirm(widgets_p,p,NULL,NULL);
	g_free(p);
	return NULL;
    }
#endif
    
    if (!wd || !g_file_test(wd,G_FILE_TEST_IS_DIR)) {
	/*g_warning("xffm_runvwd(): wd==NULL");*/
	wd=g_get_home_dir();
    }
    

    xffm_setenv("PWD",(gchar *)wd,FALSE);
    chdir(wd);
    TRACE("TRACE: getenv(PWD)=%s\n",getenv("PWD"));
#ifdef DEBUG 
    {
    int i;
    print_diagnostics(widgets_p,NULL,"$chdir ",wd,"\n",NULL);
    print_diagnostics(widgets_p,NULL,"$",argv[0],NULL);
    for (i=1;argv[i];i++) {
	print_diagnostics(widgets_p,NULL," ",argv[i],NULL);
    }
    print_diagnostics(widgets_p,NULL,"\n",NULL);
    }
#endif

    if (strcmp(argv[0],"sudo")==0)
    {
	static gchar *sudo_prompt=NULL;
	gchar *f=g_strdup_printf("sudo %s",argv[1]);
	gchar *g=g_strdup_printf(_("Executing %s"),f);
	print_status(widgets_p,"xffm/info", g, NULL);
	g_free(g);
	g_free(f);
	if (sudo_prompt) g_free(sudo_prompt);
	sudo_prompt = g_strconcat("SUDO_PROMPT=","Password:","\n",NULL);
	putenv(sudo_prompt);	
	if (strcmp(argv[1],"-S")!=0){
	    gchar *s,*g;
	    /* we have at least two arguments and NULL. */
	    s=g_strconcat(argv[0]," ",argv[1]," ",argv[2],NULL);
	    g=g_strdup_printf(_("Finished: %s"),s);
	    g_free(s);
	    print_status(widgets_p,"xffm/error",g,NULL);
	    xffm_confirm (widgets_p,_("You can only specify a sudo command if you also specify the first argument as \"-S\""),NULL,NULL);
	    return NULL;
	}
    }
    else 
    {
	gchar *g;
	if (g_file_test(argv[0],G_FILE_TEST_EXISTS)) {
	    gchar *f;
	    f=g_path_get_basename(argv[0]);
	    g=g_strdup_printf(_("Executing %s"),f);
	    g_free(f);
	} else {
	    g=g_strdup_printf(_("Executing %s"),argv[0]);
	}
	print_status(widgets_p,"xffm/info", g, NULL);
	g_free(g);
    }
    
    if (use_pipes) {
	gchar *s;
	const gchar **p;
	static run_data_t *run_data_p;
	run_data_p=(run_data_t *)malloc(sizeof(run_data_t));
	memset(run_data_p,0,sizeof(run_data_t));
	run_data_p->output=NULL;
	run_data_p->widgets_p=widgets_p;
	run_data_p->workdir=g_strdup(wd);
	TRACE("run_data_p=0x%x",(unsigned)run_data_p);
	TRACE("assigning run_data_p->widgets_p=0x%x",
		(unsigned)run_data_p->widgets_p);

	/* we have at least one argument and NULL. */
	s=g_strconcat(argv[0]," ",argv[1],NULL);
	run_data_p->exec_string=g_strdup_printf(_("Finished: %s"),s);
	g_free(s);
	if (strcmp(argv[0],"sudo")!=0) 
	    run_data_p->childFD = -1;
	else run_data_p->childFD = 0;
	TRACE("widgets_p=0x%x",(unsigned)widgets_p);
	TRACE("3. show_text(widgets_p);");
	/*show_text(widgets_p);*/
	/*if (widgets_p){
	  if (!widgets_p->diagnostics) show_text(widgets_p);
	  else gtk_widget_realize(widgets_p->diagnostics);
	}*/
	print_diagnostics(widgets_p,"xffm/stock_yes","",NULL);
	for (p=argv; *p; p++){
	    TRACE("%s ",*p);
	    print_diagnostics(widgets_p,"VERBOSE",*p," ",NULL);
	    if (strcmp(*p,">")==0 || strcmp(*p,">>")==0){
		if (strcmp(*p,">")==0 && p[1] && strcmp(p[1],"/dev/null")!=0){
		    TRACE("unlinking %s",p[1]);
		    unlink(p[1]);
		}
		if (p[1]) {
		    /*printf("%s ",p[1]);*/
		    run_data_p->output=g_strdup(p[1]);
		    p[1]=NULL;
		}
		p[0]=NULL;
		break;
	    }
	} 
	print_diagnostics(widgets_p,"VERBOSE","\n",NULL);
	
	if (!fork_begun){
	    fork_begun=TRUE;
	    if (fork()) _exit(123);
	}

	while (gtk_events_pending()) gtk_main_iteration();
	/*printf("\n");*/
	if (widgets_p && widgets_p->button_space) {
	    int length=0;
	    TRACE("button_space != NULL: creating run_button!");
	    for (p=argv; *p; p++){
		length += (strlen(*p)+1);
	    }
	    run_data_p->command = (gchar *)malloc(length+2);
	    run_data_p->command[0] = 0;
	    for (p=argv; *p; p++){
		strcat(run_data_p->command, *p);
		strcat(run_data_p->command, " ");
	    }	    
	    run_data_p->button =
	    mk_little_button(widgets_p,"xffm/stock_run",(gpointer)show_run_info,(gpointer)run_data_p,run_data_p->command);
	    gtk_box_pack_end (GTK_BOX (widgets_p->button_space), run_data_p->button, FALSE, FALSE, 0);
	    g_signal_connect(G_OBJECT(run_data_p->button), "destroy_event", 
	    G_CALLBACK(destroy_run_button), run_data_p);
	    gtk_widget_show (run_data_p->button);
	} 
	
	if (run_data_p->childFD < 0){
	    TRACE("Tubo_full_blockread");
	    run_data_p->object=Tubo_full_blockread(fork_function, 
			(void *)argv, 
			run_finished_function, 
			NULL,
			run_stdout, 
			run_stderr,
			run_data_p,
			0);
	} else {
	    TRACE("Tubo_full");
	    run_data_p->object=Tubo_full(fork_function, 
			(void *)argv, 
			run_finished_function, 
			&(run_data_p->childFD),
			run_stdout, 
			run_stderr,
			run_data_p,
			0);
	}
	return_val=run_data_p->object;
    }

    else /* no pipes */   
    {
      GError *error=NULL;
      if (!g_spawn_async(widgets_p->workdir,(gchar **)argv,NULL,G_SPAWN_SEARCH_PATH,NULL,NULL,NULL,&error)){
	  gchar *msg = g_strcompress (error->message);
	  if (widgets_p) show_text(widgets_p);
	  print_diagnostics(widgets_p,"xffm/error",msg,":\n",argv[0] ,"\n",NULL);
	  g_error_free (error);
	  g_free (msg);
	  chdir (GETWD);
	  xffm_setenv("PWD",(gchar *)GETWD,FALSE);
	  return NULL;
    
      } else return_val=GINT_TO_POINTER(1);
	  
    }

    /*print_diagnostics(widgets_p,NULL,"$chdir ",GETWD,"\n",NULL);*/
    
    xffm_setenv("PWD",(gchar *)GETWD,FALSE);
    chdir(GETWD);
    return return_val;

}

/* use absolute path to call this function...*/
static
int 
private_xffm_on_run_path(	widgets_t *widgets_p,
			char *in_cmd, 
			const gchar *path, 
			gboolean interm, 
			gboolean remember, 
			gboolean put_in_history,
			gboolean use_pipes)
{
    GError *error=NULL;
    const gchar *command;
    gchar *name=NULL;
    int argc;
    gchar **argv;
    gchar *wd=NULL;
    if (!g_file_test(in_cmd,G_FILE_TEST_EXISTS) && !MIME_is_valid_command(in_cmd)){
	if (!g_file_test(in_cmd,G_FILE_TEST_EXISTS)){
	    gchar *p=g_strdup_printf(_("%s is not a valid command"),in_cmd);
	    xffm_confirm(widgets_p,p,NULL,NULL);
	    g_free(p);
	}
	else
	    print_diagnostics(widgets_p,"xffm/error",strerror(ENOEXEC),": ",in_cmd,"\n",NULL);
	return FALSE;
    }

    
    /* why did I ever use a relative path here? Reverting cause it breaks
     * doubleclick on .html files...
     * if (path) name=g_path_get_basename(path); else name=g_strdup("");
     *
     * The reason why is that applications like abiword break with absolute
     * paths if the paths contain spaces in them. So again I revert, testing
     * for doubleclick with .html files...
     *
     * if (path) {name=g_strdup(path);} else {name=g_strdup(""); }
     * */
    if (path && strlen(path)) {
	gchar *t;
	/* strip quotes from dirname */
	if (*path=='\"') wd=g_path_get_dirname(path+1);
	else wd=g_path_get_dirname(path);
	
	/* leave quotes on basename */
	if (*path=='\"') t=g_path_get_basename(path+1);
	else t=g_path_get_basename(path);
	if (strchr(t,'\"')) name=g_strdup_printf("\"%s",t);
	else name=g_strdup_printf("\"%s\"",t);
	g_free(t);	    
    } else name=g_strdup("");
    
    command = MIME_mk_command_line(in_cmd, name, interm, 0);
    TRACE("command=%s",command);
    if (!command){
    	g_free(name);   
	g_free (wd);
	g_warning("!command from %s",in_cmd);
	return FALSE;
    }

    
    TRACE("in_cmd=%s\n",command);
    g_shell_parse_argv (command, &argc,&argv,&error);
    if (error){
	gchar *msg = g_strcompress (error->message);
	TRACE(error->message);
	print_diagnostics(widgets_p,"xffm/error",msg,":\n",command,"\n",NULL);
	g_error_free(error);
	g_free (msg);
	g_free (wd);
	g_free(name); 
	return FALSE;
    }
    TRACE("going to xffm_runvwd %s %s",wd,argv[0]);
    /*if (wd) chdir(wd);*/
    if (private_xffm_runvwd(widgets_p,(wd?wd:widgets_p->workdir),(const gchar **)argv,use_pipes)){
	/* recent history: */
	if (path && strlen(path)){
	    if (!g_file_test(strip_quotes(path),G_FILE_TEST_EXISTS)) g_warning("%s does not exist",path);
	    else RECENT_add2history(widgets_p,(gchar *)strip_quotes(path));
	} 
        TRACE("save_to_open_history=%s->%s(%d)",strip_quotes(name),in_cmd,interm);
	save_to_open_history((gchar *)strip_quotes(name),in_cmd,interm);
    }
    g_free(wd); 
    g_strfreev (argv);
    
    TRACE("put_in_history=%d",put_in_history);
    
    if (put_in_history){
      gchar *f=g_build_filename(xdg_cache_dir(),RUN_DBH_FILE,NULL);
	TRACE("COMBO_save_to_history(%s,%s)",f,in_cmd);
      COMBO_save_to_history(f,in_cmd);
      xffm_save_flags(in_cmd,interm,0);
      g_free(f);
    }

    TRACE("path=%s,remember=%d)",path,remember);
    
    if(name && remember)
    {
#if 10
	/* multiple dots? */
	gchar *p=g_path_get_basename(name);
	gchar *foo=NULL;
	if (p && strchr(p,'.') && strchr(p,'.') != strrchr(p,'.') && strlen(strrchr(p,'.'))>1){
	    gchar *m=g_strdup_printf(_("Remember %s or %s?"),strchr(p,'.'),strrchr(p,'.'));
	    if (xffm_confirm (widgets_p,
				     (const gchar *)m,
				     (const gchar *)strchr(p,'.'),
				     (const gchar *)strrchr(p,'.'))){
		foo=g_strdup_printf("%s",strrchr(p,'.')+1);
	    } else {
		foo=g_strdup_printf("%s",strchr(p,'.')+1);
	    }	
	} else {
	    if (p && strchr(p,'.') && strlen(strrchr(p,'.'))>1) foo=g_strdup_printf("%s",strchr(p,'.')+1);
	    else foo=g_strdup(name);
	}
#endif
	if(strlen(name))
	{
	   command = MIME_mk_command_line(in_cmd, NULL, interm, 0);
	
	    TRACE("TRACE: adding %s --> %s\n",name,in_cmd); 
	    print_diagnostics(widgets_p,"xffm/info",foo,"-->",command,"\n",NULL);
	    MIME_add(foo,command);
	}
	g_free(p);
	g_free(foo);
    }
    g_free(name); 
    chdir(GETWD);
    return TRUE;
}


