/*
 * Copyright 2005 The Apache Software Foundation.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
/*
 * Copyright 2005 Sun Microsystems, Inc. All rights reserved.
 */
/*
 * $Id: ApacheTransform.java 375655 2006-02-07 18:35:54 +0000 (Tue, 07 Feb 2006) mullan $
 */
package org.jcp.xml.dsig.internal.dom;

import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.Transform;

import javax.xml.crypto.*;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.*;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;

/**
 * This is a wrapper/glue class which invokes the Apache XML-Security
 * Transform.
 *
 * @author Sean Mullan
 * @author Erwin van der Koogh
 */
public abstract class ApacheTransform extends TransformService {

    private static Logger log = Logger.getLogger("org.jcp.xml.dsig.internal.dom");
    private Transform apacheTransform;
    protected Document ownerDoc;
    protected Element transformElem;
    protected TransformParameterSpec params;
    
    public final AlgorithmParameterSpec getParameterSpec() {
	return params;
    }

    public void init(XMLStructure parent, XMLCryptoContext context)
	throws InvalidAlgorithmParameterException {
        if (context != null && !(context instanceof DOMCryptoContext)) {
            throw new ClassCastException
                ("context must be of type DOMCryptoContext");
        }
	transformElem = (Element) 
	    ((javax.xml.crypto.dom.DOMStructure) parent).getNode();
	ownerDoc = DOMUtils.getOwnerDocument(transformElem);
    }

    public void marshalParams(XMLStructure parent, XMLCryptoContext context)
	throws MarshalException {
        if (context != null && !(context instanceof DOMCryptoContext)) {
            throw new ClassCastException
                ("context must be of type DOMCryptoContext");
        }
	transformElem = (Element) 
	    ((javax.xml.crypto.dom.DOMStructure) parent).getNode();
	ownerDoc = DOMUtils.getOwnerDocument(transformElem);
    }

    public Data transform(Data data, XMLCryptoContext xc) 
	throws TransformException {
	if (data == null) {
	    throw new NullPointerException("data must not be null");
	}
	return transformIt(data, xc, (OutputStream) null);
    }

    public Data transform(Data data, XMLCryptoContext xc, OutputStream os) 
	throws TransformException {
	if (data == null) {
	    throw new NullPointerException("data must not be null");
	}
	if (os == null) {
	    throw new NullPointerException("output stream must not be null");
	}
	return transformIt(data, xc, os);
    }

    private Data transformIt(Data data, XMLCryptoContext xc, OutputStream os) 
	throws TransformException {

        if (ownerDoc == null) {
            throw new TransformException("transform must be marshalled");
        }

	if (apacheTransform == null) {
            try {
                apacheTransform = Transform.getInstance
		    (ownerDoc, getAlgorithm(), transformElem.getChildNodes());
		apacheTransform.setElement(transformElem, xc.getBaseURI());
		if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Created transform for algorithm: " 
		        + getAlgorithm());
		}
            } catch (Exception ex) {
                throw new TransformException
		    ("Couldn't find Transform for: " + getAlgorithm(), ex);
            } 
	}

        XMLSignatureInput in;
	if (data instanceof ApacheData) {
	    if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "ApacheData = true");
	    }
	    in = ((ApacheData) data).getXMLSignatureInput();
	} else if (data instanceof NodeSetData) {
	    if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "isNodeSet() = true");
	    }
	    if (data instanceof DOMSubTreeData) {
		if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "DOMSubTreeData = true");
                }
		DOMSubTreeData subTree = (DOMSubTreeData) data;
                in = new XMLSignatureInput(subTree.getRoot());
		in.setExcludeComments(subTree.excludeComments());
	    } else {
		Set nodeSet = 
		    Utils.toNodeSet(((NodeSetData) data).iterator());
                in = new XMLSignatureInput(nodeSet);
	    }
        } else {
	    if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "isNodeSet() = false");
	    }
            try {
                in = new XMLSignatureInput
		    (((OctetStreamData)data).getOctetStream());
            } catch (Exception ex) {
                throw new TransformException(ex);
            }
        }

	try {
	    if (os != null) {
	        in = apacheTransform.performTransform(in, os);
		if (!in.isNodeSet() && !in.isElement()) {
		    return null;
		}
	    } else {
	        in = apacheTransform.performTransform(in);
	    }
	    if (in.isOctetStream()) {
	        return new ApacheOctetStreamData(in);
	    } else {
	        return new ApacheNodeSetData(in);
	    }
	} catch (Exception ex) {
            throw new TransformException(ex);
        }
    }

    public final boolean isFeatureSupported(String feature) {
        if (feature == null) {
            throw new NullPointerException();
        } else {
            return false;
        }
    }
}
