require 'yaml'
require 'xtemplate/xml'

module XTemplate
  class YAMLDocument
    include XData

    attr_reader :to_hash

    def initialize(doc)
      @to_hash = YAML.load(doc)
    end
  end

  class XMLDocument
    def to_yaml
      @node.to_yaml
    end
  end

  class XNode
    def to_yaml
      node = deep_dup()
      node.strip!
      node.to_hash(Array,true).to_yaml()
    end
  end
end
