# -*- ruby -*-
#
# Using an internal stack.
#

require 'xtemplate'
require 'xtemplate/xml'

doc = XTemplate::XMLDocument.new(<<EOF)
<?xml version="1.0"?>
<members>
  <member><uid>1</uid><name>name1</name><email>name1@com</email></member>
  <member><uid>2</uid><name>name2</name><email>name2@com</email></member>
  <member><uid>3</uid><name>name3</name><email>name3@com</email></member>
  <member><uid>4</uid><name>name4</name><email>name4@com</email></member>
</members>
EOF

text = <<EOF
<?xml version="1.0" encoding="EUC-JP"?>
<members>
   <names>
     <name id="//name" />
   </names>
   <emails>
     <email id="//email{sort();reverse()}" /><!-- the 'email' node is not array -->
   </emails>
   <xtemplate xtemplate:id="//email{push(stack)}"
              xmlns:xtemplate="http://xtemplate.sourceforge.net/xtemplate" />
   <emails>
     <email id="/members{clear();pop_all(stack);text();sort();reverse()}" />
   </emails>
</members>
EOF

t = XTemplate::XMLTemplate.new(text)
print(t.expand(doc))
