# -*- ruby -*-
#
# Using an internal stack.
#

require 'xtemplate'
require 'xtemplate/xml'

doc = XTemplate::XMLDocument.new(<<EOF)
<?xml version="1.0"?>
<members>
  <member><uid opt="A">1</uid><name>name1</name><email>name1@com</email></member>
  <member><uid opt="B">2</uid><name>name2</name><email>name2@com</email></member>
  <member><uid>3</uid><name>name3</name><email>name3@com</email></member>
  <member><uid>4</uid><name>name4</name><email>name4@com</email></member>
</members>
EOF

include XTemplate::XPath
puts(value_inspect(doc['//uid[@opt="A"]']))
puts(value_inspect(doc['//uid[@opt]']))
p doc['//uid[@opt="A"]{text()}']
p doc['//uid[@opt="A"]/@opt']
p doc['//uid[@opt]{text()}']
puts "--"
puts doc['/members{dump()}']
puts "--"
puts doc['/members/member{dump()}']
