# -*- ruby -*-
#
# Using <xt:property>. See also sample10.rb.
#

require 'xtemplate'

class Link
  attr_reader :url, :name

  def initialize(url, name)
    @url = url
    @name = name
  end
end

data ={
  'links' => [
    {'link' => Link.new("url1", "anchor1")},
    {'link' => Link.new("url2", "anchor2")},
    {'link' => Link.new("url3", "anchor3")},
  ]
}

text = <<EOF
<?xml version="1.0" encoding="EUC-JP"?>
<html>
<body>
  <ul>
    <xt:select id="/links" xmlns:xt="http://xtemplate.sourceforge.net/xtemplate">
    <li><a><xt:select id="link.url{@href}" /><xt:select id="link.name" /></a></li>
    </xt:select>
  </ul>
</body>
</html>
EOF

t = XTemplate::XMLTemplate.new(text)
print(t.expand(data))
