# -*- ruby -*-
#
# Using <xt:property>. See also sample10.rb.
#

require 'xtemplate'

class Link
  attr_reader :url, :name

  def initialize(url, name)
    @url = url
    @name = name
  end
end

data ={
  'links' => [
    Link.new("url1", "anchor1"),
    Link.new("url2", "anchor2"),
    Link.new("url3", "anchor3"),
  ]
}

text = <<EOF
<?xml version="1.0" encoding="EUC-JP"?>
<html>
<body>
  <ul>
    <xt:select id="/links{link}" xmlns:xt="http://xtemplate.sourceforge.net/xtemplate">
    <li><a>
      <xt:attribute id="." name="href"><xt:property id="link" name="url" /></xt:attribute>
      <xt:property id="link" name="name" />
    </a></li>
    </xt:select>
  </ul>
</body>
</html>
EOF

t = XTemplate::XMLTemplate.new(text)
print(t.expand(data))
