#include <stdio.h>
#include <unistd.h>
void mergegaplists( int *l1, int *l2 )
{
	while( *l1 != -1 )
	{
		*l1++ += *l2++;
	}
	if( *l2 != -1 )
	{
		fprintf( stderr, "Check if the gaplists have the same length\n" );
	}
}

void gaplist2aln( char *a, char *s, int *l )
{
	int gaplen;
	while( *s )
	{
		gaplen = *l++;
		while( gaplen-- ) *a++ = '-';
		*a++ = *s++;
	}
	gaplen = *l++;
	while( gaplen-- ) *a++ = '-';
	*a = *s;
}

void makegaplist( int *l, char *a )
{
	while( 1 )
	{
//		fprintf( stderr, "a[] = %s\n", a );
		while( *a == '-' )
		{
			a++;
			(*l)++;
//			fprintf( stderr, "a[] (i) = %s, *l=%d\n", a, *(l) );
		}
		*++l = 0;
		if( *a == 0 ) break;
		a++;
	}
	*l = -1;
}

main()
{
	char seq1[] = "miyatatakashi";
	char seq2[] = "hasegawamasami";
	char aln1[1000];
	char aln2[1000];
	char aln2x[1000];
	int *gaplist1, *gaplist2;
	int *gaplist1x, *gaplist2x;
	int i;

	gaplist1 = (int *)calloc( 500, sizeof( int ) );
	gaplist2 = (int *)calloc( 500, sizeof( int ) );
	gaplist1x = (int *)calloc( 500, sizeof( int ) );
	gaplist2x = (int *)calloc( 500, sizeof( int ) );

	gaplist1[0] = 1;
	gaplist1[6] = 1;
	gaplist1[strlen(seq1)+1] = -1;
	gaplist2aln( aln1, seq1, gaplist1 );


	gaplist2[8] = 10;
	gaplist2[4] = 2;
	gaplist2[5] = 2;
	gaplist2[strlen(seq2)+1] = -1;
	gaplist2aln( aln2, seq2, gaplist2 );

	fprintf( stderr, "gaplist1 = \n" );
	for( i=0; gaplist1[i] != -1; i++ ) fprintf( stderr, "%d: %d\n", i, gaplist1[i] );

	fprintf( stderr, "gaplist2 = \n" );
	for( i=0; gaplist2[i] != -1; i++ ) fprintf( stderr, "%d: %d\n", i, gaplist2[i] );

	gaplist2x[0] = 10;
	gaplist2x[8] = 5;
	gaplist2x[strlen(seq2)-1] = 10;
	gaplist2x[strlen(seq2)] = 10;
	gaplist2x[strlen(seq2)+1] = -1;
	mergegaplists( gaplist2, gaplist2x );

	gaplist2aln( aln1, seq1, gaplist1 );
	gaplist2aln( aln2, seq2, gaplist2 );

	fprintf( stderr, "seq1 = %s\n", seq1 );
	fprintf( stderr, "aln1 = %s\n", aln1 );

	fprintf( stderr, "seq2 = %s\n", seq2 );
	fprintf( stderr, "aln2 = %s\n", aln2 );
}
