#!/usr/bin/env python
# -*- coding: utf-8 -*-
### BEGIN LICENSE
# This file is in the public domain
### END LICENSE

"""Build tar.gz and related for magicicada."""

################# DO NOT TOUCH THIS (HEAD TO THE SECOND PART) #################

import os
import sys

try:
    import DistUtilsExtra.auto
except ImportError:
    url = 'https://launchpad.net/python-distutils-extra'
    print >> sys.stderr, 'To build magicicada you need', url
    sys.exit(1)
assert DistUtilsExtra.auto.__version__ >= '2.18', \
       'needs DistUtilsExtra.auto >= 2.18'


def update_data_path(prefix, oldvalue=None):
    """Update data path."""

    try:
        fin = file('magicicada/magicicadaconfig.py', 'r')
        fout = file(fin.name + '.new', 'w')

        for line in fin:
            fields = line.split(' = ')  # Separate variable from value
            if fields[0] == '__magicicada_data_directory__':
                # update to prefix, store oldvalue
                if not oldvalue:
                    oldvalue = fields[1]
                    line = "%s = '%s'\n" % (fields[0], prefix)
                else:  # restore oldvalue
                    line = "%s = %s" % (fields[0], oldvalue)
            fout.write(line)

        fout.flush()
        fout.close()
        fin.close()
        os.rename(fout.name, fin.name)
    except (OSError, IOError):
        print ("ERROR: Can't find magicicada/magicicadaconfig.py")
        sys.exit(1)
    return oldvalue


def update_desktop_file(datadir):
    """Update desktop file."""

    try:
        fin = file('magicicada.desktop.in', 'r')
        fout = file(fin.name + '.new', 'w')

        for line in fin:
            if 'Icon=' in line:
                line = "Icon=%s\n" % (datadir + 'media/icon.png')
            fout.write(line)
        fout.flush()
        fout.close()
        fin.close()
        os.rename(fout.name, fin.name)
    except (OSError, IOError):
        print ("ERROR: Can't find magicicada.desktop.in")
        sys.exit(1)


class InstallAndUpdateDataDirectory(DistUtilsExtra.auto.install_auto):
    """Install and update data dir."""

    def run(self):
        """Run."""
        previous_value = update_data_path(self.prefix + '/share/magicicada/')
        update_desktop_file(self.prefix + '/share/magicicada/')
        DistUtilsExtra.auto.install_auto.run(self)
        update_data_path(self.prefix, previous_value)


##############################################################################
#################### YOU SHOULD MODIFY ONLY WHAT IS BELOW ####################
##############################################################################

DistUtilsExtra.auto.setup(
    name='magicicada',
    version='0.2',
    license='GPL-3',
    author='Natalia Bidart',
    author_email='natalia.bidart@ubuntu.com',
    description='A GTK+ frontend for the "Chicharra" part of Ubuntu One.',
    #long_description='Here a longer description',
    url='https://launchpad.net/magicicada',
    cmdclass={'install': InstallAndUpdateDataDirectory})
