/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file AxisLineAttributes.h
    \brief Definition of AxisLine Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Tue Nov 22 10:53:40 2011
*/
   

#ifndef AxisLineAttributes_H
#define AxisLineAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "Colour.h"

namespace magics {

class XmlNode;



class AxisLineAttributes 
{
public:
//  --  constructor
    AxisLineAttributes();
    
//  --  destructor
    virtual ~AxisLineAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const AxisLineAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Colour of axis line
    \param colour Setting axis_line_colour - default=automatic
*/
	void setColour(Colour* colour) 
		{ auto_ptr<Colour> tmp(colour); colour_ = tmp; } 
	const Colour&  getColour() const 
		{ return *colour_; }
/*!
    Magics Information:
    \brief Colour for frame and default for some axis settings
    \param default_colour Setting subpage_frame_colour - default=blue
*/
	void setDefault_colour(Colour* default_colour) 
		{ auto_ptr<Colour> tmp(default_colour); default_colour_ = tmp; } 
	const Colour&  getDefault_colour() const 
		{ return *default_colour_; }
/*!
    Magics Information:
    \brief Thickness of axis line 
    \param thickness Setting axis_line_thickness - default=2
*/
	void setThickness(int thickness) 
		{ thickness_ =  thickness; } 
	int getThickness() const 
		{ return thickness_; } 
        
/*!
    Magics Information:
    \brief  Line Style of axis line 
    \param style Setting axis_line_style - default=solid
*/
	void setStyle(LineStyle style) 
		{ style_ =  style; } 
	LineStyle getStyle() const 
		{ return style_; } 
        
/*!
    Magics Information:
    \brief  The position in which the axis is drawn when AXIS_POSITIONING is set to 'AUTOMATIC' (relative to the lower left corner of the subpage) 
    \param position Setting axis_line_position - default=0.0
*/
	void setPosition(double position) 
		{ position_ =  position; } 
	double getPosition() const 
		{ return position_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	auto_ptr<Colour> colour_;
	auto_ptr<Colour> default_colour_;
	int thickness_;
	LineStyle style_;
	double position_;

private:
  
	friend ostream& operator<<(ostream& s,const AxisLineAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
