/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLFontHandler.cc
    \brief Implementation of the OpenGLFontHandler class.
    \author Graphics Section, ECMWF

    Started: July 2008
*/
#include <OpenGLFontHandler.h>


OpenGLFontItem::OpenGLFontItem(const string &name,const float size,const Colour &col)
{	
	font_ = new OGLFT::TranslucentTexture(name.c_str(),100);               
  		
	if(font_== 0) return;	
		
	if(!font_->isValid() ) 	
	{
		delete font_;
	}
	else
	{
		font_->setCompileMode(OGLFT::Face::IMMEDIATE);
		font_->setForegroundColor(col.red(),col.green(),col.blue());		  		
		font_->setBackgroundColor( 1.0, 1.0, 1.0);               				
		font_->setPointSize(size);
		
		col_=col;
		size_=size;
		name_=name;			
	}	
}

OpenGLFontItem::~OpenGLFontItem()
{
	if(!font_) delete font_;
}	



OGLFT::TranslucentTexture* OpenGLFontHandler::getFont(const string& name,const float size,const Colour &col)
{
	
	for(list<OpenGLFontItem*>::iterator it=fonts_.begin(); it != fonts_.end(); it++)
	{
		if( (*it)->equal(name,size,col) == true)
		{
			return (*it)->font();
		}
	}
	
	return 0;
		
}


OGLFT::TranslucentTexture* OpenGLFontHandler::addFont(const string& name,const float size,const Colour &col)
{
	OGLFT::TranslucentTexture *f = getFont(name,size,col);
	
	if(f) 
	{
		return f;
	}
	else
	{	
		OpenGLFontItem* ft=new OpenGLFontItem(name,size,col);
	
		if(ft->font())
		{
			fonts_.push_back(ft);
			return ft->font();
		}
		else
		{
			delete ft;
			return 0;
		}
	}	
}	
	
void OpenGLFontHandler::deleteFont(const string& name,const float size,const Colour &col)	
{	
	for(list<OpenGLFontItem*>::iterator it=fonts_.begin(); it != fonts_.end(); it++)
	{	
		if( (*it)->equal(name,size,col) == true)
		{
			delete *it;
			fonts_.erase(it);
			return;
		}	
	}
}	


void OpenGLFontHandler::clear()	
{	
	for(list<OpenGLFontItem*>::iterator it=fonts_.begin(); it != fonts_.end(); it++)
	{	
		delete *it;
	}
	fonts_.clear();		
}	


void OpenGLFontHandler::print(ostream &out)
{
	out << "OGLFT fonts in use: " << endl;
 	for(list<OpenGLFontItem*>::iterator it=fonts_.begin(); it != fonts_.end(); it++)
	{	
	 	(*it)->print(out);
	}	
} 
