%module Magnus

%{
#include "OneRelatorGroupWithTorsion.h"
%}

class  OneRelatorGroupWithTorsion : public OneRelatorGroup

{
public:

  /////////////////////////////////////////////////////////////////////////
  //                                                                     //
  //  Constructors:                                                      //
  //                                                                     //
  /////////////////////////////////////////////////////////////////////////

  OneRelatorGroupWithTorsion( int ngens, const Word& relator );
  // To construct a group of given number of unnamed generators and
  // a given relator.
  
  %name(OneRelatorGroupWithTorsionFromVector) OneRelatorGroupWithTorsion( const VectorOf<Chars>& gennames, 
			      const Word& relator );
  // To construct a group with named generators, a given relator.  

  %name(OneRelatorGroupWithTorsionFromFPGroup)  OneRelatorGroupWithTorsion( const FPGroup& G );
  
  // Copy constructor, operator=, and destructor supplied by compiler.

  /////////////////////////////////////////////////////////////////////////
  //                                                                     //
  //  Accessors:                                                         //
  //                                                                     //
  /////////////////////////////////////////////////////////////////////////

  /////////////////////////////////////////////////////////////////////////
  //                                                                     //
  //  Methods and operators which deal with the group:                   //
  //                                                                     //
  /////////////////////////////////////////////////////////////////////////
  
  /////////////////////////////////////////////////////////////////////////
  //                                                                     //
  //  Methods and operators which deal with subgroups:                   //
  //                                                                     //
  /////////////////////////////////////////////////////////////////////////

  bool isProperMagnusSubgroup( const VectorOf<Generator>& subgroup ) const;
  // Returns true iff a subgroup generated by `gens' is a Magnus one.

  bool doesMagnusSubgroupContainElt( const VectorOf<Generator>& subgroup, 
    const Word& w, Word& wInSubgroupBasis ) const;
  // Determines whether the word is in the given Magnus subgroup
  // If it is true then it expresses the word in the generators of 
  // the subgroup.

  bool isPowerOfEltInMagnusSubgroup( const VectorOf<Generator>& subgroup, 
    const Word& w, Word& subgroupElt, int& powerOfElt ) const;
  // Determines whether the given word `w' is a power of an element of
  // the given Magnus subgroup.

  /////////////////////////////////////////////////////////////////////////
  //                                                                     //
  //  Methods which deal with group elements:                            //
  //                                                                     //
  /////////////////////////////////////////////////////////////////////////

  // Trichotomy wordProblem( const Word& w ) const;
  // Overrides pseudo-virtual OneRelatorGroup::wordProblem().

  Trichotomy wordProblem( const Word& w, 
    ProductOfRelatorConjugates& productOfRelatorConjugates ) const ;
  // Solves word problem for the given word.
  // If the word is identity then it expressed as a product of 
  // relator conjugates.

  // @dp will be implemented soon. 
  // Trichotomy conjugacyProblem( const Word& u, const Word& w ) const;
  // Overrides pseudo-virtual OnerelatorGroupRep::conjugacyProblem().

  Trichotomy conjugacyProblem( const Word& u, const Word& v, Word& conjugator)
    const;
  // Solves the conjugacy problem. If the words are conjugated then it returns 
  // the conjugator of first word to get the second one.


  Trichotomy maximalRoot( const Word& w, Word& maxRoot, int& maxPower ) const ;
  // Finds maximal root of given word w. The root word is stored in `maxRoot',
  // and its power in `maxPower'. If the function returns value `donknow'
  // the answer is cannot be determined.


  int powerOfElt(const Word& w, Word& st, Word& x, 
		 ProductOfRelatorConjugates& productOfRelatorConjugates ) const;
  // Return finite order or 0 iff the element of infinite order.
  // If the one is of finite order then decomposition of w is
  //    w = (s^t)^x * R1^c1 * ... * Rm^cm
  // where G = < X | r = s^k = 1 > is the given group, 
  //       Ri is r or r^-1, st = s^t.
  

  VectorOf<Word> centralizerOfElt( const Word& w ) const ;
  // Computes a centralizer of the given element. Returns subgroup generated by
  // a single element (maximal root of w) always. 
  // This fact is proved by B.B.Newman.

///Inherited From OneRelatorGroup

/*
  /////////////////////////////////////////////////////////////////////////
  //                                                                     //
  // I/O:                                                                //
  //                                                                     //
  /////////////////////////////////////////////////////////////////////////

  /////////////////////////////////////////////////////////////////////////
  //                                                                     //
  // IPC tools:                                                          //
  //                                                                     //
  /////////////////////////////////////////////////////////////////////////

protected:

  /////////////////////////////////////////////////////////////////////////
  //                                                                     //
  // Protected functions:                                                //
  //                                                                     //
  /////////////////////////////////////////////////////////////////////////

  OneRelatorGroupWithTorsion( OneRelatorGroupWithTorsionRep *newrep ) 
    : DerivedObjectOf<OneRelatorGroup, OneRelatorGroupWithTorsionRep>(newrep){}
*/
};


%inline %{
	OneRelatorGroupWithTorsion * OneRelatorGroupWithTorsionFromString(char* p) {
		strstream s;
                FPGroup* fg=new FPGroup();
		OneRelatorGroupWithTorsion* F=new OneRelatorGroupWithTorsion(*fg);
		s << p << '\0' << flush;
		Chars msg=s >> *F;
		if (msg.length()>0) {
			PyErr_SetString(PyExc_Exception,msg);
			PyErr_Print();
			return NULL;
		}
		return F;
	}
%}