"""
gnome module contains the definition of the test suites used for gnome
applications
"""
import ldtp, ooldtp
from .main import SingleApplicationTestSuite
from ..application.gnome import Application
from ..application.evolution import Evolution 

class EvolutionTestSuite(SingleApplicationTestSuite):
    """
    Default test suite for Evolution 
    """
    APPLICATION_FACTORY = Evolution 
    def __init__(self, **kwargs):
        self.app_args = kwargs
        SingleApplicationTestSuite.__init__(self)

    def setup(self):
        self.application.open(**self.app_args)

    def teardown(self):
        self.application.close()

    def cleanup(self):
        self.application.close()
        self.application.open(**self.app_args)

