<?php
/**
 * Mahara: Electronic portfolio, weblog, resume builder and social networking
 * Copyright (C) 2006-2008 Catalyst IT Ltd (http://www.catalyst.net.nz)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package    mahara
 * @subpackage core
 * @author     Catalyst IT Ltd
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL
 * @copyright  (C) 2006-2008 Catalyst IT Ltd http://catalyst.net.nz
 *
 */

//
// CONFIGURATION DEFAULTS
//
// Do Not Edit This File!
//
// If you see a setting in here you'd like to change, copy it to your 
// config.php and change it there.
//
// This file sets defaults that are useful for most people.
//

$cfg = new StdClass;

// directorypermissions - what permissions to use for files and directories in 
// dataroot. The default allows only the web server user to read the data. If 
// you're on shared hosting and might want to download the contents of your 
// dataroot later (e.g. for backup purposes), set this to 0777. Otherwise, 
// leave it as is!
//$cfg->directorypermissions = 0700;

// insecuredataroot - whether to enforce checking that files being served have 
// come from dataroot. You would only want to turn this on if you were running 
// more than one Mahara against the same dataroot. If you are doing that, make 
// sure you create separate dataroots for each installation, but symlink the 
// artefact directory from all of them to one of them, and turn on 
// 'insecuredataroot' on all the ones you created symlinks for.
//
// If you don't know what you're doing/didn't understand the paragraph above, 
// then leave this setting alone!
//$cfg->insecuredataroot = false;

// system mail address. emails out come from this address.
// if not specified, will default to noreply@ automatically detected host.
// if that doesn't work or you want something else, then specify it here.
// $cfg->noreplyaddress = 'noreply@myhost.com'

// Logging configuration
// For each log level, you can specify where the messages are displayed.
// LOG_TARGET_SCREEN makes the error messages go to the screen - useful
// when debugging but not on a live site!
// LOG_TARGET_ERRORLOG makes the error messages go to the log as specified
// by the apache ErrorLog directive. It's probably useful to have this on
// for all log levels.
// You can combine them with bitwise operations,
// e.g. LOG_TARGET_SCREEN | LOG_TARGET_ERRORLOG
//
// This configuration is suitable for people running Mahara for the first
// time. You will immediately see environment errors, and so can correct
// them. You will be able to see other debugging information in your error
// logs. Once your site is up and running you might want to remove the
// environment level logging completely, and just log everything else to
// the error log.
$cfg->log_dbg_targets     = LOG_TARGET_ERRORLOG;
$cfg->log_info_targets    = LOG_TARGET_ERRORLOG;
$cfg->log_warn_targets    = LOG_TARGET_ERRORLOG;
$cfg->log_environ_targets = LOG_TARGET_SCREEN | LOG_TARGET_ERRORLOG;
// This configuration is suitable for developers. You will see all errors
// and they will also be in the logs.
//$cfg->log_dbg_targets     = LOG_TARGET_SCREEN | LOG_TARGET_ERRORLOG;
//$cfg->log_info_targets    = LOG_TARGET_SCREEN | LOG_TARGET_ERRORLOG;
//$cfg->log_warn_targets    = LOG_TARGET_SCREEN | LOG_TARGET_ERRORLOG;
//$cfg->log_environ_targets = LOG_TARGET_SCREEN | LOG_TARGET_ERRORLOG;

// The log levels that will generate backtraces. Useful for development,
// but probably only warnings are useful on a live site.
$cfg->log_backtrace_levels = LOG_LEVEL_WARN | LOG_LEVEL_ENVIRON;

// Developer mode
// When set, the following things (among others) will happen:
//
// * 'debug.js' will be included on each page. You can edit this file to add 
//   debugging javascript at your discretion
// * 'debug.css' will be included on each page. You can edit this file to add 
//   debugging CSS at your discretion
// * firebuglite will be included, if you are not using Firefox
// * the unpacked version of MochiKit will be used
//
// These options are a performance hit otherwise, enable when you are 
// developing for Mahara
$cfg->developermode = false;

// Whether to send e-mail. If set to false, Mahara will not send any e-mail at 
// all. This is useful for when setting up development versions of Mahara where 
// you don't want to accidentally send email to users from this particular 
// Mahara installation.
//
// You can use sendallemailto to have all e-mails from this instance of Mahara 
// sent to one particular address instead of where they're aimed for. Leave 
// sendemail = true if you want to use this setting.
$cfg->sendemail = true;
// $cfg->sendallemailto = 'you@example.com';

// capture performance information and print it
// $cfg->perftofoot = true; // needs a call to mahara_performance_info (smarty callback) - see default theme's footer.tpl
// $cfg->perftolog = true;
// if neither are set, performance info wont be captured.

// mail handling
// if you want mahara to use smtp servers to send mail, enter one or more here
// blank means mahara will use the default PHP method.
// $cfg->smtphosts = 'mail.a.com;mail.b.com';
// If you have specified an smtp server above, and the server requires authentication, 
// enter them here
// $cfg->smtpuser = '';
// $cfg->smtppass = '';

// maximum allowed size of uploaded images
// NOTE: the scalable resize might result in images with one dimesion larger than one of these sizes, but not both
$cfg->imagemaxwidth = 1024;
$cfg->imagemaxheight = 1024;

// paths and arguments for various system commands
$cfg->pathtounzip = '/usr/bin/unzip';
$cfg->unzipdirarg = '-d';
// some shared hosts have restrictions on where unzip can be used
// dataroot is often not allowed; but /tmp is
// Note that if there is more than one mahara on this host using this setting
// you must change this to something unique, eg /tmp/mahara1/ and /tmp/mahara2/
// $cfg->unziptempdir = '/tmp/mahara/';

// How often Mahara should update the last access time for users. Setting this 
// lower means the field will be updated more regularly, but means a database 
// write will be required for more requests.
// Setting it to zero means the access time will be updated every request
$cfg->accesstimeupdatefrequency = 300;

// How long since their last request before a user is considered to be logged 
// out. Note that it makes no sense for this to be less than the 
// accesstimeupdatefrequency.
$cfg->accessidletimeout = 600;

// Whether to show the onlineusers sideblock
$cfg->showonlineuserssideblock = true;

?>
