/* Generated by GOB (v2.0.12) on Tue Aug  9 22:01:56 2005
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 12

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-pi-mailbox.h"

#include "mn-pi-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 29 "mn-pi-mailbox.gob"

#include "config.h"
#include <glib/gi18n.h>
#include "mn-mailbox-private.h"
#include "mn-util.h"
#include "mn-stock.h"

#line 35 "mn-pi-mailbox.c"
static const GEnumValue _mn_pi_mailbox_connection_type_values[] = {
	{ MN_PI_MAILBOX_CONNECTION_TYPE_NORMAL, (char *)"MN_PI_MAILBOX_CONNECTION_TYPE_NORMAL", (char *)"normal" },
	{ MN_PI_MAILBOX_CONNECTION_TYPE_INBAND_SSL, (char *)"MN_PI_MAILBOX_CONNECTION_TYPE_INBAND_SSL", (char *)"inband-ssl" },
	{ MN_PI_MAILBOX_CONNECTION_TYPE_SSL, (char *)"MN_PI_MAILBOX_CONNECTION_TYPE_SSL", (char *)"ssl" },
	{ 0, NULL, NULL }
};

GType
mn_pi_mailbox_connection_type_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("MNPIMailboxConnectionType", _mn_pi_mailbox_connection_type_values);
	return type;
}

/* self casting macros */
#define SELF(x) MN_PI_MAILBOX(x)
#define SELF_CONST(x) MN_PI_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_PI_MAILBOX(x)
#define TYPE_SELF MN_TYPE_PI_MAILBOX
#define SELF_CLASS(x) MN_PI_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_PI_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNPIMailbox Self;
typedef MNPIMailboxClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void mn_pi_mailbox_init (MNPIMailbox * o) G_GNUC_UNUSED;
static void mn_pi_mailbox_class_init (MNPIMailboxClass * c) G_GNUC_UNUSED;
static GObject * ___1_mn_pi_mailbox_constructor (GType type, unsigned int n_construct_properties, GObjectConstructParam * construct_params) G_GNUC_UNUSED;
static void ___2_mn_pi_mailbox_seal (MNMailbox * mailbox) G_GNUC_UNUSED;
static void ___3_mn_pi_mailbox_impl_check (MNAuthenticatedMailbox * mailbox) G_GNUC_UNUSED;

enum {
	PROP_0,
	PROP_CONNECTION_TYPE,
	PROP_AUTHMECH,
	PROP_HOSTNAME,
	PROP_PORT
};

/* pointer to the class of our parent */
static MNAuthenticatedMailboxClass *parent_class = NULL;

/* Short form macros */
#define self_split_uri mn_pi_mailbox_split_uri
#define self_split_uri_auth mn_pi_mailbox_split_uri_auth
#define self_split_uri_hostport mn_pi_mailbox_split_uri_hostport
GType
mn_pi_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNPIMailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_pi_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNPIMailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_pi_mailbox_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_AUTHENTICATED_MAILBOX, "MNPIMailbox", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNPIMailbox *)g_object_new(mn_pi_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNPIMailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNPIMailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNPIMailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNPIMailbox *)g_object_new_valist (mn_pi_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::finalize"
	MNPIMailbox *self G_GNUC_UNUSED = MN_PI_MAILBOX (obj_self);
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 54 "mn-pi-mailbox.gob"
	if(self->authmech) { g_free ((gpointer) self->authmech); self->authmech = NULL; }
#line 141 "mn-pi-mailbox.c"
#line 57 "mn-pi-mailbox.gob"
	if(self->hostname) { g_free ((gpointer) self->hostname); self->hostname = NULL; }
#line 144 "mn-pi-mailbox.c"
}
#undef __GOB_FUNCTION__

static void 
mn_pi_mailbox_init (MNPIMailbox * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::init"
}
#undef __GOB_FUNCTION__
static void 
mn_pi_mailbox_class_init (MNPIMailboxClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;
	MNMailboxClass *mn_mailbox_class = (MNMailboxClass *)c;
	MNAuthenticatedMailboxClass *mn_authenticated_mailbox_class = (MNAuthenticatedMailboxClass *)c;

	parent_class = g_type_class_ref (MN_TYPE_AUTHENTICATED_MAILBOX);

#line 68 "mn-pi-mailbox.gob"
	g_object_class->constructor = ___1_mn_pi_mailbox_constructor;
#line 82 "mn-pi-mailbox.gob"
	mn_mailbox_class->seal = ___2_mn_pi_mailbox_seal;
#line 98 "mn-pi-mailbox.gob"
	mn_authenticated_mailbox_class->impl_check = ___3_mn_pi_mailbox_impl_check;
#line 170 "mn-pi-mailbox.c"
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_enum
		("connection_type" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 MN_TYPE_PI_MAILBOX_CONNECTION_TYPE /* enum_type */,
		 MN_PI_MAILBOX_CONNECTION_TYPE_NORMAL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_PERMANENT | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_CONNECTION_TYPE,
		param_spec);
	param_spec = g_param_spec_string
		("authmech" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_PERMANENT));
	g_object_class_install_property (g_object_class,
		PROP_AUTHMECH,
		param_spec);
	param_spec = g_param_spec_string
		("hostname" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_REQUIRED | MN_MAILBOX_PARAM_PERMANENT));
	g_object_class_install_property (g_object_class,
		PROP_HOSTNAME,
		param_spec);
	param_spec = g_param_spec_int
		("port" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 0 /* minimum */,
		 65535 /* maximum */,
		 0 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_PERMANENT));
	g_object_class_install_property (g_object_class,
		PROP_PORT,
		param_spec);
    }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:PI:Mailbox::set_property"
{
	MNPIMailbox *self G_GNUC_UNUSED;

	self = MN_PI_MAILBOX (object);

	switch (property_id) {
	case PROP_CONNECTION_TYPE:
		{
#line 49 "mn-pi-mailbox.gob"
self->connection_type = g_value_get_enum (VAL);
#line 236 "mn-pi-mailbox.c"
		}
		break;
	case PROP_AUTHMECH:
		{
#line 55 "mn-pi-mailbox.gob"
{ char *old = self->authmech; self->authmech = g_value_dup_string (VAL); g_free (old); }
#line 243 "mn-pi-mailbox.c"
		}
		break;
	case PROP_HOSTNAME:
		{
#line 58 "mn-pi-mailbox.gob"
{ char *old = self->hostname; self->hostname = g_value_dup_string (VAL); g_free (old); }
#line 250 "mn-pi-mailbox.c"
		}
		break;
	case PROP_PORT:
		{
#line 61 "mn-pi-mailbox.gob"
self->port = g_value_get_int (VAL);
#line 257 "mn-pi-mailbox.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:PI:Mailbox::get_property"
{
	MNPIMailbox *self G_GNUC_UNUSED;

	self = MN_PI_MAILBOX (object);

	switch (property_id) {
	case PROP_CONNECTION_TYPE:
		{
#line 49 "mn-pi-mailbox.gob"
g_value_set_enum (VAL, self->connection_type);
#line 288 "mn-pi-mailbox.c"
		}
		break;
	case PROP_AUTHMECH:
		{
#line 55 "mn-pi-mailbox.gob"
g_value_set_string (VAL, self->authmech);
#line 295 "mn-pi-mailbox.c"
		}
		break;
	case PROP_HOSTNAME:
		{
#line 58 "mn-pi-mailbox.gob"
g_value_set_string (VAL, self->hostname);
#line 302 "mn-pi-mailbox.c"
		}
		break;
	case PROP_PORT:
		{
#line 61 "mn-pi-mailbox.gob"
g_value_set_int (VAL, self->port);
#line 309 "mn-pi-mailbox.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 68 "mn-pi-mailbox.gob"
static GObject * 
___1_mn_pi_mailbox_constructor (GType type G_GNUC_UNUSED, unsigned int n_construct_properties, GObjectConstructParam * construct_params)
#line 329 "mn-pi-mailbox.c"
#define PARENT_HANDLER(___type,___n_construct_properties,___construct_params) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_construct_properties,___construct_params): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::constructor"
{
#line 70 "mn-pi-mailbox.gob"
	
    GObject *object;
    MNMailbox *mailbox;

    object = PARENT_HANDLER(type, n_construct_properties, construct_params);
    mailbox = MN_MAILBOX(object);
    
    mn_mailbox_set_stock_id(mailbox, MN_STOCK_REMOTE);

    return object;
  }}
#line 349 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 82 "mn-pi-mailbox.gob"
static void 
___2_mn_pi_mailbox_seal (MNMailbox * mailbox G_GNUC_UNUSED)
#line 356 "mn-pi-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_MAILBOX_CLASS(parent_class)->seal) \
		(* MN_MAILBOX_CLASS(parent_class)->seal)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::seal"
{
#line 84 "mn-pi-mailbox.gob"
	
    Self *self = SELF(mailbox);

    PARENT_HANDLER(mailbox);

    /* do not save default port to mailboxes.xml */
    if (self->port == SELF_GET_CLASS(self)->default_ports[self->connection_type])
      self->port = 0;
    
    self->runtime_port = self->port == 0
      ? SELF_GET_CLASS(self)->default_ports[self->connection_type]
      : self->port;
  }}
#line 377 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 98 "mn-pi-mailbox.gob"
static void 
___3_mn_pi_mailbox_impl_check (MNAuthenticatedMailbox * mailbox G_GNUC_UNUSED)
#line 384 "mn-pi-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_AUTHENTICATED_MAILBOX_CLASS(parent_class)->impl_check) \
		(* MN_AUTHENTICATED_MAILBOX_CLASS(parent_class)->impl_check)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::impl_check"
{
#line 100 "mn-pi-mailbox.gob"
	
#ifndef WITH_SSL
    Self *self = SELF(mailbox);
#endif

    PARENT_HANDLER(mailbox);

#ifndef WITH_SSL
    if (self->connection_type == MN_PI_MAILBOX_CONNECTION_TYPE_INBAND_SSL
	|| self->connection_type == MN_PI_MAILBOX_CONNECTION_TYPE_SSL)
      {
	GDK_THREADS_ENTER();

	mn_mailbox_set_error(MN_MAILBOX(mailbox), _("SSL/TLS support has not been compiled in"));
	mn_mailbox_set_must_poll(MN_MAILBOX(mailbox), FALSE); /* disable the mailbox */

	gdk_flush();
	GDK_THREADS_LEAVE();
      }
#endif
  }}
#line 413 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 122 "mn-pi-mailbox.gob"
gboolean 
mn_pi_mailbox_split_uri (const char * uri, int maxlen, char * scheme, char * auth, char * location, gboolean * has_auth)
#line 420 "mn-pi-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::split_uri"
#line 122 "mn-pi-mailbox.gob"
	g_return_val_if_fail (uri != NULL, (gboolean )0);
#line 122 "mn-pi-mailbox.gob"
	g_return_val_if_fail (scheme != NULL, (gboolean )0);
#line 122 "mn-pi-mailbox.gob"
	g_return_val_if_fail (auth != NULL, (gboolean )0);
#line 122 "mn-pi-mailbox.gob"
	g_return_val_if_fail (location != NULL, (gboolean )0);
#line 122 "mn-pi-mailbox.gob"
	g_return_val_if_fail (has_auth != NULL, (gboolean )0);
#line 433 "mn-pi-mailbox.c"
{
#line 129 "mn-pi-mailbox.gob"
	
    char *pat;
    int n;

    pat = g_strdup_printf("%%%i[^:]://%%%i[^@]@%%%is", maxlen, maxlen, maxlen);
    n = sscanf(uri, pat, scheme, auth, location);
    g_free(pat);

    if (n >= 2)
      {
	*has_auth = n == 3;
	
	if (! *has_auth)
	  strcpy(location, auth);

	return TRUE;
      }
    else
      return FALSE;
  }}
#line 456 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__

#line 150 "mn-pi-mailbox.gob"
gboolean 
mn_pi_mailbox_split_uri_auth (const char * auth, int maxlen, char * username, char * authmech, gboolean * has_username, gboolean * has_authmech)
#line 462 "mn-pi-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::split_uri_auth"
#line 150 "mn-pi-mailbox.gob"
	g_return_val_if_fail (auth != NULL, (gboolean )0);
#line 150 "mn-pi-mailbox.gob"
	g_return_val_if_fail (username != NULL, (gboolean )0);
#line 150 "mn-pi-mailbox.gob"
	g_return_val_if_fail (authmech != NULL, (gboolean )0);
#line 150 "mn-pi-mailbox.gob"
	g_return_val_if_fail (has_username != NULL, (gboolean )0);
#line 150 "mn-pi-mailbox.gob"
	g_return_val_if_fail (has_authmech != NULL, (gboolean )0);
#line 475 "mn-pi-mailbox.c"
{
#line 157 "mn-pi-mailbox.gob"
	
    char *pat;
    int n;

    pat = g_strdup_printf("%%%i[^;];AUTH=%%%is", maxlen, maxlen);
    n = sscanf(auth, pat, username, authmech);
    g_free(pat);

    *has_username = FALSE;
    *has_authmech = FALSE;

    if (n >= 1)
      {
	*has_username = TRUE;

	if (n == 2)
	  *has_authmech = TRUE;
      }
    else
      {
	pat = g_strdup_printf(";AUTH=%%%is", maxlen);
	n = sscanf(auth, pat, authmech);
	g_free(pat);
	
	if (n < 1)
	  return FALSE;

	*has_authmech = TRUE;
      }

    return TRUE;
  }}
#line 510 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__

#line 190 "mn-pi-mailbox.gob"
void 
mn_pi_mailbox_split_uri_hostport (const char * hostport, int maxlen, char * hostname, int * port)
#line 516 "mn-pi-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::split_uri_hostport"
#line 190 "mn-pi-mailbox.gob"
	g_return_if_fail (hostport != NULL);
#line 190 "mn-pi-mailbox.gob"
	g_return_if_fail (hostname != NULL);
#line 190 "mn-pi-mailbox.gob"
	g_return_if_fail (port != NULL);
#line 525 "mn-pi-mailbox.c"
{
#line 195 "mn-pi-mailbox.gob"
	
    char *pat;
    int n;

    /* split host:port part in 2 subparts: host and port */

    pat = g_strdup_printf("[%%%i[^]]]:%%u", maxlen);
    n = sscanf(hostport, pat, hostname, port);
    g_free(pat);

    if (n < 1)
      {
	pat = g_strdup_printf("%%%i[^:]:%%u", maxlen);
	n = sscanf(hostport, pat, hostname, port);
	g_free(pat);
      }

    g_assert(n >= 1);

    if (n < 2)
      *port = 0;
  }}
#line 550 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__
