/* Generated by GOB (v2.0.12) on Tue Aug  9 22:01:55 2005
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 12

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-maildir-mailbox-backend.h"

#include "mn-maildir-mailbox-backend-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 25 "mn-maildir-mailbox-backend.gob"

#include "config.h"
#include <glib/gi18n.h>
#include <eel/eel.h>
#include "mn-mailbox-private.h"
#include "mn-reentrant-mailbox-private.h"
#include "mn-vfs-mailbox-backend-private.h"
#include "mn-vfs.h"
#include "mn-util.h"
#include "mn-message-mime.h"

#line 39 "mn-maildir-mailbox-backend.c"
/* self casting macros */
#define SELF(x) MN_MAILDIR_MAILBOX_BACKEND(x)
#define SELF_CONST(x) MN_MAILDIR_MAILBOX_BACKEND_CONST(x)
#define IS_SELF(x) MN_IS_MAILDIR_MAILBOX_BACKEND(x)
#define TYPE_SELF MN_TYPE_MAILDIR_MAILBOX_BACKEND
#define SELF_CLASS(x) MN_MAILDIR_MAILBOX_BACKEND_CLASS(x)

#define SELF_GET_CLASS(x) MN_MAILDIR_MAILBOX_BACKEND_GET_CLASS(x)

/* self typedefs */
typedef MNMaildirMailboxBackend Self;
typedef MNMaildirMailboxBackendClass SelfClass;

/* here are local prototypes */
static void mn_maildir_mailbox_backend_init (MNMaildirMailboxBackend * o) G_GNUC_UNUSED;
static void mn_maildir_mailbox_backend_class_init (MNMaildirMailboxBackendClass * class) G_GNUC_UNUSED;
static void ___2_mn_maildir_mailbox_backend_monitor_cb (MNVFSMailboxBackend * backend, const char * info_uri, GnomeVFSMonitorEventType event_type) G_GNUC_UNUSED;
static gboolean ___3_mn_maildir_mailbox_backend_is (MNVFSMailboxBackend * dummy, MNVFSMailbox * mailbox) G_GNUC_UNUSED;
static void ___4_mn_maildir_mailbox_backend_check (MNVFSMailboxBackend * backend, unsigned long check_id) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static MNVFSMailboxBackendClass *parent_class = NULL;

GType
mn_maildir_mailbox_backend_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNMaildirMailboxBackendClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_maildir_mailbox_backend_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNMaildirMailboxBackend),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_maildir_mailbox_backend_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_VFS_MAILBOX_BACKEND, "MNMaildirMailboxBackend", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNMaildirMailboxBackend *)g_object_new(mn_maildir_mailbox_backend_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNMaildirMailboxBackend * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNMaildirMailboxBackend *
GET_NEW_VARG (const char *first, ...)
{
	MNMaildirMailboxBackend *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNMaildirMailboxBackend *)g_object_new_valist (mn_maildir_mailbox_backend_get_type (), first, ap);
	va_end (ap);
	return ret;
}

static void 
mn_maildir_mailbox_backend_init (MNMaildirMailboxBackend * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Maildir:Mailbox:Backend::init"
}
#undef __GOB_FUNCTION__
#line 39 "mn-maildir-mailbox-backend.gob"
static void 
mn_maildir_mailbox_backend_class_init (MNMaildirMailboxBackendClass * class G_GNUC_UNUSED)
#line 114 "mn-maildir-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Maildir:Mailbox:Backend::class_init"
	MNVFSMailboxBackendClass *mn_vfs_mailbox_backend_class = (MNVFSMailboxBackendClass *)class;

	parent_class = g_type_class_ref (MN_TYPE_VFS_MAILBOX_BACKEND);

#line 44 "mn-maildir-mailbox-backend.gob"
	mn_vfs_mailbox_backend_class->monitor_cb = ___2_mn_maildir_mailbox_backend_monitor_cb;
#line 66 "mn-maildir-mailbox-backend.gob"
	mn_vfs_mailbox_backend_class->is = ___3_mn_maildir_mailbox_backend_is;
#line 88 "mn-maildir-mailbox-backend.gob"
	mn_vfs_mailbox_backend_class->check = ___4_mn_maildir_mailbox_backend_check;
#line 127 "mn-maildir-mailbox-backend.c"
 {
#line 40 "mn-maildir-mailbox-backend.gob"

    MN_VFS_MAILBOX_BACKEND_CLASS(class)->format = "Maildir";
  
#line 133 "mn-maildir-mailbox-backend.c"
 }
}
#undef __GOB_FUNCTION__



#line 44 "mn-maildir-mailbox-backend.gob"
static void 
___2_mn_maildir_mailbox_backend_monitor_cb (MNVFSMailboxBackend * backend G_GNUC_UNUSED, const char * info_uri, GnomeVFSMonitorEventType event_type)
#line 143 "mn-maildir-mailbox-backend.c"
#define PARENT_HANDLER(___backend,___info_uri,___event_type) \
	{ if(MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->monitor_cb) \
		(* MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->monitor_cb)(___backend,___info_uri,___event_type); }
{
#define __GOB_FUNCTION__ "MN:Maildir:Mailbox:Backend::monitor_cb"
{
#line 48 "mn-maildir-mailbox-backend.gob"
	
    if (event_type == GNOME_VFS_MONITOR_EVENT_CHANGED
	|| event_type == GNOME_VFS_MONITOR_EVENT_DELETED
	|| event_type == GNOME_VFS_MONITOR_EVENT_CREATED)
      {
	char *filename;
	    
	filename = eel_uri_get_basename(info_uri);
	if (filename)
	  {
	    if (filename[0] != '.')
	      mn_reentrant_mailbox_queue_check(MN_REENTRANT_MAILBOX(backend->mailbox));

	    g_free(filename);
	  }
      }
  }}
#line 168 "mn-maildir-mailbox-backend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 66 "mn-maildir-mailbox-backend.gob"
static gboolean 
___3_mn_maildir_mailbox_backend_is (MNVFSMailboxBackend * dummy G_GNUC_UNUSED, MNVFSMailbox * mailbox)
#line 175 "mn-maildir-mailbox-backend.c"
#define PARENT_HANDLER(___dummy,___mailbox) \
	((MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->is)? \
		(* MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->is)(___dummy,___mailbox): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "MN:Maildir:Mailbox:Backend::is"
{
#line 68 "mn-maildir-mailbox-backend.gob"
	
    int i; 
    const char *constitutive_dirs[] = { "cur", "new", "tmp" };
    gboolean is = FALSE;

    for (i = 0; i < G_N_ELEMENTS(constitutive_dirs); i++)
      {
	GnomeVFSURI *dir_uri;
	
	dir_uri = gnome_vfs_uri_append_path(mailbox->vfs_uri, constitutive_dirs[i]);
	is = mn_vfs_test(dir_uri, G_FILE_TEST_IS_DIR);
	gnome_vfs_uri_unref(dir_uri);
	
	if (! is)
	  break;
      }

    return is;
  }}
#line 203 "mn-maildir-mailbox-backend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 88 "mn-maildir-mailbox-backend.gob"
static void 
___4_mn_maildir_mailbox_backend_check (MNVFSMailboxBackend * backend G_GNUC_UNUSED, unsigned long check_id)
#line 210 "mn-maildir-mailbox-backend.c"
#define PARENT_HANDLER(___backend,___check_id) \
	{ if(MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->check) \
		(* MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->check)(___backend,___check_id); }
{
#define __GOB_FUNCTION__ "MN:Maildir:Mailbox:Backend::check"
{
#line 90 "mn-maildir-mailbox-backend.gob"
	
    GnomeVFSURI *new_uri;
    char *new_text_uri;
    GnomeVFSResult result;
    GnomeVFSResult close_result;
    GnomeVFSDirectoryHandle *handle;
    GnomeVFSFileInfo *file_info;
    GSList *messages = NULL;
    
    new_uri = gnome_vfs_uri_append_path(backend->mailbox->vfs_uri, "new");

    new_text_uri = gnome_vfs_uri_to_string(new_uri, GNOME_VFS_URI_HIDE_NONE);
    mn_vfs_mailbox_backend_monitor(backend, check_id, new_text_uri, GNOME_VFS_MONITOR_DIRECTORY);
    g_free(new_text_uri);

    result = gnome_vfs_directory_open_from_uri(&handle, new_uri, GNOME_VFS_FILE_INFO_FOLLOW_LINKS);
    if (result != GNOME_VFS_OK)
      {
	GDK_THREADS_ENTER();

	if (! mn_reentrant_mailbox_check_aborted_unlocked(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
	  mn_mailbox_set_error(MN_MAILBOX(backend->mailbox), _("unable to open folder \"new\": %s"), gnome_vfs_result_to_string(result));

	gdk_flush();
	GDK_THREADS_LEAVE();

	goto end;
      }
  
    file_info = gnome_vfs_file_info_new();
    while ((result = gnome_vfs_directory_read_next(handle, file_info)) == GNOME_VFS_OK)
      if (file_info->name[0] != '.')
	{
	  GnomeVFSURI *message_uri;

	  if (mn_reentrant_mailbox_check_aborted(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
	    break;

	  message_uri = gnome_vfs_uri_append_file_name(new_uri, file_info->name);
	  messages = g_slist_append(messages, mn_message_new_from_uri(MN_MAILBOX(backend->mailbox), message_uri));
	  gnome_vfs_uri_unref(message_uri);
	}
    gnome_vfs_file_info_unref(file_info);
    close_result = gnome_vfs_directory_close(handle);

    GDK_THREADS_ENTER();
	
    if (! mn_reentrant_mailbox_check_aborted_unlocked(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
      {
	if (result == GNOME_VFS_ERROR_EOF || result == GNOME_VFS_OK)
	  {
	    if (close_result == GNOME_VFS_OK)
	      mn_mailbox_set_messages(MN_MAILBOX(backend->mailbox), messages);
	    else
	      mn_mailbox_set_error(MN_MAILBOX(backend->mailbox), _("unable to close folder \"new\": %s"), gnome_vfs_result_to_string(close_result));
	  }
	else
	  mn_mailbox_set_error(MN_MAILBOX(backend->mailbox), _("error while reading folder \"new\": %s"), gnome_vfs_result_to_string(result));
      }

    mn_g_object_slist_free(messages);

    gdk_flush();
    GDK_THREADS_LEAVE();

  end:
    gnome_vfs_uri_unref(new_uri);
  }}
#line 286 "mn-maildir-mailbox-backend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER
