/* Generated by GOB (v2.0.12) on Tue Aug  9 22:01:55 2005
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 12

#define selfp (self->_priv)

#include "mn-pop3-mailbox.h"

#include "mn-pop3-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 39 "mn-pop3-mailbox.gob"

#include "config.h"
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <glib/gi18n.h>
#include <libgnomevfs/gnome-vfs-utils.h>
#include <eel/eel.h>
#ifdef WITH_SASL
#include <sasl/saslutil.h>
#endif /* WITH_SASL */
#include "mn-mailbox-private.h"
#include "mn-authenticated-mailbox-private.h"
#include "mn-pi-mailbox-private.h"
#include "mn-client-session.h"
#include "mn-util.h"
#include "mn-md5.h"
#include "mn-message-mime.h"

enum
{
  STATE_GREETING = MN_CLIENT_SESSION_INITIAL_STATE,
  STATE_CAPA,
#ifdef WITH_SSL
  STATE_STLS,
#endif
#ifdef WITH_SASL
  STATE_AUTH,
#endif
  STATE_APOP,
  STATE_USER,
  STATE_PASS,
  STATE_LIST,
  STATE_RETR_TOP,
  STATE_QUIT
};

struct _MNClientSessionPrivate
{
  MNMailbox			*mailbox;
  MNAuthenticatedMailbox	*authenticated_mailbox;
  MNPIMailbox			*pi_mailbox;
  MNPOP3Mailbox			*self;
  MNClientSession		*session;
  gboolean			in_list;
  gboolean			in_retr_top;
  char				*apop_timestamp;
  GSList			*auth_mechanisms;
  gboolean			top_supported;
#ifdef WITH_SSL
  gboolean			stls_supported;
  gboolean			stls_completed;
#endif
#ifdef WITH_SASL
  GSList			*sasl_remaining_mechanisms;
  const char			*sasl_mechanism;
  gboolean			sasl_had_clientout;
#endif
  gboolean			authenticated;
  gboolean			login_delay_user;
  GSList			*message_numbers;
  GSList			*current_message_number;
  GSList			*messages;
  GString			*current_message;
};

typedef enum
{
  RESPONSE_OK,
  RESPONSE_ERR,
  RESPONSE_LIST_ITEM,
  RESPONSE_LIST_END,
  RESPONSE_CONTINUATION
} ResponseType;

struct _MNClientSessionResponse
{
  ResponseType	type;
  char		*arguments;
};

int mn_pop3_mailbox_default_ports[MN_PI_MAILBOX_N_CONNECTION_TYPES] = { 110, 110, 995 };

#line 111 "mn-pop3-mailbox.c"
/* self casting macros */
#define SELF(x) MN_POP3_MAILBOX(x)
#define SELF_CONST(x) MN_POP3_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_POP3_MAILBOX(x)
#define TYPE_SELF MN_TYPE_POP3_MAILBOX
#define SELF_CLASS(x) MN_POP3_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_POP3_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNPOP3Mailbox Self;
typedef MNPOP3MailboxClass SelfClass;

/* here are local prototypes */
static void mn_pop3_mailbox_init (MNPOP3Mailbox * o) G_GNUC_UNUSED;
static void mn_pop3_mailbox_class_init (MNPOP3MailboxClass * class) G_GNUC_UNUSED;
static GObject * ___2_mn_pop3_mailbox_constructor (GType type, unsigned int n_construct_properties, GObjectConstructParam * construct_params) G_GNUC_UNUSED;
static void ___3_mn_pop3_mailbox_seal (MNMailbox * mailbox) G_GNUC_UNUSED;
static MNMailbox * ___4_mn_pop3_mailbox_parse_uri (MNMailbox * dummy, const char * uri) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_greeting_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_capa_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_capa_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_stls_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_stls_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void mn_pop3_mailbox_sasl_get_credentials_cb (MNClientSession * session, MNClientSessionPrivate * priv, const char ** username, const char ** password) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_auth_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_auth_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_apop_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_apop_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_user_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_user_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_pass_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_pass_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_list_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_list_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_retr_top_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_retr_top_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_quit_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_quit_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void ___19_mn_pop3_mailbox_impl_check (MNAuthenticatedMailbox * mailbox) G_GNUC_UNUSED;
static void mn_pop3_mailbox_notice_cb (MNClientSession * session, const char * message, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void mn_pop3_mailbox_warning_cb (MNClientSession * session, const char * message, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static MNClientSessionResponse * mn_pop3_mailbox_response_new_cb (MNClientSession * session, const char * input, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void mn_pop3_mailbox_response_free_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_session_authenticate (MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_session_authenticate_fallback (MNClientSessionPrivate * priv, gboolean tried_apop, gboolean tried_pass) G_GNUC_UNUSED;
static int mn_pop3_mailbox_session_authenticated (MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void mn_pop3_mailbox_session_set_error_from_arguments (MNClientSessionPrivate * priv, int code, MNClientSessionResponse * response) G_GNUC_UNUSED;
static void mn_pop3_mailbox_handle_list_response (MNClientSessionPrivate * priv, MNClientSessionResponse * response, gboolean in_retr_top) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static MNPIMailboxClass *parent_class = NULL;

/* Short form macros */
#define self_handle_greeting_cb mn_pop3_mailbox_handle_greeting_cb
#define self_enter_capa_cb mn_pop3_mailbox_enter_capa_cb
#define self_handle_capa_cb mn_pop3_mailbox_handle_capa_cb
#define self_enter_stls_cb mn_pop3_mailbox_enter_stls_cb
#define self_handle_stls_cb mn_pop3_mailbox_handle_stls_cb
#define self_sasl_get_credentials_cb mn_pop3_mailbox_sasl_get_credentials_cb
#define self_enter_auth_cb mn_pop3_mailbox_enter_auth_cb
#define self_handle_auth_cb mn_pop3_mailbox_handle_auth_cb
#define self_enter_apop_cb mn_pop3_mailbox_enter_apop_cb
#define self_handle_apop_cb mn_pop3_mailbox_handle_apop_cb
#define self_enter_user_cb mn_pop3_mailbox_enter_user_cb
#define self_handle_user_cb mn_pop3_mailbox_handle_user_cb
#define self_enter_pass_cb mn_pop3_mailbox_enter_pass_cb
#define self_handle_pass_cb mn_pop3_mailbox_handle_pass_cb
#define self_enter_list_cb mn_pop3_mailbox_enter_list_cb
#define self_handle_list_cb mn_pop3_mailbox_handle_list_cb
#define self_enter_retr_top_cb mn_pop3_mailbox_enter_retr_top_cb
#define self_handle_retr_top_cb mn_pop3_mailbox_handle_retr_top_cb
#define self_enter_quit_cb mn_pop3_mailbox_enter_quit_cb
#define self_handle_quit_cb mn_pop3_mailbox_handle_quit_cb
#define self_notice_cb mn_pop3_mailbox_notice_cb
#define self_warning_cb mn_pop3_mailbox_warning_cb
#define self_response_new_cb mn_pop3_mailbox_response_new_cb
#define self_response_free_cb mn_pop3_mailbox_response_free_cb
#define self_session_authenticate mn_pop3_mailbox_session_authenticate
#define self_session_authenticate_fallback mn_pop3_mailbox_session_authenticate_fallback
#define self_session_authenticated mn_pop3_mailbox_session_authenticated
#define self_session_set_error_from_arguments mn_pop3_mailbox_session_set_error_from_arguments
#define self_handle_list_response mn_pop3_mailbox_handle_list_response
#define self_build_name mn_pop3_mailbox_build_name
GType
mn_pop3_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNPOP3MailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_pop3_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNPOP3Mailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_pop3_mailbox_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_PI_MAILBOX, "MNPOP3Mailbox", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNPOP3Mailbox *)g_object_new(mn_pop3_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNPOP3Mailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNPOP3Mailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNPOP3Mailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNPOP3Mailbox *)g_object_new_valist (mn_pop3_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::finalize"
	MNPOP3Mailbox *self G_GNUC_UNUSED = MN_POP3_MAILBOX (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 128 "mn-pop3-mailbox.gob"
	if(self->_priv->authentication_timer) { g_timer_destroy ((gpointer) self->_priv->authentication_timer); self->_priv->authentication_timer = NULL; }
#line 249 "mn-pop3-mailbox.c"
}
#undef __GOB_FUNCTION__

static void 
mn_pop3_mailbox_init (MNPOP3Mailbox * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,MN_TYPE_POP3_MAILBOX,MNPOP3MailboxPrivate);
}
#undef __GOB_FUNCTION__
#line 130 "mn-pop3-mailbox.gob"
static void 
mn_pop3_mailbox_class_init (MNPOP3MailboxClass * class G_GNUC_UNUSED)
#line 263 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;
	MNMailboxClass *mn_mailbox_class = (MNMailboxClass *)class;
	MNAuthenticatedMailboxClass *mn_authenticated_mailbox_class = (MNAuthenticatedMailboxClass *)class;

	g_type_class_add_private(class,sizeof(MNPOP3MailboxPrivate));

	parent_class = g_type_class_ref (MN_TYPE_PI_MAILBOX);

#line 136 "mn-pop3-mailbox.gob"
	g_object_class->constructor = ___2_mn_pop3_mailbox_constructor;
#line 150 "mn-pop3-mailbox.gob"
	mn_mailbox_class->seal = ___3_mn_pop3_mailbox_seal;
#line 163 "mn-pop3-mailbox.gob"
	mn_mailbox_class->parse_uri = ___4_mn_pop3_mailbox_parse_uri;
#line 772 "mn-pop3-mailbox.gob"
	mn_authenticated_mailbox_class->impl_check = ___19_mn_pop3_mailbox_impl_check;
#line 282 "mn-pop3-mailbox.c"
	g_object_class->finalize = ___finalize;
 {
#line 131 "mn-pop3-mailbox.gob"

    MN_MAILBOX_CLASS(class)->type = "pop3";
    MN_PI_MAILBOX_CLASS(class)->default_ports = mn_pop3_mailbox_default_ports;
  
#line 290 "mn-pop3-mailbox.c"
 }
}
#undef __GOB_FUNCTION__



#line 136 "mn-pop3-mailbox.gob"
static GObject * 
___2_mn_pop3_mailbox_constructor (GType type G_GNUC_UNUSED, unsigned int n_construct_properties, GObjectConstructParam * construct_params)
#line 300 "mn-pop3-mailbox.c"
#define PARENT_HANDLER(___type,___n_construct_properties,___construct_params) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_construct_properties,___construct_params): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::constructor"
{
#line 138 "mn-pop3-mailbox.gob"
	
    GObject *object;
    MNMailbox *mailbox;

    object = PARENT_HANDLER(type, n_construct_properties, construct_params);
    mailbox = MN_MAILBOX(object);

    mn_mailbox_set_format(mailbox, "POP3");

    return object;
  }}
#line 320 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 150 "mn-pop3-mailbox.gob"
static void 
___3_mn_pop3_mailbox_seal (MNMailbox * mailbox G_GNUC_UNUSED)
#line 327 "mn-pop3-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_MAILBOX_CLASS(parent_class)->seal) \
		(* MN_MAILBOX_CLASS(parent_class)->seal)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::seal"
{
#line 152 "mn-pop3-mailbox.gob"
	
    PARENT_HANDLER(mailbox);

    if (! mailbox->runtime_name)
      mailbox->runtime_name = self_build_name(MN_AUTHENTICATED_MAILBOX(mailbox)->username,
					      MN_PI_MAILBOX(mailbox)->hostname);
  }}
#line 342 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 163 "mn-pop3-mailbox.gob"
static MNMailbox * 
___4_mn_pop3_mailbox_parse_uri (MNMailbox * dummy G_GNUC_UNUSED, const char * uri)
#line 349 "mn-pop3-mailbox.c"
#define PARENT_HANDLER(___dummy,___uri) \
	((MN_MAILBOX_CLASS(parent_class)->parse_uri)? \
		(* MN_MAILBOX_CLASS(parent_class)->parse_uri)(___dummy,___uri): \
		((MNMailbox * )0))
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::parse_uri"
{
#line 165 "mn-pop3-mailbox.gob"
	
    int len;
    int buflen;
    char *username = NULL;
    char *authmech = NULL;
    char *hostname;
    int port;
    MNMailbox *mailbox;

    len = strlen(uri);
    buflen = len + 1;
    
    {
      char scheme_buf[buflen];
      char auth_buf[buflen];
      char location_buf[buflen];
      char username_buf[buflen];
      char authmech_buf[buflen];
      char hostname_buf[buflen];
      gboolean has_auth;
      gboolean has_username = FALSE;
      gboolean has_authmech = FALSE;

      if (! mn_pi_mailbox_split_uri(uri, len, scheme_buf, auth_buf, location_buf, &has_auth))
	return NULL;

      if (strcmp(scheme_buf, "pop"))
	return NULL;

      if (has_auth)
	{
	  if (! mn_pi_mailbox_split_uri_auth(auth_buf, len, username_buf, authmech_buf, &has_username, &has_authmech))
	    return NULL;

	  if (has_authmech)
	    {
	      if (! has_username)
		return NULL;	/* see user-auth in RFC 2384 ABNF */
	      if (! strcmp(authmech_buf, "*"))
		has_authmech = FALSE;
	    }
	}

      mn_pi_mailbox_split_uri_hostport(location_buf, len, hostname_buf, &port);

      if (has_username)
	username = gnome_vfs_unescape_string(username_buf, NULL);
      if (has_authmech)
	authmech = gnome_vfs_unescape_string(authmech_buf, NULL);
      hostname = gnome_vfs_unescape_string(hostname_buf, NULL);
    }

    mailbox = mn_mailbox_new("pop3",
			     "username", username,
			     "authmech", authmech,
			     "hostname", hostname,
			     "port", port,
			     NULL);

    g_free(username);
    g_free(authmech);
    g_free(hostname);

    return mailbox;
  }}
#line 423 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 231 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_greeting_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 430 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_greeting_cb"
{
#line 235 "mn-pop3-mailbox.gob"
	
    priv->session = session;
    
    switch (response->type)
      {
      case RESPONSE_OK:
	if (response->arguments)
	  {
	    char *timestamp;
	    
	    timestamp = strchr(response->arguments, '<');
	    if (timestamp)
	      {
		char *timestamp_end;
		
		timestamp_end = strchr(timestamp, '>');
		if (timestamp_end)
		  priv->apop_timestamp = g_strndup(timestamp, timestamp_end - timestamp + 1);
	      }
	  }
	return STATE_CAPA;
	
      case RESPONSE_ERR:
	self_session_set_error_from_arguments(priv, MN_CLIENT_SESSION_ERROR_OTHER, response);
	return MN_CLIENT_SESSION_RESULT_DISCONNECT;

      default:
	return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
  }}
#line 465 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 266 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_capa_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 471 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_capa_cb"
{
#line 269 "mn-pop3-mailbox.gob"
	
    return mn_client_session_write(session, "CAPA");
  }}
#line 479 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 273 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_capa_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 485 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_capa_cb"
{
#line 277 "mn-pop3-mailbox.gob"
	
    self_handle_list_response(priv, response, FALSE);

    switch (response->type)
      {
      case RESPONSE_OK:
	eel_g_slist_free_deep(priv->auth_mechanisms);
	priv->auth_mechanisms = NULL;
#ifdef WITH_SASL
	g_slist_free(priv->sasl_remaining_mechanisms);
	priv->sasl_remaining_mechanisms = NULL;
#endif
	priv->top_supported = FALSE;
	priv->self->_priv->login_delay = 0;
	priv->login_delay_user = FALSE;
#ifdef WITH_SSL
	priv->stls_supported = FALSE;
#endif

	return MN_CLIENT_SESSION_RESULT_CONTINUE;
	
      case RESPONSE_ERR:
      case RESPONSE_LIST_END:
	if (priv->authenticated)
	  return STATE_LIST;

#ifdef WITH_SSL
	if (priv->pi_mailbox->connection_type == MN_PI_MAILBOX_CONNECTION_TYPE_INBAND_SSL
	    && ! priv->stls_completed)
	  {
	    if (priv->stls_supported)
	      return STATE_STLS;
	    else
	      {
		mn_client_session_error(priv->session, MN_CLIENT_SESSION_ERROR_OTHER, _("server does not support in-band SSL/TLS"));
		return STATE_QUIT;
	      }
	  }
	else
#endif /* WITH_SSL */
	  return self_session_authenticate(priv);
      
      case RESPONSE_LIST_ITEM:
	{
	  char **tokens;
	  gboolean login_delay_error = FALSE;
	  
	  tokens = g_strsplit(response->arguments, " ", 0);
	  if (tokens[0])
	    {
	      if (! strcmp(tokens[0], "SASL"))
		{
		  int i;
		  
		  for (i = 1; tokens[i]; i++)
		    priv->auth_mechanisms = g_slist_append(priv->auth_mechanisms, g_strdup(tokens[i]));
		}
	      else if (! strcmp(tokens[0], "TOP"))
		priv->top_supported = TRUE;
#ifdef WITH_SSL
	      else if (! strcmp(tokens[0], "STLS"))
		priv->stls_supported = TRUE;
#endif /* WITH_SSL */
	      else if (! strcmp(tokens[0], "LOGIN-DELAY"))
		{
		  if (tokens[1] && mn_str_isnumeric(tokens[1])
		      && (! tokens[2]
			  || (! tokens[3]
			      && ! priv->authenticated
			      && ! strcmp(tokens[2], "USER"))))
		    {
		      priv->self->_priv->login_delay = atoi(tokens[1]);
		      if (tokens[2])
			priv->login_delay_user = TRUE;
		    }
		  else
		    login_delay_error = TRUE;
		}
	    }
	  g_strfreev(tokens);
	  
	  if (login_delay_error)
	    return mn_client_session_error(session, MN_CLIENT_SESSION_ERROR_OTHER, _("invalid arguments for the LOGIN-DELAY capability"));
	}
	return MN_CLIENT_SESSION_RESULT_CONTINUE;
	
      default:
	return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
  }}
#line 580 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 368 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_stls_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 586 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_stls_cb"
{
#line 371 "mn-pop3-mailbox.gob"
	
#ifdef WITH_SSL
    return mn_client_session_write(session, "STLS");
#else
    g_return_val_if_reached(0);
#endif /* WITH_SSL */
  }}
#line 598 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 379 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_stls_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 604 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_stls_cb"
{
#line 383 "mn-pop3-mailbox.gob"
	
#ifdef WITH_SSL
    switch (response->type)
      {
      case RESPONSE_OK:
	priv->stls_completed = TRUE;
	return mn_client_session_enable_ssl(session)
	  ? STATE_CAPA /* [1] */
	  : MN_CLIENT_SESSION_RESULT_DISCONNECT;

	/*
	 * [1] RFC 2595 4:
	 *
	 * "Once TLS has been started, the client MUST discard cached
	 * information about server capabilities and SHOULD re-issue
	 * the CAPA command."
	 */

      case RESPONSE_ERR:
	return self_session_authenticate(priv);

      default:
	return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
#else
    g_return_val_if_reached(0);
#endif /* WITH_SSL */
  }}
#line 637 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 412 "mn-pop3-mailbox.gob"
static void 
mn_pop3_mailbox_sasl_get_credentials_cb (MNClientSession * session, MNClientSessionPrivate * priv, const char ** username, const char ** password)
#line 643 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::sasl_get_credentials_cb"
{
#line 417 "mn-pop3-mailbox.gob"
	
#ifdef WITH_SASL
    g_return_if_fail(username != NULL || password != NULL);

    mn_authenticated_mailbox_fill_credentials(priv->authenticated_mailbox,
					      username != NULL,
					      password != NULL);

    if (username)
      *username = priv->authenticated_mailbox->runtime_username;

    if (password)
      *password = priv->authenticated_mailbox->runtime_password;
#else
    g_return_if_reached();
#endif /* WITH_SASL */
  }}
#line 665 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 435 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_auth_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 671 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_auth_cb"
{
#line 438 "mn-pop3-mailbox.gob"
	
#ifdef WITH_SASL
    /*
     * RFC 2449 6.3 specifies that POP3 supports the initial client
     * response feature of SASL.
     */
    const char *initial_clientout = NULL;
    unsigned int initial_clientoutlen = 0;

    priv->sasl_mechanism = NULL;

    if (mn_client_session_sasl_authentication_start(priv->session,
						    "pop",
						    priv->sasl_remaining_mechanisms,
						    priv->pi_mailbox->authmech,
						    &priv->sasl_mechanism,
						    priv->sasl_had_clientout ? NULL : &initial_clientout,
						    priv->sasl_had_clientout ? NULL : &initial_clientoutlen))
      {
	g_return_val_if_fail(priv->sasl_mechanism != NULL, 0);

	if (initial_clientoutlen > 0)
	  {
	    char buf64[initial_clientoutlen * 2]; /* Base64 is 33% larger than the data it encodes */
	    unsigned int outlen;
	    int result;
	    char *str;

	    result = sasl_encode64(initial_clientout, initial_clientoutlen, buf64, sizeof(buf64), &outlen);
	    if (result != SASL_OK)
	      return mn_client_session_error(session, MN_CLIENT_SESSION_ERROR_OTHER, _("unable to encode Base64: %s"), sasl_errstring(result, NULL, NULL));

	    str = g_strndup(buf64, outlen);
	    result = mn_client_session_write(session, "AUTH %s %s", priv->sasl_mechanism, str);
	    g_free(str);

	    priv->sasl_had_clientout = TRUE;
	    return result;
	  }
	else
	  {
	    priv->sasl_had_clientout = FALSE;
	    return mn_client_session_write(session, "AUTH %s", priv->sasl_mechanism);
	  }
      }
    else
      return priv->authenticated_mailbox->cancelled
	? STATE_QUIT
	: self_session_authenticate_fallback(priv, FALSE, FALSE);
#else
    g_return_val_if_reached(0);
#endif /* WITH_SASL */
  }}
#line 729 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 492 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_auth_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 735 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_auth_cb"
{
#line 496 "mn-pop3-mailbox.gob"
	
#ifdef WITH_SASL
    switch (response->type)
      {
      case RESPONSE_OK:
	return mn_client_session_sasl_authentication_done(session)
	  ? self_session_authenticated(priv)
	  : MN_CLIENT_SESSION_RESULT_DISCONNECT;
	
      case RESPONSE_ERR:
	if (priv->authenticated_mailbox->cancelled)
	  return STATE_QUIT;
	else
	  {
	    if (priv->sasl_had_clientout)
	      {
		/*
		 * Some servers violate RFC 2449 by not supporting a
		 * second argument to the AUTH command. Support these
		 * servers nevertheless, by retrying without the SASL
		 * initial client response.
		 */
	      
		mn_client_session_notice(session, _("SASL authentication with initial client response failed, retrying without initial client response"));
		return STATE_AUTH;
	      }
	    else
	      return self_session_authenticate_fallback(priv, FALSE, FALSE);
	  }

      case RESPONSE_CONTINUATION:
	return mn_client_session_sasl_authentication_step(session, response->arguments);
	
      default:
	return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
#else
    g_return_val_if_reached(0);
#endif /* WITH_SASL */
  }}
#line 780 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 537 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_apop_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 786 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_apop_cb"
{
#line 540 "mn-pop3-mailbox.gob"
	
    MNMD5Context context;
    char buf[33];
  
    g_return_val_if_fail(priv->apop_timestamp != NULL, 0);

    mn_authenticated_mailbox_fill_credentials(priv->authenticated_mailbox, TRUE, TRUE);
    if (! priv->authenticated_mailbox->runtime_username
	|| ! priv->authenticated_mailbox->runtime_password)
      return STATE_QUIT;

    mn_md5_init(&context);
    mn_md5_update(&context, priv->apop_timestamp, strlen(priv->apop_timestamp));
    mn_md5_update(&context, priv->authenticated_mailbox->runtime_password, strlen(priv->authenticated_mailbox->runtime_password));
    mn_md5_end(&context, buf);

    return mn_client_session_write(session, "APOP %s %s", priv->authenticated_mailbox->runtime_username, buf);
  }}
#line 809 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 559 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_apop_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 815 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_apop_cb"
#line 559 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 559 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 559 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 824 "mn-pop3-mailbox.c"
{
#line 563 "mn-pop3-mailbox.gob"
	
    switch (response->type)
      {
      case RESPONSE_OK:
	return self_session_authenticated(priv);
	
      case RESPONSE_ERR:
	return self_session_authenticate_fallback(priv, TRUE, FALSE);

      default:
	return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
  }}
#line 840 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 577 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_user_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 846 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_user_cb"
#line 577 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 577 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 853 "mn-pop3-mailbox.c"
{
#line 580 "mn-pop3-mailbox.gob"
	
    mn_authenticated_mailbox_fill_credentials(priv->authenticated_mailbox, TRUE, TRUE);
    if (! priv->authenticated_mailbox->runtime_username
	|| ! priv->authenticated_mailbox->runtime_password)
      return STATE_QUIT;

    return mn_client_session_write(session, "USER %s", priv->authenticated_mailbox->runtime_username);
  }}
#line 864 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 589 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_user_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 870 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_user_cb"
{
#line 593 "mn-pop3-mailbox.gob"
	
    switch (response->type)
      {
      case RESPONSE_OK:
	return STATE_PASS;

      case RESPONSE_ERR:
	self_session_set_error_from_arguments(priv, MN_CLIENT_SESSION_ERROR_OTHER, response);
	return STATE_QUIT;

      default:
	return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
  }}
#line 889 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 608 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_pass_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 895 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_pass_cb"
{
#line 611 "mn-pop3-mailbox.gob"
	
    g_return_val_if_fail(priv->authenticated_mailbox->runtime_password != NULL, 0);

    return mn_client_session_write(session, "PASS %s", priv->authenticated_mailbox->runtime_password);
  }}
#line 905 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 617 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_pass_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 911 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_pass_cb"
{
#line 621 "mn-pop3-mailbox.gob"
	
    switch (response->type)
      {
      case RESPONSE_OK:
	return self_session_authenticated(priv);

      case RESPONSE_ERR:
	return self_session_authenticate_fallback(priv, TRUE, TRUE);

      default:
	return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
  }}
#line 929 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 635 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_list_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 935 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_list_cb"
{
#line 638 "mn-pop3-mailbox.gob"
	
    return mn_client_session_write(session, "LIST");
  }}
#line 943 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 642 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_list_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 949 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_list_cb"
{
#line 646 "mn-pop3-mailbox.gob"
	
    self_handle_list_response(priv, response, FALSE);

    switch (response->type)
      {
      case RESPONSE_OK:
	return MN_CLIENT_SESSION_RESULT_CONTINUE;

      case RESPONSE_LIST_END:
	priv->current_message_number = priv->message_numbers;
	return STATE_RETR_TOP;

      case RESPONSE_ERR:
	self_session_set_error_from_arguments(priv, MN_CLIENT_SESSION_ERROR_OTHER, response);
	return MN_CLIENT_SESSION_RESULT_DISCONNECT;

      case RESPONSE_LIST_ITEM:
	{
	  int num;
	  int size;
	  
	  if (sscanf(response->arguments, "%d %d", &num, &size) == 2)
	    priv->message_numbers = g_slist_append(priv->message_numbers, GINT_TO_POINTER(num));
	  else			/* compliance error */
	    return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	}
	return MN_CLIENT_SESSION_RESULT_CONTINUE;
	
      default:
	return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
  }}
#line 986 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 679 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_retr_top_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 992 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_retr_top_cb"
{
#line 682 "mn-pop3-mailbox.gob"
	
    if (priv->current_message_number)
      return mn_client_session_write(session, priv->top_supported ? "TOP %i 0" : "RETR %i", GPOINTER_TO_INT(priv->current_message_number->data));
    else
      {
	GDK_THREADS_ENTER();

	mn_mailbox_set_messages(priv->mailbox, priv->messages);

	/*
	 * In impl_check(), we do not hold the GDK lock while
	 * unreffing the message list. We have just exposed the list
	 * to other threads through our mn_mailbox_set_messages()
	 * call, so unref it here, while we hold the GDK lock.
	 */
	mn_g_object_slist_free(priv->messages);
	priv->messages = NULL;

	gdk_flush();
	GDK_THREADS_LEAVE();
	
	return STATE_QUIT;
      }
  }}
#line 1021 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 707 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_retr_top_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 1027 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_retr_top_cb"
{
#line 711 "mn-pop3-mailbox.gob"
	
    self_handle_list_response(priv, response, TRUE);

    switch (response->type)
      {
      case RESPONSE_OK:
	if (priv->current_message)
	  g_string_free(priv->current_message, TRUE);
	priv->current_message = g_string_new(NULL);
	return MN_CLIENT_SESSION_RESULT_CONTINUE;

      case RESPONSE_LIST_END:
	priv->messages = g_slist_append(priv->messages,
					mn_message_new_from_buffer(priv->mailbox,
								   priv->current_message->str,
								   priv->current_message->len));
	priv->current_message_number = priv->current_message_number->next;
	return STATE_RETR_TOP;

      case RESPONSE_ERR:
	priv->messages = g_slist_append(priv->messages,
					mn_message_new_from_error(priv->mailbox,
								  response->arguments ? response->arguments : _("unknown error")));
	priv->current_message_number = priv->current_message_number->next;
	return STATE_RETR_TOP;

      case RESPONSE_LIST_ITEM:
	g_string_append_printf(priv->current_message, "%s\n", response->arguments);
	return MN_CLIENT_SESSION_RESULT_CONTINUE;

      default:
	return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
  }}
#line 1066 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 746 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_quit_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 1072 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_quit_cb"
{
#line 749 "mn-pop3-mailbox.gob"
	
    return mn_client_session_write(session, "QUIT");
  }}
#line 1080 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 753 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_quit_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 1086 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_quit_cb"
{
#line 757 "mn-pop3-mailbox.gob"
	
    switch (response->type)
      {
      case RESPONSE_OK:
	return MN_CLIENT_SESSION_RESULT_DISCONNECT;

      case RESPONSE_ERR:
	self_session_set_error_from_arguments(priv, MN_CLIENT_SESSION_ERROR_OTHER, response);
	return MN_CLIENT_SESSION_RESULT_DISCONNECT;

      default:
	return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
  }}
#line 1105 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 772 "mn-pop3-mailbox.gob"
static void 
___19_mn_pop3_mailbox_impl_check (MNAuthenticatedMailbox * mailbox G_GNUC_UNUSED)
#line 1111 "mn-pop3-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_AUTHENTICATED_MAILBOX_CLASS(parent_class)->impl_check) \
		(* MN_AUTHENTICATED_MAILBOX_CLASS(parent_class)->impl_check)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::impl_check"
{
#line 774 "mn-pop3-mailbox.gob"
	
    Self *self = SELF(mailbox);
    MNClientSessionState states[] = {
      { STATE_GREETING,		NULL,			self_handle_greeting_cb },
      { STATE_CAPA,		self_enter_capa_cb,	self_handle_capa_cb },
#ifdef WITH_SSL
      { STATE_STLS,		self_enter_stls_cb,	self_handle_stls_cb },
#endif
#ifdef WITH_SASL
      { STATE_AUTH,		self_enter_auth_cb,	self_handle_auth_cb },
#endif
      { STATE_APOP,		self_enter_apop_cb,	self_handle_apop_cb },
      { STATE_USER,		self_enter_user_cb,	self_handle_user_cb },
      { STATE_PASS,		self_enter_pass_cb,	self_handle_pass_cb },
      { STATE_LIST,		self_enter_list_cb,	self_handle_list_cb },
      { STATE_RETR_TOP,		self_enter_retr_top_cb,	self_handle_retr_top_cb },
      { STATE_QUIT,		self_enter_quit_cb,	self_handle_quit_cb },
      
      MN_CLIENT_SESSION_STATES_END
    };
    MNClientSessionCallbacks callbacks = {
      self_notice_cb,
      self_warning_cb,
      self_response_new_cb,
      self_response_free_cb,
      NULL,			/* pre_read */
      NULL,			/* post_read */
#ifdef WITH_SASL
      self_sasl_get_credentials_cb,
#endif
    };
    MNClientSessionPrivate priv;
    gboolean status;
    GError *err = NULL;

    PARENT_HANDLER(mailbox);

    /* check if the parent handler has disabled the mailbox */
    if (! MN_MAILBOX(self)->must_poll)
      return;

    if (selfp->login_delay && selfp->authentication_timer)
      {
	double elapsed;

	g_timer_stop(selfp->authentication_timer);
	elapsed = g_timer_elapsed(selfp->authentication_timer, NULL);

	if (elapsed < selfp->login_delay)
	  {
	    int sleeptime;
	    
	    sleeptime = selfp->login_delay - elapsed;
	    mn_mailbox_notice(MN_MAILBOX(self),
			      ngettext("honouring LOGIN-DELAY, sleeping for %i second",
				       "honouring LOGIN-DELAY, sleeping for %i seconds",
				       sleeptime),
			      sleeptime);
	    sleep(sleeptime);
	  }
      }
  
    memset(&priv, 0, sizeof(priv));
    priv.mailbox = MN_MAILBOX(self);
    priv.authenticated_mailbox = mailbox;
    priv.pi_mailbox = MN_PI_MAILBOX(self);
    priv.self = self;

    status = mn_client_session_run(states,
				   &callbacks,
#ifdef WITH_SSL
				   priv.pi_mailbox->connection_type == MN_PI_MAILBOX_CONNECTION_TYPE_SSL,
#endif
				   priv.pi_mailbox->hostname,
				   priv.pi_mailbox->runtime_port,
				   &priv,
				   &err);

    if (! status)
      {
	GDK_THREADS_ENTER();

	mn_mailbox_set_error(MN_MAILBOX(self), "%s", err->message);

	gdk_flush();
	GDK_THREADS_LEAVE();

	g_error_free(err);
      }

    g_free(priv.apop_timestamp);
    eel_g_slist_free_deep(priv.auth_mechanisms);
#ifdef WITH_SASL
    g_slist_free(priv.sasl_remaining_mechanisms);
#endif
    g_slist_free(priv.message_numbers);
    mn_g_object_slist_free(priv.messages);
    if (priv.current_message)
      g_string_free(priv.current_message, TRUE);
  }}
#line 1219 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 875 "mn-pop3-mailbox.gob"
static void 
mn_pop3_mailbox_notice_cb (MNClientSession * session, const char * message, MNClientSessionPrivate * priv)
#line 1226 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::notice_cb"
{
#line 879 "mn-pop3-mailbox.gob"
	
    mn_mailbox_notice(priv->mailbox, "%s", message);
  }}
#line 1234 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 883 "mn-pop3-mailbox.gob"
static void 
mn_pop3_mailbox_warning_cb (MNClientSession * session, const char * message, MNClientSessionPrivate * priv)
#line 1240 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::warning_cb"
{
#line 887 "mn-pop3-mailbox.gob"
	
    mn_mailbox_warning(priv->mailbox, "%s", message);
  }}
#line 1248 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 891 "mn-pop3-mailbox.gob"
static MNClientSessionResponse * 
mn_pop3_mailbox_response_new_cb (MNClientSession * session, const char * input, MNClientSessionPrivate * priv)
#line 1254 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::response_new_cb"
{
#line 895 "mn-pop3-mailbox.gob"
	
    MNClientSessionResponse *response = NULL;

    /*
     * About character set handling:
     *
     * RFC 1939 3 specifies that "keywords and arguments consist of
     * printable ASCII characters", however that refers to
     * commands. Nothing is said about responses.
     *
     * We need responses to be valid UTF-8, because they might end up
     * showing up in the UI (for instance, through
     * session_set_error_from_arguments()).
     *
     * However, RETR/TOP multiline responses do not need to (and must
     * not) be validated: most servers send them in whatever charset
     * the original message is, and our mn-message-mime implementation
     * handles that.
     */
    if (priv->in_retr_top || g_utf8_validate(input, -1, NULL))
      {
	if (priv->in_list)
	  {
	    response = g_new0(MNClientSessionResponse, 1);
	    if (! strcmp(input, "."))
	      response->type = RESPONSE_LIST_END;
	    else if (g_str_has_prefix(input, ".."))
	      {
		response->type = RESPONSE_LIST_ITEM;
		response->arguments = g_strdup(input + 1); /* skip the initial dot */
	      }
	    else
	      {
		response->type = RESPONSE_LIST_ITEM;
		response->arguments = g_strdup(input);
	      }
	  }
	else
	  {
	    if (g_str_has_prefix(input, "+ "))
	      {
		response = g_new0(MNClientSessionResponse, 1);
		response->type = RESPONSE_CONTINUATION;
		response->arguments = g_strdup(input + 2);
	      }
	    else
	      {
		ResponseType type;
		int after_status = 0;
		
		if (g_str_has_prefix(input, "+OK"))
		  {
		    type = RESPONSE_OK;
		    after_status = 3;
		  }
		else if (g_str_has_prefix(input, "-ERR"))
		  {
		    type = RESPONSE_ERR;
		    after_status = 4;
		  }
		
		if (after_status)
		  {
		    if (input[after_status] == 0 || input[after_status] == ' ')
		      {
			response = g_new0(MNClientSessionResponse, 1);
			response->type = type;
			if (input[after_status] == ' ')
			  response->arguments = g_strdup(input + after_status + 1);
		      }
		  }
	      }
	  }
      }
    
    return response;
  }}
#line 1336 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 973 "mn-pop3-mailbox.gob"
static void 
mn_pop3_mailbox_response_free_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 1342 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::response_free_cb"
{
#line 977 "mn-pop3-mailbox.gob"
	
    g_free(response->arguments);
    g_free(response);
  }}
#line 1351 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 982 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_session_authenticate (MNClientSessionPrivate * priv)
#line 1357 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::session_authenticate"
#line 982 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1362 "mn-pop3-mailbox.c"
{
#line 984 "mn-pop3-mailbox.gob"
	
#ifdef WITH_SASL
    g_slist_free(priv->sasl_remaining_mechanisms);
    priv->sasl_remaining_mechanisms = g_slist_copy(priv->auth_mechanisms);
#endif /* WITH_SASL */

    if (priv->pi_mailbox->authmech)
      {
	if (*priv->pi_mailbox->authmech != '+')
	  {
#ifdef WITH_SASL
	    return STATE_AUTH;
#else
	    mn_client_session_error(priv->session, MN_CLIENT_SESSION_ERROR_OTHER, _("a SASL authentication mechanism was selected but SASL support has not been compiled in"));
	    return STATE_QUIT;
#endif /* WITH_SASL */
	  }
	else
	  {
	    if (! strcmp(priv->pi_mailbox->authmech, "+APOP"))
	      {
		if (priv->apop_timestamp)
		  return STATE_APOP;
		else
		  {
		    mn_client_session_error(priv->session, MN_CLIENT_SESSION_ERROR_OTHER, _("server does not support APOP authentication"));
		    return STATE_QUIT;
		  }
	      }
	    else if (! strcmp(priv->pi_mailbox->authmech, "+USERPASS"))
	      return STATE_USER;
	    else
	      {
		mn_client_session_error(priv->session, MN_CLIENT_SESSION_ERROR_OTHER, _("unknown authentication mechanism \"%s\""), priv->pi_mailbox->authmech);
		return STATE_QUIT;
	      }
	  }
      }
    else
      {
#ifdef WITH_SASL
	if (priv->sasl_remaining_mechanisms)
	  return STATE_AUTH;
#endif /* WITH_SASL */
	if (priv->apop_timestamp)
	  return STATE_APOP;
	else
	  return STATE_USER;
      }
  }}
#line 1415 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 1035 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_session_authenticate_fallback (MNClientSessionPrivate * priv, gboolean tried_apop, gboolean tried_pass)
#line 1421 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::session_authenticate_fallback"
#line 1035 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1426 "mn-pop3-mailbox.c"
{
#line 1039 "mn-pop3-mailbox.gob"
	
    if (! priv->pi_mailbox->authmech)
      {
#ifdef WITH_SASL
	if (priv->sasl_mechanism)
	  {
	    GSList *elem;

	    elem = mn_g_str_slist_find(priv->sasl_remaining_mechanisms, priv->sasl_mechanism);
	    if (elem)
	      {
		priv->sasl_remaining_mechanisms = g_slist_delete_link(priv->sasl_remaining_mechanisms, elem);
		if (priv->sasl_remaining_mechanisms)
		  {
		    mn_client_session_notice(priv->session, _("disabling mechanism \"%s\" and retrying SASL authentication"), priv->sasl_mechanism);
		    return STATE_AUTH;
		  }
	      }
	  }

	/* SASL is not needed anymore, save some memory */
	mn_client_session_sasl_dispose(priv->session);
#endif /* WITH_SASL */

	if (! tried_apop && priv->apop_timestamp)
	  {
	    mn_client_session_notice(priv->session, _("falling back to APOP authentication"));
	    return STATE_APOP;
	  }
	else if (! tried_pass)
	  {
	    mn_client_session_notice(priv->session, _("falling back to USER/PASS authentication"));
	    return STATE_USER;
	  }
      }

    if (priv->authenticated_mailbox->prompted)
      {
	mn_authenticated_mailbox_authentication_failed(priv->authenticated_mailbox);
	return self_session_authenticate(priv);
      }
    else
      {
	mn_client_session_error(priv->session, MN_CLIENT_SESSION_ERROR_OTHER, _("authentication failed"));
	return STATE_QUIT;
      }
  }}
#line 1476 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 1087 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_session_authenticated (MNClientSessionPrivate * priv)
#line 1482 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::session_authenticated"
#line 1087 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1487 "mn-pop3-mailbox.c"
{
#line 1089 "mn-pop3-mailbox.gob"
	
    priv->authenticated = TRUE;
    if (priv->self->_priv->login_delay)
      {
	if (priv->self->_priv->authentication_timer)
	  g_timer_start(priv->self->_priv->authentication_timer);
	else
	  priv->self->_priv->authentication_timer = g_timer_new();
      }

    /*
     * We are now in transaction state. We must re-issue CAPA if:
     *
     *   - the LOGIN-DELAY capability announced in the authorization
     *     state contained the USER argument (priv->login_delay_user is
     *     true)
     *   - the TOP capability was not announced in the authorization
     *     state: although RFC 2449 states that "capabilities available
     *     in the AUTHORIZATION state MUST be announced in both states",
     *     some servers (for instance, pop.gmail.com) violate the RFC
     *     and only announce TOP in the transaction state.
     */
    return priv->login_delay_user || ! priv->top_supported
      ? STATE_CAPA
      : STATE_LIST;
  }}
#line 1516 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 1116 "mn-pop3-mailbox.gob"
static void 
mn_pop3_mailbox_session_set_error_from_arguments (MNClientSessionPrivate * priv, int code, MNClientSessionResponse * response)
#line 1522 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::session_set_error_from_arguments"
#line 1116 "mn-pop3-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 1116 "mn-pop3-mailbox.gob"
	g_return_if_fail (response != NULL);
#line 1529 "mn-pop3-mailbox.c"
{
#line 1120 "mn-pop3-mailbox.gob"
	
    if (response->arguments)
      mn_client_session_error(priv->session, code, "\"%s\"", response->arguments);
    else
      mn_client_session_error(priv->session, code, _("unknown server error"));
  }}
#line 1538 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 1127 "mn-pop3-mailbox.gob"
static void 
mn_pop3_mailbox_handle_list_response (MNClientSessionPrivate * priv, MNClientSessionResponse * response, gboolean in_retr_top)
#line 1544 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_list_response"
#line 1127 "mn-pop3-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 1127 "mn-pop3-mailbox.gob"
	g_return_if_fail (response != NULL);
#line 1551 "mn-pop3-mailbox.c"
{
#line 1131 "mn-pop3-mailbox.gob"
	
    switch (response->type)
      {
      case RESPONSE_OK:
	priv->in_list = TRUE;
	priv->in_retr_top = in_retr_top;
	break;

      case RESPONSE_LIST_ITEM:	/* nop */
	break;

      default:
	priv->in_list = FALSE;
	priv->in_retr_top = FALSE;
	break;
      }
  }}
#line 1571 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 1149 "mn-pop3-mailbox.gob"
char * 
mn_pop3_mailbox_build_name (const char * username, const char * hostname)
#line 1577 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::build_name"
#line 1149 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (hostname != NULL, (char * )0);
#line 1582 "mn-pop3-mailbox.c"
{
#line 1151 "mn-pop3-mailbox.gob"
	
    return username
      ? g_strdup_printf("%s@%s", username, hostname)
      : g_strdup(hostname);
  }}
#line 1590 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__
