/* This file is part of the KDE project

   Copyright (C) 2006-2007 Omat Holding B.V. <info@omat.nl>
   Copyright (C) 2007 Frode M. Døving <frode@lnix.net>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/


#ifndef COMPOSER_H
#define COMPOSER_H

#include "mailtransport/transportcombobox.h"
#include <akonadi/collection.h>
#include <kabc/stdaddressbook.h>
#include <kxmlguiwindow.h>
#include "composertextedit.h"

#include <QTreeView>

class QTreeWidget;
class QTreeWidgetItem;
class QLabel;
class QSplitter;
class QPushButton;

class KJob;
class KAction;
class KToggleAction;
class KFileItem;
class KComboBox;
class KLineEdit;
#include <kmime/kmime_message.h>

namespace KPIMIdentities
{
class Identity;
class IdentityCombo;
}


namespace Mailody
{

using namespace KABC;

class AddressLineEdit;
class DataListView;
class ToolTip;
class SendMessage;
class MailodyBaseListView;
class AttachmentWidget;


/**
 * @class Composer
 * This is het main class for the composer...
 * @author Tom Albers <tomalbers@kde.nl>
 */
class Composer : public KXmlGuiWindow
{
    Q_OBJECT

public:
    /**
    * Contructor
    * @param mb the mailbox where the resulting message will be stored.
    * @param identity the identity to use
    */
    explicit Composer( QWidget* parent, const Akonadi::Collection& mb );

    /**
    * Destructor
    */
    ~Composer();

    /**
     * Call this to find out if the window is dirty
     */
    bool canClose();

    /**
     * You can use this enum for setRcpt, to set the type
     */
    enum TypeOfAddress {
        To = 1,
        Cc,
        Bcc
    };

    /**
     * add @p address to the composer
     */
    void setRcpt( const QString& address, TypeOfAddress addressType );

    /**
     * set @p identity as identity
     */
    void setIdentity( KPIMIdentities::Identity identity );

    /**
     * set @p subject to be the subject
     */
    void setSubject( const QString& subject );

    /**
     * set @p plain or @p html to be the message, after this call the cursor
     * will be set to the top of the text part, but only when there is
     * at least one recipient. @p sign indicates if you want to sign the
     * or not. Defaults to true (sign).
     *
     * Whether @p plain or @p html is used, depends on the seting of the composer.
     */
    void setMsg( const QString& plain, const QString& html = QString(), bool sign=true );

    /**
      * similar to above, but it will quoute the message, html and plain
      */
    void setMsgAndQuote( const QString& plain, const QString& html, bool sign=true );

    /**
     * add @p attachment to the message.
     */
    void addAttachment( const KUrl& attachment, const QString& name=QString() );

    /**
     * set a In-reply-to header with the value @p messageID
     */
    void inReplyTo( const QString& messageID );

    /**
     * add signature placeholder
     */
    void addSignaturePlaceholder( QString& );

    /**
     * set composer dirty or not. @p dirty
     */
    void setDirty( bool dirty=true );

protected:
    bool queryClose();

private:

    KAction                         *m_expandSig;
    KAction                         *m_sendmail;
    KAction                         *m_savemail;
    KToggleAction                   *m_htmlmode;
    KToolBar                        *m_textToolBar;
    KToggleAction                   *m_showIdentities;
    KToggleAction                   *m_showTransports;
    AddressLineEdit                 *m_edit;
    DataListView                    *m_addressbox;
    QTreeWidget                     *m_addressbook;
    MailodyBaseListView             *m_recentbook;
    QTreeWidgetItem                 *m_lastInserted;
    int                             m_lastState;
    QMap<QTreeWidgetItem*, QString> m_abMap;
    QSplitter*                      m_vsplitter;
    KLineEdit*                      m_subject;
    QString                         m_origSubject;
    ComposerTextEdit*               m_text;
    KMime::Message*                 m_main;
    QStringList                     m_tos;
    QPushButton*                    m_add;
    Akonadi::Collection             m_mailbox;
    QString                         m_replyTo;
    bool                            m_close;
    bool                            m_dirty;
    KABC::AddressBook*              m_ab;
    KPIMIdentities::IdentityCombo   *m_identityBox;
    QLabel                          *m_identitylabel;
    MailTransport::TransportComboBox *m_transportBox;
    QLabel                          *m_transportlabel;
    QTreeView*                      m_filebrowser;
    AttachmentWidget*               m_attachview;
    QLabel*                         m_alabel;
    ToolTip*                        m_tip;
    QTimer*                         m_timer;
    QTreeWidgetItem*                m_currentItem;

    const char * encoding( const QString& data );
    void addAddress( const QString& text );
    void showError( const QString& error );
    void addRecipients( SendMessage* msg );
    void placeSignature( QString& );

private slots:
    void slotStatusBarClicked( int item );
    void slotShiftAddress();
    void slotAddAddress( const QString& );
    void slotAddClicked();
    void slotContainsValidAddress( bool active );
    void slotAddFile( const QModelIndex & index );
    void slotAddFile( const KUrl& );
    void slotUpdateLineEdit();
    void slotEditAddress( QTreeWidgetItem*, int );
    void slotHTMLMode( bool );

    void slotSetAddress( const QString& address );
    void slotReplaceSignature( uint signWith );
    void slotExpandSignature();

    void slotAddAddressFromAddressBook( QTreeWidgetItem* );
    void slotLoadAddressBook();
    void slotLoadAddresses( AddressBook* ab );
    void slotContextMenuAddressBook();
    void slotContextMenuAddressList();

    void slotLoadRecentBook();
    void slotAddAddressFromRecentBook( QTreeWidgetItem* );
    void slotContextMenuRecentBook();
    void slotShowRecentDetailsDoIt();
    void slotShowRecentDetails( QTreeWidgetItem* );
    void slotHideRecentDetails( );

    void slotSetup();
    void slotSend();
    void slotSave();
    void slotDone();
    void slotDone( KJob* );
    void slotError( const QString& error );
    void slotSetDirty();
    void slotFixedFont( bool );
    void slotStatusChanged();
    void slotTransportChanged();
    void slotHideAttachmentWidget();
    void slotShowIdentities( bool );
    void slotShowTransports( bool );

signals:
    /**
    * Will be emitted when configure mailody is triggered from the composer.
    */
    void showSettings();

};

}

#endif // COMPOSER
