/* This file is part of the KDE project
   Copyright (C) 2006-2007 Omat Holding B.V. <info@omat.nl>
   Copyright (C) 2007 Frode M. Døving <frode@lnix.net>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

// Own
#include "global.h"

// Qt
#include <QSslSocket>

// KDE
#include <KGlobal>
#include <solid/networking.h>
#include <kpimidentities/identity.h>
#include <kpimidentities/identitymanager.h>

using namespace Mailody;

Global *Global::m_instance = 0;

Global::Global( QObject *parent, const char *name )
        : QObject( parent )
{
    setObjectName( name );
}

Global::~Global()
{}

Global* Global::instance()
{
    if ( !m_instance )
        m_instance = new Global();
    return m_instance;
}

bool Global::myEmail( const QString& email, bool refresh )
{
    static QStringList emails;
    if ( refresh || !emails.count() )
        emails = identityManager()->allEmails();

    QStringList::iterator its = emails.begin();
    while ( its != emails.end() ) {
        if ( email.indexOf( *its ) != -1 )
            return true;
        ++its;
    }

    return false;
}

const KPIMIdentities::Identity Global::getIdentityForEmail( const QString& email )
{
    return identityManager()->identityForAddress( email );
}

void Global::timing( const QString& text, struct timeval tv1, struct timeval tv2 )
{
    kDebug() << "Time: " << text + ": " << ((( tv2.tv_sec-tv1.tv_sec )*1000000 +
                                            ( tv2.tv_usec-tv1.tv_usec ) )/1000 ) << " ms";
}

QString Global::highlightText( const QString& text )
{
    // make the quotation colors.
    QStringList temp = text.split( "\n" );
    QString result;
    QStringList::iterator it = temp.begin();
    while ( it != temp.end() ) {
        result.append( highlightParagraph(( *it )+'\n' ) );
        ++it;
    }
    return result;
}

QString Global::highlightParagraph( const QString& text )
{
    bool found = false;
    QColor color;
    if ( text.startsWith( "&gt;&gt;&gt;&gt;" )
            || text.startsWith( "&gt; &gt; &gt; &gt;" )
            || text.startsWith( "||||" ) ) {
        found = true;
        color = Qt::darkGreen;
    } else if ( text.startsWith( "&gt;&gt;&gt;" ) || text.startsWith( "&gt; &gt; &gt;" )
                || text.startsWith( "|||" ) ) {
        found = true;
        color = Qt::darkRed;
    } else if ( text.startsWith( "&gt;&gt;" ) || text.startsWith( "&gt; &gt;" )
                || text.startsWith( "||" ) ) {
        found = true;
        color = Qt::blue;
    } else if ( text.startsWith( "&gt;" ) || text.startsWith( '|' ) ) {
        found = true;
        color = Qt::red;
    }

    if ( found )
        return "<font color=\""+color.name()+"\">"+text+"</font>";
    else
        return text;
}

bool Global::connectionPossible()
{
    return Solid::Networking::status()==Solid::Networking::Connected ||
           Solid::Networking::status()==Solid::Networking::Unknown;
}

// from kmail
KPIMIdentities::IdentityManager * Global::identityManager()
{
    static KPIMIdentities::IdentityManager *s_identityManager;
    if ( !s_identityManager ) {
        kDebug() << "instantating KPIMIdentities::IdentityManager";
        s_identityManager = new KPIMIdentities::IdentityManager( false, 0,
                "IdentityManager" );
    }
    return s_identityManager;
}

QString Global::quote( const QString &text, bool stripSig )
{
    // We only quote untill we match a "-- ". After that the code will buffer
    // the rest. If after the "-- " a ^> is matched, then the code is added
    // again. This should quote a complete message, with a reply and sig at top.
    bool includeMore = false;
    QString result, extraResult;
    QStringList list1 = text.split( "\n" );
    QStringList::Iterator it;

    // Maybe not very fast, but pretty stable and straightforward, non?
    for ( it = list1.begin(); it != list1.end(); it++ ) {
        QString single = *it;
        while ( single.length() > 80 ) {
            QString piece = single.mid( 0,80 );
            int amount = 0;

            // find the space, dot and comma.
            int dot = piece.lastIndexOf( "." );
            int comma = piece.lastIndexOf( "," );
            int space = piece.lastIndexOf( " " );
            amount = qMax( dot,comma );
            amount = qMax( amount, space );

            // if no dot, comma or space is found, wrap hard.
            if ( amount < 1 )
                amount = 80;

            includeMore ? extraResult += "> " + single.mid( 0,amount ) + '\n'
                                         : result += "> " + single.mid( 0,amount ) + '\n';

            single = single.mid( amount+1 );
        }

        if ( stripSig && single == "-- " )
            includeMore = true;

        if ( includeMore && single.startsWith( '>' ) ) {
            includeMore = false;
            result += extraResult;
        }

        includeMore ? extraResult += "> " + single + '\n'
                                     :  result += "> " + single + '\n';
    }
    return result;
}

#include "global.moc"
