/* This file is part of the KDE project

   Copyright (C) 2007-2008 Omat Holding B.V. <info@omat.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "headerdelegate.h"
#include "headerproxy.h"

#include <QModelIndex>
#include <QPainter>

#include <akonadi/kmime/messagemodel.h>
#include <akonadi/item.h>
#include <KDebug>

using namespace Mailody;

HeaderDelegate::HeaderDelegate( QWidget * parent )
        : QItemDelegate( parent )
{
}

void HeaderDelegate::paint( QPainter * painter,
                            const QStyleOptionViewItem & option,
                            const QModelIndex & index ) const
{
    QStyleOptionViewItem opt = option;
    painter->save();

    static const HeaderProxy* headerProxy =
        static_cast<const HeaderProxy*>( index.model() );
    static const Akonadi::MessageModel* messageModel =
        static_cast<const Akonadi::MessageModel*>( headerProxy->sourceModel() );
    Akonadi::Item item = messageModel->itemForIndex( headerProxy->mapToSource( index ) );

    Q_ASSERT( item.isValid() );

    if ( item.hasFlag( "$label1" ) ) {
        opt.palette.setColor( QPalette::HighlightedText, Qt::black );
        opt.palette.setColor( QPalette::Highlight, Qt::red );
        opt.palette.setColor( QPalette::Text, Qt::red );
    } else if ( item.hasFlag( "$label2" ) ) {
        opt.palette.setColor( QPalette::HighlightedText, Qt::white );
        opt.palette.setColor( QPalette::Highlight, QColor( 255,125,0 ) );
        opt.palette.setColor( QPalette::Text, QColor( 255,125,0 ) );
    } else if ( item.hasFlag( "$label3" ) ) {
        opt.palette.setColor( QPalette::HighlightedText, Qt::white );
        opt.palette.setColor( QPalette::Highlight, Qt::darkGreen );
        opt.palette.setColor( QPalette::Text, Qt::darkGreen );
    } else if ( item.hasFlag( "$label4" ) ) {
        opt.palette.setColor( QPalette::HighlightedText, Qt::white );
        opt.palette.setColor( QPalette::Highlight, Qt::darkBlue );
        opt.palette.setColor( QPalette::Text, Qt::darkBlue );
    } else if ( item.hasFlag( "$label5" ) ) {
        opt.palette.setColor( QPalette::HighlightedText, Qt::white );
        opt.palette.setColor( QPalette::Highlight, Qt::darkMagenta );
        opt.palette.setColor( QPalette::Text, Qt::darkMagenta );
    }

    if ( !item.hasFlag( "\\Seen" ) ) {
        opt.palette.setColor( QPalette::Text, Qt::red );
    } else if ( item.hasFlag( "\\Deleted" ) )
        opt.palette.setColor( QPalette::Text, Qt::darkGray );

    QItemDelegate::paint( painter, opt, index );

    if ( item.hasFlag( "\\Deleted" ) )
        painter->drawLine( opt.rect.left(), opt.rect.top()+opt.rect.height()/2,
                           opt.rect.right(), opt.rect.top()+opt.rect.height()/2 );

    painter->restore();
}
