/* This file is part of the KDE project

   Copyright (C) 2007-2008 Omat Holding B.V. <info@omat.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef HEADERPROXY_H
#define HEADERPROXY_H

#include <QHash>
#include <QSortFilterProxyModel>
#include <QStringList>

namespace Mailody
{

class HeaderProxy : public QSortFilterProxyModel
{
    Q_OBJECT

public:
    /** Constructor **/
    HeaderProxy( QObject * parent = 0 );

    /**
     * Call this to indicate if deleted messages should be shown or not.
     * It will update the view.
     */
    void setHideDeleted( bool hide );

    /**
     * Call this to indicate if messages should be sorted on the
     * youngest child or not.
     * It will update the view.
     */
    void setSortOnChild( bool sort );

protected:
    virtual QVariant data( const QModelIndex & index, int role = Qt::DisplayRole ) const;
    virtual bool filterAcceptsRow( int sourceRow,
                                   const QModelIndex & sourceParent ) const;
    virtual bool filterAcceptsColumn( int sourceCol,
                                      const QModelIndex & sourceParent ) const;

    virtual bool lessThan( const QModelIndex &left,
                           const QModelIndex &right ) const;

private:
    bool m_hideDeleted;
};

}

#endif
