/*
   Copyright (C) 2007 Omat Holding B.V. <info@omat.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/


#ifndef HEADERWIDGET_H
#define HEADERWIDGET_H

#include <QWidget>
#include <akonadi/item.h>

class QModelIndex;
class QSortFilterProxyModel;
class QTextEdit;
class KJob;

namespace Akonadi
{
class CollectionView;
class CollectionModel;
class CollectionFilterProxyModel;
class MessageThreaderProxyModel;
class MessageModel;
class Monitor;
} // namespace Akonadi

namespace Mailody
{

class HeaderModel;
class HeaderProxy;
class HeaderThreading;
class HeaderView;
class SearchLine;

/**
 * @class HeaderWidget
 * This is het main class for the header list.
 * @author Tom Albers <tomalbers@kde.nl>
 */
class HeaderWidget : public QWidget
{
    Q_OBJECT

public:
    /**
    * Contructor
    */
    explicit HeaderWidget( QWidget *parent=0 );

    /**
    * Destructor
    */
    ~HeaderWidget();

    HeaderView *view()  {
        return m_headerView;
    };
    Akonadi::MessageModel *messageModel() {
        return m_messageModel;
    };
    void setCollection( int id );
    void setSortOnChild( bool );
    void setHideDeleted( bool );

    QList< Akonadi::Item > currentlySelectedItems();

private slots:
    void itemActivated( const QModelIndex &index );
    void itemFetchDone( KJob *job );
    void slotItemChanged( const Akonadi::Item &item );

signals:
    void selectMessageLeft( const Akonadi::Item& );

private:
    Akonadi::MessageModel *m_messageModel;
    Akonadi::Monitor    *m_monitor;
    Akonadi::Item   m_requestedItem;
    HeaderModel     *m_headerModel;
    HeaderProxy     *m_headerProxy;
    HeaderThreading *m_headerThreading;
    HeaderView      *m_headerView;
    SearchLine      *m_searchLine;
};

}

#endif // HEADERWIDGET
