/* This file is part of the KDE project
   Copyright (C) 2006 Omat Holding B.V. <info@omat.nl>
   Copyright (C) 2007 Frode M. Døving <frode@lnix.net>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <stdio.h>
#include <stdlib.h>

#include <QDBusInterface>
#include <KStartupInfo>
#include <KDebug>
#include <KUniqueApplication>
#include <KCmdLineArgs>
#include <KAboutData>

#include "mainwindow.h"

/**
 * @class MailodyApplication
 * @author Tom Albers <tomalbers@kde.nl>
 * This class is a simple inheritance from KUniqueApplication
 * the reason that it is reimplemented is so mailto's will work
 * even when mailody is already running.
 */
class MailodyApplication : public KUniqueApplication
{
public:
    /**
     * Similar to KUniqueApplication::newInstance, only without
     * the call to raise the widget when a second instance is started.
     */
    int newInstance() {
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
        if ( args ) {
            bool send = false;
            QString sComposeArgs;
            QString sAttachArgs;
            QString sSubjectArgs;
            QString sBodyArgs;

            if ( args->isSet( "compose" ) ) {
                QStringList cArgLst = args->getOptionList( "compose" );
                if ( !cArgLst.empty() ) {
                    send = true;
                    for ( QStringList::Iterator ite = cArgLst.begin();
                            ite != cArgLst.end();
                            ++ite )
                        if ( !( *ite ).isEmpty() )
                            sComposeArgs.append( *ite + ',' );
                }
                kDebug() << "sComposeArgs: " << sComposeArgs << endl;
            }

            if ( args->isSet( "attach" ) ) {
                QStringList aArgLst = args->getOptionList( "attach" );
                if ( !aArgLst.isEmpty() ) {
                    send = true;
                    for ( QStringList::Iterator ite = aArgLst.begin();
                            ite != aArgLst.end();
                            ++ite )
                        if ( !( *ite ).isEmpty() )
                            sAttachArgs.append( *ite + ";;" );
                }
                kDebug() << "sAttachArgs: " << sAttachArgs << endl;
            }

            if ( args->isSet( "subject" ) ) {
                sSubjectArgs = args->getOption( "subject" );
                send = true;
            }

            if ( args->isSet( "body" ) ) {
                sBodyArgs = args->getOption( "body" );
                send = true;
            }

            if ( send ) {
                QDBusInterface dbus( "net.mailody.mailody", "/mailody",
                                     "net.mailody.mainwindow" );
                dbus.call( "slotOpenComposer", sComposeArgs, sAttachArgs, sSubjectArgs, sBodyArgs );
            }

            for ( int i=0; i < args->count(); i++ ) {
                QString ar = args->arg( i );
                kDebug() << "Found: " << ar << endl;
                if ( ar.startsWith( "mailto:" ) || ar.contains( "@" ) == 1 ) {
                    QDBusInterface dbus( "net.mailody.mailody", "/mailody",
                                         "net.mailody.mainwindow" );
                    dbus.call( "slotOpenComposer", ar );
                }
            }
        }
        return  KUniqueApplication::newInstance();;
    }
};

int main( int argc, char *argv[] )
{

//    KComponentData *mailodyComponentData=new KComponentData( "mailody" );
    KAboutData aboutData( "mailody", 0,
                          ki18n( "Mailody" ),
                          "1.5.0-alfa1",
                          ki18n( "An IMAP Mail Client" ),
                          KAboutData::License_GPL,
                          ki18n( "(c) 2006-2008 Omat Holding B.V. & Frode M. Døving" ),
                          KLocalizedString(),
                          "http://www.mailody.net" );

    aboutData.addAuthor( ki18n( "Tom Albers" ), ki18n( "Maintainer and author" ),
                         "tomalbers@kde.nl", "http://www.omat.nl" );
    aboutData.addAuthor( ki18n( "Frode M. Døving" ),  ki18n( "Author" ),
                         "frode@lnix.net" );
    aboutData.addCredit( ki18n( "Marijke Verkaik" ), ki18n( "Website and icons" ),
                         "internet@omat.nl" );
    aboutData.addCredit( ki18n( "Lee Olson" ), ki18n( "Logo" ),
                         "clearbeast@gmail.com" );
    aboutData.addCredit( ki18n( "Maxilys and Kolum" ),
                         ki18n( "Idea to call this application Mailody" ) );

    KCmdLineArgs::init( argc, argv, &aboutData );

    KCmdLineOptions cmdline;
    cmdline.add( "compose <email>", ki18n( "Open a composer with <email> as recipient" ) );
    cmdline.add( "attach <file>", ki18n( "Open a composer with <file> attached" ) );
    cmdline.add( "subject <subject>", ki18n( "Open a composer with the subject <subject>" ) );
    cmdline.add( "body <body>", ki18n( "Open a composer with <body>" ) );
    KCmdLineArgs::addCmdLineOptions( cmdline );
    KCmdLineArgs::addStdCmdLineOptions();


    if ( !KUniqueApplication::start() ) {
        KStartupInfo::handleAutoAppStartedSending();
        fprintf( stderr, "Mailody is already running!\n" );
        exit( 0 );
    }

    MailodyApplication app;
    Mailody::MainWindow* mailody = new Mailody::MainWindow();
    mailody->show();
    return app.exec();
}
