/* This file is part of the KDE project
   Copyright (C) 2006-2007 Omat Holding B.V. <info@omat.nl>
   Copyright (C) 2006-2008 Frode M. Døving <frode@lnix.net>

   Original copied from showfoto:
    Copyright 2005 by Gilles Caulier <caulier.gilles@free.fr>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

// Own
#include "setupmisc.h"

// Qt
#include <QGridLayout>
#include <QGroupBox>
#include <QLabel>
#include <QPushButton>
#include <QCheckBox>

// KDE
#include <KConfigGroup>
#include <KFileDialog>
#include <KGlobal>
#include <KHBox>
#include <KLocale>
#include <KTabWidget>

using namespace Mailody;

SetupMisc::SetupMisc( QWidget* parent )
        : QWidget( parent )
{
    QGridLayout *mainGrid = new QGridLayout( this );

    KTabWidget* tabWidget = new KTabWidget( this );
    mainGrid->addWidget( tabWidget, 0, 0 );
    mainGrid->setRowStretch( 0, 0 );

    // ------------- page 1 -------------------------- //

    QWidget* page1 = new QWidget( this );
    QGridLayout* m1 = new QGridLayout( page1 );

    QLabel *l3 = new QLabel( i18n( "Favorite website:" ) + ' ', page1 );
    m1->addWidget( l3, 0, 0 );
    l3->setAlignment( Qt::AlignRight | Qt::AlignVCenter );
    l3->setWhatsThis( i18n( "Indicate your favorite website" ) );
    m_homePage = new KLineEdit( page1 );
    m1->addWidget( m_homePage, 0, 1 );
    l3->setBuddy( m_homePage );

    m_storeAttachments = new QGroupBox( i18n( "Store all attachments in a folder" ), page1 );
    m_storeAttachments->setCheckable( true );
    m_storeAttachments->setChecked( false );
    m_storeAttachments->setWhatsThis(
        i18n( "Mailody can store all attchements of all messages in a certain folder. "
              "Then you never have to save it from the messages, it is simply in that folder. "
              "Please note that you need to clear that folder now and then, else your system may "
              "run out of space some day" ) );

    m_attachmentFolderEdit = new KLineEdit( this );
    m_attachmentFolderEdit->setWhatsThis(
        i18n( "Select the folder where the attachements will be stored." ) );
    m_changePathButton = new QPushButton( i18n( "&Change..." ), this );

    QHBoxLayout *lay = new QHBoxLayout( this );
    lay->addWidget( m_attachmentFolderEdit );
    lay->addWidget( m_changePathButton );

    m_storeAttachments->setLayout( lay );
    connect( m_changePathButton, SIGNAL( clicked() ),
             this, SLOT( slotFolderPicker() ) );
    m1->addWidget( m_storeAttachments, 1, 0, 1, 2 );

    QSpacerItem* spacer1 = new QSpacerItem( 10,10, QSizePolicy::Minimum,
                                            QSizePolicy::Expanding );
    m1->addItem( spacer1, 3, 0 );

    m_autoHideTabbar = new QCheckBox( this );
    m_autoHideTabbar->setText( i18n( "Autohide tabbar" ) );
    m_autoHideTabbar->setWhatsThis(
        i18n( "When enabled this feature will automatically hide "
              "the tab bar when there is only one tab. Usefull if you rarely use tabs."
            ) );
    m1->addWidget( m_autoHideTabbar, 2, 0 );

    m_showSmileys = new QCheckBox( this );
    m_showSmileys->setText( i18n( "Display pretty smileys" ) );
    m_showSmileys->setWhatsThis(
        i18n( "When enabled this feature will automatically show "
              "smileys as images in mails, if not checked they remain text."
            ) );
    m1->addWidget( m_showSmileys, 3, 0 );

    tabWidget->addTab( page1,i18n( "Misc." ) );
    readSettings();
}

SetupMisc::~SetupMisc()
{
}

void SetupMisc::applySettings()
{
    KConfigGroup config = KGlobal::config()->group( "General" );
    QString hp = m_homePage->text();
    if ( !hp.startsWith( "http://" ) && !hp.isEmpty() )
        hp = "http://" + hp;
    config.writeEntry( "homePage", hp );
    config.writeEntry( "storeAllAttachments", m_storeAttachments->isChecked() );
    config.writeEntry( "attachmentsFolder", m_attachmentFolderEdit->text() );
    config.writeEntry( "AutoHideTabbar", m_autoHideTabbar->isChecked() );
    config.writeEntry( "ShowSmileys", m_showSmileys->isChecked() );
    config.sync();
}

void SetupMisc::readSettings()
{
    KConfigGroup config = KGlobal::config()->group( "General" );
    m_homePage->setText( config.readEntry( "homePage", "http://www.mailody.net" ) );
    m_storeAttachments->setChecked( config.readEntry( "storeAllAttachments", false ) );
    m_attachmentFolderEdit->setText( config.readEntry( "attachmentsFolder" ) );
    m_autoHideTabbar->setChecked( config.readEntry( "AutoHideTabbar", false ) );
    m_showSmileys->setChecked( config.readEntry( "ShowSmileys", false ) );
}

void SetupMisc::slotFolderPicker()
{
    QString result =
        KFileDialog::getExistingDirectory( m_attachmentFolderEdit->text(), this );

    if ( !result.isEmpty() )
        m_attachmentFolderEdit->setText( result );
}

#include <setupmisc.moc>
