/* This file is part of the KDE project
   Copyright (C) 2006-2007 Omat Holding B.V. <info@omat.nl>

   Original copied from showfoto:
    Copyright 2005 by Gilles Caulier <caulier.gilles@free.fr>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef SETUPMISC_H
#define SETUPMISC_H

#include <klineedit.h>

class QGroupBox;
class QPushButton;
class QCheckBox;

namespace Mailody
{

/**
 * @class SetupMisc
 * These contain the misc settings
 * @author Tom Albers <tomalbers@kde.nl>
 */
class SetupMisc : public QWidget
{
    Q_OBJECT
public:
    /**
     * Constructor
     * @param parent Parent Widget
     */
    SetupMisc( QWidget* parent = 0 );

    /**
     * Destructor
     */
    ~SetupMisc();

    /**
     * Call this if you want the settings saved from this page.
     */
    void applySettings();

private:
    void readSettings();
    KLineEdit           *m_homePage;
    KLineEdit           *m_attachmentFolderEdit;
    QPushButton         *m_changePathButton;
    QGroupBox           *m_storeAttachments;
    QCheckBox           *m_autoHideTabbar;
    QCheckBox           *m_showSmileys;

private slots:
    void slotFolderPicker();
};

}

#endif
