/* This file is part of the KDE project

   Copyright (C) 2008 Omat Holding B.V. <info@omat.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "tabwidget.h"
#include "messageview.h"

#include <KDebug>

#include <QMenu>
#include <QToolButton>

using namespace Mailody;

TabWidget::TabWidget( QWidget *parent )
        : KTabWidget( parent )
{
    setTabPosition( QTabWidget::North );
    setTabReorderingEnabled( true );
    setAutomaticResizeTabs( true );
    setTabCloseActivatePrevious( true );

    QToolButton *button = new QToolButton( this );
    button->setIcon( KIcon( "tab-new" ) );
    button->adjustSize();
    setCornerWidget( button, Qt::TopLeftCorner );
    connect( button, SIGNAL( clicked() ), SIGNAL( clicked() ) );

    m_closeButton = new QToolButton( this );
    m_closeButton->setIcon( KIcon( "tab-close" ) );
    m_closeButton->adjustSize();
    m_closeButton->setEnabled( false );
    setCornerWidget( m_closeButton, Qt::TopRightCorner );
    connect( m_closeButton, SIGNAL( clicked() ), SLOT( slotDeleteCurrentWidget() ) );

    KConfigGroup configGeneral = KGlobal::config()->group( "General" );
    if ( configGeneral.readEntry( "AutoHideTabbar", false ) ) {
        setTabBarHidden( true );
    }
}

void TabWidget::addMessageTab( TotalView *widget, const QString &text )
{
    addTab( widget, text, Message );
}

void TabWidget::addBrowserTab( TotalView *widget, const QString &text )
{
    addTab( widget, text, Browser );
}

void TabWidget::addTab( QWidget *widget, const QString &text, Type type )
{
    int index = KTabWidget::addTab( widget, text );
    setCurrentIndex( index );
    m_tabTypes.insert( index, type );

    if ( count() > 1 ) {
        m_closeButton->setEnabled( true );
        setTabBarHidden( false );
    }
}

void TabWidget::slotDeleteCurrentWidget()
{
    slotDeleteWidget( currentWidget() );
}

void TabWidget::slotDeleteWidget( QWidget *widget )
{
    int id = indexOf( widget );
    m_tabTypes.remove( id );

    blockSignals( true );
    if ( count() != 1 )
        delete widget;
    blockSignals( false );

    if ( count() == 1 ) {
        m_closeButton->setEnabled( false );
        KConfigGroup configAHT = KGlobal::config()->group( "General" );
        if ( configAHT.readEntry( "AutoHideTabbar",false ) ) {
            setTabBarHidden( true );
        }
    }
}

bool TabWidget::currentTabType( Type widgetType )
{
    int id = currentIndex();
    return m_tabTypes.value( id ) == widgetType;
}

void TabWidget::setCurrentTabType( Type widgetType )
{
    m_tabTypes[ currentIndex()] = widgetType;
}

TotalView* TabWidget::tabWidget( int i )
{
    return static_cast<TotalView*>( widget( i ) );
}

TotalView* TabWidget::currentTabWidget()
{
    return static_cast<TotalView*>( currentWidget() );
}

#include "tabwidget.moc"
