/*
 *  The ManaPlus Client
 *  Copyright (C) 2007  Joshua Langley <joshlangley@optusnet.com.au>
 *  Copyright (C) 2009-2010  The Mana Developers
 *  Copyright (C) 2011-2014  The ManaPlus Developers
 *
 *  This file is part of The ManaPlus Client.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef INPUT_INPUTACTIONMAP_H
#define INPUT_INPUTACTIONMAP_H

#include "actionmanager.h"
#include "sdlshared.h"

#include "input/inputaction.h"
#include "input/inputactiondata.h"
#include "input/inputcondition.h"
#include "input/inputmanager.h"
#include "input/inputtype.h"

#include "utils/gettext.h"

#include <string>

#include "localconsts.h"

// keyData must be in same order as enum keyAction.
static const InputActionData inputActionData[InputAction::TOTAL] = {
    {"keyMoveUp",
        InputType::KEYBOARD, SDLK_UP,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::moveUp,
        InputAction::NO_VALUE, 50,
        InputCondition::ARROWKEYS},
    {"keyMoveDown",
        InputType::KEYBOARD, SDLK_DOWN,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::moveDown,
        InputAction::NO_VALUE, 50,
        InputCondition::ARROWKEYS},
    {"keyMoveLeft",
        InputType::KEYBOARD, SDLK_LEFT,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::moveLeft,
        InputAction::NO_VALUE, 50,
        InputCondition::ARROWKEYS},
    {"keyMoveRight",
        InputType::KEYBOARD, SDLK_RIGHT,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::moveRight,
        InputAction::NO_VALUE, 50,
        InputCondition::ARROWKEYS},
    {"keyAttack",
        InputType::KEYBOARD, SDLK_x,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_REPEAT,
        &ActionManager::attack,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOFOLLOW
            | InputCondition::VALIDSPEED},
    {"keyTargetAttack",
        InputType::KEYBOARD, SDLK_LCTRL,
        InputType::JOYSTICK, 0,
        Input::GRP_DEFAULT,
        &ActionManager::targetAttack,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOFOLLOW
            | InputCondition::VALIDSPEED},
    {"keyMoveToTarget",
        InputType::KEYBOARD, SDLK_v,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::moveToTarget,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED},
    {"keyChangeMoveToTarget",
        InputType::KEYBOARD, SDLK_PERIOD,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::changeMoveToTarget,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED
            | InputCondition::EMODS},
    {"keyMoveToHome",
        InputType::KEYBOARD, SDLK_d,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::moveToHome,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED},
    {"keySetHome",
        InputType::KEYBOARD, SDLK_KP5,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::setHome,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED},
    {"keyMoveToPoint",
        InputType::KEYBOARD, SDLK_RSHIFT,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT | InputCondition::INGAME},
    {"keyTalk",
        InputType::KEYBOARD, SDLK_t,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::talk,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME},
    {"keyTarget",
        InputType::KEYBOARD, SDLK_LSHIFT,
        InputType::JOYSTICK, 4,
        Input::GRP_DEFAULT,
        &ActionManager::stopAttack,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME},
    {"keyUnTarget",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::untarget,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME},
    {"keyTargetMonster",
        InputType::KEYBOARD, SDLK_a,
        InputType::JOYSTICK, 3,
        Input::GRP_DEFAULT | Input::GRP_REPEAT,
        &ActionManager::targetMonster,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET
            | InputCondition::VALIDSPEED},
    {"keyTargetNPC",
        InputType::KEYBOARD, SDLK_n,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::targetNPC,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET},
    {"keyTargetPlayer",
        InputType::KEYBOARD, SDLK_q,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::targetPlayer,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET},
    {"keyPickup",
        InputType::KEYBOARD, SDLK_z,
        InputType::JOYSTICK, 1,
        Input::GRP_DEFAULT,
        &ActionManager::pickup,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET},
    {"keyChangePickupType",
        InputType::KEYBOARD, SDLK_o,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::changePickupType,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED
            | InputCondition::EMODS},
    {"keyHideWindows",
        InputType::KEYBOARD, SDLK_h,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::hideWindows,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET},
    {"keyBeingSit",
        InputType::KEYBOARD, SDLK_s,
        InputType::JOYSTICK, 2,
        Input::GRP_DEFAULT,
        &ActionManager::sit,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET},
    {"keyScreenshot",
        InputType::KEYBOARD, SDLK_p,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::screenshot,
        InputAction::NO_VALUE, 50,
        InputCondition::NOTARGET | InputCondition::NOINPUT},
    {"keyTrade",
        InputType::KEYBOARD, SDLK_r,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::changeTrade,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET},
    {"keyPathfind",
        InputType::KEYBOARD, SDLK_f,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::changeMapMode,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET
            | InputCondition::EMODS},
    {"keyOK",
        InputType::KEYBOARD, SDLK_SPACE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::ok,
        InputAction::NO_VALUE, 50,
        InputCondition::NOMODAL | InputCondition::NOAWAY
            | InputCondition::NONPCINPUT},
    {"keyQuit",
        InputType::KEYBOARD, SDLK_ESCAPE,
#if defined(USE_SDL2) && defined(ANDROID)
        InputType::KEYBOARD, SDLK_AC_BACK,
#else
        InputType::UNKNOWN, InputAction::NO_VALUE,
#endif
        Input::GRP_DEFAULT,
        &ActionManager::quit,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyShortcutsKey",
        InputType::KEYBOARD, SDLK_MENU,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT | InputCondition::INGAME},
    {"keyShortcut1",
        InputType::KEYBOARD, SDLK_1,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT},
    {"keyShortcut2",
        InputType::KEYBOARD, SDLK_2,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT},
    {"keyShortcut3",
        InputType::KEYBOARD, SDLK_3,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT},
    {"keyShortcut4",
        InputType::KEYBOARD, SDLK_4,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT},
    {"keyShortcut5",
        InputType::KEYBOARD, SDLK_5,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT},
    {"keyShortcut6",
        InputType::KEYBOARD, SDLK_6,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT},
    {"keyShortcut7",
        InputType::KEYBOARD, SDLK_7,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT},
    {"keyShortcut8",
        InputType::KEYBOARD, SDLK_8,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT},
    {"keyShortcut9",
        InputType::KEYBOARD, SDLK_9,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT},
    {"keyShortcut10",
        InputType::KEYBOARD, SDLK_0,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT},
    {"keyShortcut11",
        InputType::KEYBOARD, SDLK_MINUS,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT},
    {"keyShortcut12",
        InputType::KEYBOARD, SDLK_EQUALS,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT},
    {"keyShortcut13",
        InputType::KEYBOARD, SDLK_BACKSPACE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT},
    {"keyShortcut14",
        InputType::KEYBOARD, SDLK_INSERT,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT},
    {"keyShortcut15",
        InputType::KEYBOARD, SDLK_HOME,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT},
    {"keyShortcut16",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT},
    {"keyShortcut17",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT},
    {"keyShortcut18",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT},
    {"keyShortcut19",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT},
    {"keyShortcut20",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT},
    {"keyWindowHelp",
        InputType::KEYBOARD, SDLK_F1,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::helpWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT0},
    {"keyWindowStatus",
        InputType::KEYBOARD, SDLK_F2,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::statusWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET},
    {"keyWindowInventory",
        InputType::KEYBOARD, SDLK_F3,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::inventoryWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET},
    {"keyWindowEquipment",
        InputType::KEYBOARD, SDLK_F4,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::equipmentWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET},
    {"keyWindowSkill",
        InputType::KEYBOARD, SDLK_F5,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::skillDialogShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET},
    {"keyWindowMinimap",
        InputType::KEYBOARD, SDLK_F6,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::minimapWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET},
    {"keyWindowChat",
        InputType::KEYBOARD, SDLK_F7,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::chatWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET},
    {"keyWindowShortcut",
        InputType::KEYBOARD, SDLK_F8,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::shortcutWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET},
    {"keyWindowSetup",
        InputType::KEYBOARD, SDLK_F9,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::setupWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::NOTARGET | InputCondition::NOINPUT
            | InputCondition::ENABLED},
    {"keyWindowDebug",
        InputType::KEYBOARD, SDLK_F10,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::debugWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET},
    {"keyWindowSocial",
        InputType::KEYBOARD, SDLK_F11,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::socialWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET},
    {"keyWindowEmoteBar",
        InputType::KEYBOARD, SDLK_F12,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::emoteShortcutWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET},
    {"keyWindowOutfit",
        InputType::KEYBOARD, SDLK_BACKQUOTE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::outfitWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET},
    {"keyWindowShop",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::shopWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET},
    {"keyWindowDrop",
        InputType::KEYBOARD, SDLK_w,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::dropShortcutWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET},
    {"keyWindowKills",
        InputType::KEYBOARD, SDLK_e,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::killStatsWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET},
    {"keyWindowSpells",
        InputType::KEYBOARD, SDLK_j,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::spellShortcutWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET},
    {"keyWindowBotChecker",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::botcheckerWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET},
    {"keyWindowOnline",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::whoIsOnlineWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET},
    {"keyWindowDidYouKnow",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::didYouKnowWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT0},
    {"keyWindowQuests",
        InputType::KEYBOARD, SDLK_LEFTBRACKET,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::questsWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET},
    {"keySocialPrevTab",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::prevSocialTab,
        InputAction::NO_VALUE, 50,
        InputCondition::NOINPUT | InputCondition::INGAME},
    {"keySocialNextTab",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::nextSocialTab,
        InputAction::NO_VALUE, 50,
        InputCondition::NOINPUT | InputCondition::INGAME},
    {"keySmilie",
        InputType::KEYBOARD, SDLK_LALT,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT | InputCondition::INGAME},
    {"keyEmoteShortcut1",
        InputType::KEYBOARD, SDLK_1,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut2",
        InputType::KEYBOARD, SDLK_2,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut3",
        InputType::KEYBOARD, SDLK_3,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut4",
        InputType::KEYBOARD, SDLK_4,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut5",
        InputType::KEYBOARD, SDLK_5,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut6",
        InputType::KEYBOARD, SDLK_6,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut7",
        InputType::KEYBOARD, SDLK_7,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut8",
        InputType::KEYBOARD, SDLK_8,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut9",
        InputType::KEYBOARD, SDLK_9,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut10",
        InputType::KEYBOARD, SDLK_0,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut11",
        InputType::KEYBOARD, SDLK_MINUS,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut12",
        InputType::KEYBOARD, SDLK_EQUALS,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut13",
        InputType::KEYBOARD, SDLK_BACKSPACE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut14",
        InputType::KEYBOARD, SDLK_INSERT,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut15",
        InputType::KEYBOARD, SDLK_HOME,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut16",
        InputType::KEYBOARD, SDLK_q,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut17",
        InputType::KEYBOARD, SDLK_w,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut18",
        InputType::KEYBOARD, SDLK_e,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut19",
        InputType::KEYBOARD, SDLK_r,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut20",
        InputType::KEYBOARD, SDLK_t,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut21",
        InputType::KEYBOARD, SDLK_y,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut22",
        InputType::KEYBOARD, SDLK_u,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut23",
        InputType::KEYBOARD, SDLK_i,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut24",
        InputType::KEYBOARD, SDLK_o,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut25",
        InputType::KEYBOARD, SDLK_p,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut26",
        InputType::KEYBOARD, SDLK_LEFTBRACKET,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut27",
        InputType::KEYBOARD, SDLK_RIGHTBRACKET,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut28",
        InputType::KEYBOARD, SDLK_BACKSLASH,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut29",
        InputType::KEYBOARD, SDLK_a,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut30",
        InputType::KEYBOARD, SDLK_s,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut31",
        InputType::KEYBOARD, SDLK_d,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut32",
        InputType::KEYBOARD, SDLK_f,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut33",
        InputType::KEYBOARD, SDLK_g,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut34",
        InputType::KEYBOARD, SDLK_h,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut35",
        InputType::KEYBOARD, SDLK_j,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut36",
        InputType::KEYBOARD, SDLK_k,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut37",
        InputType::KEYBOARD, SDLK_l,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut38",
        InputType::KEYBOARD, SDLK_SEMICOLON,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut39",
        InputType::KEYBOARD, SDLK_QUOTE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut40",
        InputType::KEYBOARD, SDLK_z,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut41",
        InputType::KEYBOARD, SDLK_x,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut42",
        InputType::KEYBOARD, SDLK_c,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut43",
        InputType::KEYBOARD, SDLK_v,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut44",
        InputType::KEYBOARD, SDLK_b,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut45",
        InputType::KEYBOARD, SDLK_n,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut46",
        InputType::KEYBOARD, SDLK_m,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut47",
        InputType::KEYBOARD, SDLK_COMMA,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyEmoteShortcut48",
        InputType::KEYBOARD, SDLK_PERIOD,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME},
    {"keyWearOutfit",
        InputType::KEYBOARD, SDLK_RCTRL,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT | InputCondition::INGAME},
    {"keyCopyOutfit",
        InputType::KEYBOARD, SDLK_RALT,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT | InputCondition::INGAME},
    {"keyCopyEquipedOutfit",
        InputType::KEYBOARD, SDLK_RIGHTBRACKET,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::copyEquippedToOutfit,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED},
    {"keyOutfitShortcut1",
        InputType::KEYBOARD, SDLK_1,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut2",
        InputType::KEYBOARD, SDLK_2,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut3",
        InputType::KEYBOARD, SDLK_3,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut4",
        InputType::KEYBOARD, SDLK_4,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut5",
        InputType::KEYBOARD, SDLK_5,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut6",
        InputType::KEYBOARD, SDLK_6,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut7",
        InputType::KEYBOARD, SDLK_7,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut8",
        InputType::KEYBOARD, SDLK_8,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut9",
        InputType::KEYBOARD, SDLK_9,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut10",
        InputType::KEYBOARD, SDLK_0,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut11",
        InputType::KEYBOARD, SDLK_MINUS,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut12",
        InputType::KEYBOARD, SDLK_EQUALS,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut13",
        InputType::KEYBOARD, SDLK_BACKSPACE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut14",
        InputType::KEYBOARD, SDLK_INSERT,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut15",
        InputType::KEYBOARD, SDLK_HOME,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut16",
        InputType::KEYBOARD, SDLK_q,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut17",
        InputType::KEYBOARD, SDLK_w,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut18",
        InputType::KEYBOARD, SDLK_e,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut19",
        InputType::KEYBOARD, SDLK_r,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut20",
        InputType::KEYBOARD, SDLK_t,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut21",
        InputType::KEYBOARD, SDLK_y,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut22",
        InputType::KEYBOARD, SDLK_u,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut23",
        InputType::KEYBOARD, SDLK_i,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut24",
        InputType::KEYBOARD, SDLK_o,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut25",
        InputType::KEYBOARD, SDLK_p,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut26",
        InputType::KEYBOARD, SDLK_LEFTBRACKET,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut27",
        InputType::KEYBOARD, SDLK_RIGHTBRACKET,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut28",
        InputType::KEYBOARD, SDLK_BACKSLASH,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut29",
        InputType::KEYBOARD, SDLK_a,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut30",
        InputType::KEYBOARD, SDLK_s,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut31",
        InputType::KEYBOARD, SDLK_d,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut32",
        InputType::KEYBOARD, SDLK_f,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut33",
        InputType::KEYBOARD, SDLK_g,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut34",
        InputType::KEYBOARD, SDLK_h,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut35",
        InputType::KEYBOARD, SDLK_j,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut36",
        InputType::KEYBOARD, SDLK_k,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut37",
        InputType::KEYBOARD, SDLK_l,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut38",
        InputType::KEYBOARD, SDLK_SEMICOLON,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut39",
        InputType::KEYBOARD, SDLK_QUOTE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut40",
        InputType::KEYBOARD, SDLK_z,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut41",
        InputType::KEYBOARD, SDLK_x,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut42",
        InputType::KEYBOARD, SDLK_c,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut43",
        InputType::KEYBOARD, SDLK_v,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut44",
        InputType::KEYBOARD, SDLK_b,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut45",
        InputType::KEYBOARD, SDLK_n,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut46",
        InputType::KEYBOARD, SDLK_m,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut47",
        InputType::KEYBOARD, SDLK_COMMA,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyOutfitShortcut48",
        InputType::KEYBOARD, SDLK_PERIOD,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut1",
        InputType::KEYBOARD, SDLK_1,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut2",
        InputType::KEYBOARD, SDLK_2,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut3",
        InputType::KEYBOARD, SDLK_3,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut4",
        InputType::KEYBOARD, SDLK_4,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut5",
        InputType::KEYBOARD, SDLK_5,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut6",
        InputType::KEYBOARD, SDLK_6,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut7",
        InputType::KEYBOARD, SDLK_7,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut8",
        InputType::KEYBOARD, SDLK_8,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut9",
        InputType::KEYBOARD, SDLK_9,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut10",
        InputType::KEYBOARD, SDLK_0,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut11",
        InputType::KEYBOARD, SDLK_MINUS,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut12",
        InputType::KEYBOARD, SDLK_EQUALS,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut13",
        InputType::KEYBOARD, SDLK_BACKSPACE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut14",
        InputType::KEYBOARD, SDLK_INSERT,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut15",
        InputType::KEYBOARD, SDLK_HOME,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut16",
        InputType::KEYBOARD, SDLK_q,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut17",
        InputType::KEYBOARD, SDLK_w,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut18",
        InputType::KEYBOARD, SDLK_e,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut19",
        InputType::KEYBOARD, SDLK_r,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut20",
        InputType::KEYBOARD, SDLK_t,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut21",
        InputType::KEYBOARD, SDLK_y,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut22",
        InputType::KEYBOARD, SDLK_u,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut23",
        InputType::KEYBOARD, SDLK_i,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut24",
        InputType::KEYBOARD, SDLK_o,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut25",
        InputType::KEYBOARD, SDLK_p,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut26",
        InputType::KEYBOARD, SDLK_LEFTBRACKET,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut27",
        InputType::KEYBOARD, SDLK_RIGHTBRACKET,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut28",
        InputType::KEYBOARD, SDLK_BACKSLASH,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut29",
        InputType::KEYBOARD, SDLK_a,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut30",
        InputType::KEYBOARD, SDLK_s,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut31",
        InputType::KEYBOARD, SDLK_d,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut32",
        InputType::KEYBOARD, SDLK_f,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut33",
        InputType::KEYBOARD, SDLK_g,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut34",
        InputType::KEYBOARD, SDLK_h,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut35",
        InputType::KEYBOARD, SDLK_j,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut36",
        InputType::KEYBOARD, SDLK_k,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut37",
        InputType::KEYBOARD, SDLK_l,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut38",
        InputType::KEYBOARD, SDLK_SEMICOLON,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut39",
        InputType::KEYBOARD, SDLK_QUOTE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut40",
        InputType::KEYBOARD, SDLK_z,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut41",
        InputType::KEYBOARD, SDLK_x,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut42",
        InputType::KEYBOARD, SDLK_c,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut43",
        InputType::KEYBOARD, SDLK_v,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut44",
        InputType::KEYBOARD, SDLK_b,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut45",
        InputType::KEYBOARD, SDLK_n,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut46",
        InputType::KEYBOARD, SDLK_m,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut47",
        InputType::KEYBOARD, SDLK_COMMA,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyMoveToPointShortcut48",
        InputType::KEYBOARD, SDLK_PERIOD,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME},
    {"keyChat",
        InputType::KEYBOARD, SDLK_RETURN,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_CHAT,
        &ActionManager::toggleChat,
        InputAction::NO_VALUE, 50,
        InputCondition::NOINPUT | InputCondition::NOAWAY
            | InputCondition::NOMODAL | InputCondition::INGAME},
    {"keyChatScrollUp",
        InputType::KEYBOARD, SDLK_PAGEUP,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::scrollChatUp,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT | InputCondition::INGAME},
    {"keyChatScrollDown",
        InputType::KEYBOARD, SDLK_PAGEDOWN,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::scrollChatDown,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT | InputCondition::INGAME},
    {"keyChatPrevTab",
        InputType::KEYBOARD, SDLK_KP7,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::prevChatTab,
        InputAction::NO_VALUE, 50,
        InputCondition::NOINPUT | InputCondition::INGAME},
    {"keyChatNextTab",
        InputType::KEYBOARD, SDLK_KP9,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::nextChatTab,
        InputAction::NO_VALUE, 50,
        InputCondition::NOINPUT | InputCondition::INGAME},
    {"keyChatCloseTab",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::closeChatTab,
        InputAction::NO_VALUE, 50,
        InputCondition::NOINPUT | InputCondition::INGAME},
    {"keyChatPrevHistory",
        InputType::KEYBOARD, SDLK_KP7,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_CHAT | Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT | InputCondition::INGAME},
    {"keyChatNextHistory",
        InputType::KEYBOARD, SDLK_KP9,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_CHAT | Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT | InputCondition::INGAME},
    {"keyIgnoreInput1",
#ifdef USE_SDL2
        InputType::UNKNOWN, InputAction::NO_VALUE,
#else
        InputType::KEYBOARD, SDLK_LSUPER,
#endif
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::ignoreInput,
        InputAction::NO_VALUE, 500,
        InputCondition::DEFAULT},
    {"keyIgnoreInput2",
#ifdef USE_SDL2
        InputType::UNKNOWN, InputAction::NO_VALUE,
#else
        InputType::KEYBOARD, SDLK_RSUPER,
#endif
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::ignoreInput,
        InputAction::NO_VALUE, 500,
        InputCondition::DEFAULT},
    {"keyDirectUp",
        InputType::KEYBOARD, SDLK_l,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::directUp,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME},
    {"keyDirectDown",
        InputType::KEYBOARD, SDLK_SEMICOLON,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::directDown,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME},
    {"keyDirectLeft",
        InputType::KEYBOARD, SDLK_k,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::directLeft,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME},
    {"keyDirectRight",
        InputType::KEYBOARD, SDLK_QUOTE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::directRight,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME},
    {"keyCrazyMoves",
        InputType::KEYBOARD, SDLK_SLASH,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::crazyMoves,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED},
    {"keyChangeCrazyMoveType",
        InputType::KEYBOARD, SDLK_BACKSLASH,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::changeCrazyMove,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED
            | InputCondition::EMODS},
    {"keyQuickDrop",
        InputType::KEYBOARD, SDLK_y,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::dropItem0,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED},
    {"keyQuickDropN",
        InputType::KEYBOARD, SDLK_u,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::dropItem,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED},
    {"keySwitchQuickDrop",
        InputType::KEYBOARD, SDLK_i,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::switchQuickDrop,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED},
    {"keyMagicInma1",
        InputType::KEYBOARD, SDLK_c,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::heal,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED},
    {"keyMagicItenplz",
        InputType::KEYBOARD, SDLK_m,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::itenplz,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED},
    {"keyMagicAttack",
        InputType::KEYBOARD, SDLK_b,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::magicAttack,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED},
    {"keySwitchMagicAttack",
        InputType::KEYBOARD, SDLK_COMMA,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::changeMagicAttackType,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED
            | InputCondition::EMODS},
    {"keySwitchPvpAttack",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::changePvpMode,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED
            | InputCondition::EMODS},
    {"keyInvertDirection",
        InputType::KEYBOARD, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::changeMoveType,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED
            | InputCondition::EMODS},
    {"keyChangeAttackWeaponType",
        InputType::KEYBOARD, SDLK_g,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::changeAttackWeaponType,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED
            | InputCondition::EMODS},
    {"keyChangeAttackType",
        InputType::KEYBOARD, SDLK_END,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::changeAttackType,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED
            | InputCondition::EMODS},
    {"keyChangeFollowMode",
        InputType::KEYBOARD, SDLK_KP1,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::changeFollowMode,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED
            | InputCondition::EMODS},
    {"keyChangeImitationMode",
        InputType::KEYBOARD, SDLK_KP4,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::changeImitationMode,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED
            | InputCondition::EMODS},
    {"keyDisableGameModifiers",
        InputType::KEYBOARD, SDLK_KP8,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::changeGameModifier,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED},
    {"keyChangeAudio",
        InputType::KEYBOARD, SDLK_KP3,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::changeAudio,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED},
    {"keyAway",
        InputType::KEYBOARD, SDLK_KP2,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::away,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED},
    {"keyRightClick",
        InputType::KEYBOARD, SDLK_TAB,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::mouseClick,
        InputAction::NO_VALUE, 50,
        InputCondition::NOINPUT | InputCondition::NOAWAY
            | InputCondition::NOMODAL | InputCondition::INGAME},
    {"keyCameraMode",
        InputType::KEYBOARD, SDLK_KP_PLUS,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::camera,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED
            | InputCondition::EMODS},
    {"keyMod",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        0,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIUp",
        InputType::KEYBOARD, SDLK_UP,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIDown",
        InputType::KEYBOARD, SDLK_DOWN,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUILeft",
        InputType::KEYBOARD, SDLK_LEFT,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIRight",
        InputType::KEYBOARD, SDLK_RIGHT,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUISelect",
        InputType::KEYBOARD, SDLK_SPACE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUISelect2",
        InputType::KEYBOARD, SDLK_RETURN,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUICancel",
        InputType::KEYBOARD, SDLK_ESCAPE,
#if defined(USE_SDL2) && defined(ANDROID)
        InputType::KEYBOARD, SDLK_AC_BACK,
#else
        InputType::UNKNOWN, InputAction::NO_VALUE,
#endif
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIHome",
        InputType::KEYBOARD, SDLK_HOME,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIEnd",
        InputType::KEYBOARD, SDLK_END,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIDelete",
        InputType::KEYBOARD, SDLK_DELETE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIBackSpace",
        InputType::KEYBOARD, SDLK_BACKSPACE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUITab",
        InputType::KEYBOARD, SDLK_TAB,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIPageUp",
        InputType::KEYBOARD, SDLK_PAGEUP,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIPageDown",
        InputType::KEYBOARD, SDLK_PAGEDOWN,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIInsert",
        InputType::KEYBOARD, SDLK_INSERT,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIMod",
        InputType::KEYBOARD, SDLK_LSHIFT,
        InputType::KEYBOARD, SDLK_RSHIFT,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keySafeVideo",
        InputType::KEYBOARD, SDLK_KP_MINUS,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::safeVideoMode,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyStopSit",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::stopSit,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT | InputCondition::INGAME},
    {"keyShowKeyboard",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::showKeyboard,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyShowWindows",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::showWindows,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyChatMod",
        InputType::KEYBOARD, SDLK_LSHIFT,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_CHAT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT | InputCondition::INGAME},
    {"keyMoveForward",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::moveForward,
        InputAction::NO_VALUE, 50,
        InputCondition::ARROWKEYS},
    {"keyGUICtrl",
        InputType::KEYBOARD, SDLK_LCTRL,
        InputType::KEYBOARD, SDLK_RCTRL,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIb",
        InputType::KEYBOARD, SDLK_b,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIc",
        InputType::KEYBOARD, SDLK_c,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUId",
        InputType::KEYBOARD, SDLK_d,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIe",
        InputType::KEYBOARD, SDLK_e,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIf",
        InputType::KEYBOARD, SDLK_f,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIh",
        InputType::KEYBOARD, SDLK_h,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIk",
        InputType::KEYBOARD, SDLK_k,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIu",
        InputType::KEYBOARD, SDLK_u,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIv",
        InputType::KEYBOARD, SDLK_v,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIw",
        InputType::KEYBOARD, SDLK_w,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyShortcutsPrevTab",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::prevShortcutsTab,
        InputAction::NO_VALUE, 50,
        InputCondition::NOINPUT | InputCondition::INGAME},
    {"keyShortcutsNextTab",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::nextShortcutsTab,
        InputAction::NO_VALUE, 50,
        InputCondition::NOINPUT | InputCondition::INGAME},
    {"keyCommandsPrevTab",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::prevCommandsTab,
        InputAction::NO_VALUE, 50,
        InputCondition::NOINPUT | InputCondition::INGAME},
    {"keyCommandsNextTab",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::nextCommandsTab,
        InputAction::NO_VALUE, 50,
        InputCondition::NOINPUT | InputCondition::INGAME},
    {"keyOpenTrade",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::openTrade,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET},

    {"keyGUIF1",
        InputType::KEYBOARD, SDLK_F1,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN | Input::GRP_CHAT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIF2",
        InputType::KEYBOARD, SDLK_F2,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN | Input::GRP_CHAT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIF3",
        InputType::KEYBOARD, SDLK_F3,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN | Input::GRP_CHAT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIF4",
        InputType::KEYBOARD, SDLK_F4,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN | Input::GRP_CHAT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIF5",
        InputType::KEYBOARD, SDLK_F5,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN | Input::GRP_CHAT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIF6",
        InputType::KEYBOARD, SDLK_F6,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN | Input::GRP_CHAT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIF7",
        InputType::KEYBOARD, SDLK_F7,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN | Input::GRP_CHAT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIF8",
        InputType::KEYBOARD, SDLK_F8,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN | Input::GRP_CHAT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIF9",
        InputType::KEYBOARD, SDLK_F9,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN | Input::GRP_CHAT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIF10",
        InputType::KEYBOARD, SDLK_F10,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN | Input::GRP_CHAT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIF11",
        InputType::KEYBOARD, SDLK_F11,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN | Input::GRP_CHAT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyGUIF12",
        InputType::KEYBOARD, SDLK_F12,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN | Input::GRP_CHAT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT},
    {"keyWindowAbout",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::aboutWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT0},
    {"keyWindowUpdater",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::updaterWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME},
    {"keyTargetClosestMonster",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_REPEAT,
        &ActionManager::targetClosestMonster,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET
            | InputCondition::VALIDSPEED}
};

#endif  // INPUT_INPUTACTIONMAP_H
