#!/usr/bin/env python

import os
import re

description = re.compile("^\.SH\s+\"?(BESCHREIBUNG|DESCRIPTION)", re.IGNORECASE)

for section in range(1, 9):
    for manpage in os.listdir("man%d" % section):
        file = open("man%d/%s" % (section, manpage))
        output = open("tmp.txt", "w")
        for line in file:
            if description.search(line):
                # Append the outdated warning
                output.write(".PP\n")
                output.write("Diese Handbuchseite ist eventuell veraltet. Im Zweifelsfall ziehen Sie\n")
                output.write("die englischsprachige Handbuchseite zu Rate, indem Sie\n")
                output.write(".IP\n")
                output.write("man -LC %d %s\n" % (section, manpage[:-2]))
                output.write(".PP\n")
                output.write("eingeben.\n")
            output.write(line)
        file.close()
        output.close()
        os.rename("tmp.txt", "man%d/%s" % (section, manpage))
