#!/usr/bin/env python

import os
import re

manpages = open("debian/manpages-de.prune")
for manpage in manpages:
    if re.search('^#', manpage):
        continue
    manpage = re.sub('/de\.[^/]+/', '/de/', manpage)[:-1]
    file = os.getcwd() + "/debian/manpages-de/" + manpage
    if os.path.lexists(file):
        print("Removed " + file)
        os.remove(file)
    file = os.getcwd() + "/debian/manpages-de-dev/" + manpage
    if os.path.lexists(file):
        print("Removed " + file)
        os.remove(file)

manpages.close()
